/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.gui.tables;

import javax.swing.JTable;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumnModel;
import org.xdat.Main;
import org.xdat.customEvents.DataTableModelEvent;
import org.xdat.data.DataSheet;

public class DataTable
extends JTable {
    static final long serialVersionUID = 1L;
    static final boolean printLog = false;
    private Main mainWindow;

    public DataTable(DataSheet dataSheet, TableColumnModel cm, Main mainWindow) {
        super(dataSheet, cm);
        this.mainWindow = mainWindow;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
        if (e.getType() == 999) {
            DataTableModelEvent ec = (DataTableModelEvent)e;
            boolean[] autofitRequired = ec.getAxisAutofitRequired();
            boolean[] resetFiltersRequired = ec.getAxisResetFilterRequired();
            boolean[] applyFiltersRequired = ec.getAxisApplyFiltersRequired();
            final ProgressMonitor progressMonitor = new ProgressMonitor(this.getParent(), "", "Rebuilding charts", 0, this.mainWindow.getDataSheet().getParameterCount() - 1);
            progressMonitor.setMillisToPopup(0);
            int i = 0;
            while (i < this.mainWindow.getDataSheet().getParameterCount() && !progressMonitor.isCanceled()) {
                final int progress = i;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        progressMonitor.setProgress(progress);
                    }
                });
                if (autofitRequired[i]) {
                    this.mainWindow.autofitAxisAllChartFrames(i);
                }
                if (resetFiltersRequired[i]) {
                    this.mainWindow.resetFiltersOnAxisAllChartFrames(i);
                }
                if (applyFiltersRequired[i]) {
                    this.mainWindow.refilterAllChartFrames(i);
                }
                ++i;
            }
            if (ec.isChartRebuildRequired()) {
                this.log("tableChanged: isChartRebuildRequired ");
                this.mainWindow.rebuildAllChartFrames();
            }
            if (ec.isChartRepaintRequired()) {
                this.log("tableChanged:isChartRepaintRequired  ");
                this.mainWindow.repaintAllChartFrames();
            }
            if (ec.isDataPanelUpdateRequired()) {
                this.log("tableChanged:isDataPanelUpdateRequired  ");
                this.mainWindow.updateDataPanel();
            }
            progressMonitor.close();
        }
    }

    private void log(String message) {
    }
}

