/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.gui.tables;

import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import org.xdat.Main;
import org.xdat.chart.Chart;
import org.xdat.chart.ParallelCoordinatesChart;
import org.xdat.data.DataSheet;

public class DataSheetTableColumnModel
extends DefaultTableColumnModel {
    static final long serialVersionUID = 2L;
    static final boolean printLog = false;
    private Main mainWindow;
    private DataSheet dataSheet;

    public DataSheetTableColumnModel(Main mainWindow, DataSheet dataSheet) {
        this.mainWindow = mainWindow;
        this.dataSheet = dataSheet;
        this.setColumnMargin(1);
    }

    @Override
    public boolean getColumnSelectionAllowed() {
        return false;
    }

    @Override
    public void moveColumn(int src, int tar) {
        if (src != 0 && tar != 0) {
            super.moveColumn(src, tar);
            if (src != tar) {
                this.dataSheet.moveParameter(src - 1, tar - 1);
                int i = 0;
                while (i < this.getColumnCount()) {
                    this.getColumn(i).setModelIndex(i);
                    ++i;
                }
                Chart[] charts = new Chart[this.mainWindow.getCurrentSession().getChartCount()];
                int i2 = 0;
                while (i2 < charts.length) {
                    charts[i2] = this.mainWindow.getCurrentSession().getChart(i2);
                    if (charts[i2].getClass().equals(ParallelCoordinatesChart.class)) {
                        ((ParallelCoordinatesChart)charts[i2]).moveAxis(src - 1, tar - 1);
                    }
                    ++i2;
                }
                this.mainWindow.repaintAllChartFrames();
            }
        }
    }

    @Override
    public void removeColumn(TableColumn arg0) {
    }

    private void log(String message) {
    }
}

