/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.gui.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import org.xdat.Main;
import org.xdat.chart.Chart;
import org.xdat.gui.buttons.CustomButton;
import org.xdat.gui.frames.ChartFrame;
import org.xdat.gui.panels.ChartPanel;

public abstract class SidebarPanel
extends JPanel {
    static final long serialVersionUID = 0L;
    static final boolean printLog = false;
    private Main mainWindow;
    private ChartFrame chartFrame;
    private ChartPanel chartPanel;
    private JPanel contentPanel;
    private JPanel headerPanel;
    private Chart chart;

    public SidebarPanel(Main mainWindow, ChartFrame chartFrame, ChartPanel chartPanel, Chart chart) {
        this.mainWindow = mainWindow;
        this.chartFrame = chartFrame;
        this.chartPanel = chartPanel;
        this.chart = chart;
        this.headerPanel = new JPanel();
        this.contentPanel = new JPanel();
        this.initialize();
        this.updateView(true);
    }

    private void updateView(boolean maximized) {
        this.buildHeaderPanel(maximized);
        this.setLayout(new BorderLayout());
        this.add((Component)this.headerPanel, "North");
        this.contentPanel.removeAll();
        if (maximized) {
            this.buildPanel(this.contentPanel);
            this.add((Component)this.contentPanel, "Center");
        }
        this.chartFrame.validate();
        this.chartFrame.repaint();
    }

    private void buildHeaderPanel(final boolean maximized) {
        this.headerPanel.removeAll();
        this.headerPanel.setLayout(new BorderLayout());
        CustomButton toggleButton = maximized ? new CustomButton("Collapse", "images/minimize.png", "images/minimize_pressed.png", "Collapse") : new CustomButton("Expand", "images/maximize.png", "images/maximize_pressed.png", "Expand");
        this.headerPanel.add((Component)toggleButton, "West");
        toggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SidebarPanel.this.updateView(!maximized);
            }
        });
    }

    public Main getMainWindow() {
        return this.mainWindow;
    }

    public Chart getChart() {
        return this.chart;
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }

    public ChartFrame getChartFrame() {
        return this.chartFrame;
    }

    protected abstract void buildPanel(JPanel var1);

    protected abstract void initialize();

    private void log(String message) {
    }
}

