/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.gui.panels;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.xdat.Main;
import org.xdat.actionListeners.parallelCoordinatesChartFrame.ParallelChartSidebarActionListener;
import org.xdat.chart.ParallelCoordinatesChart;
import org.xdat.data.Cluster;
import org.xdat.data.ClusterListener;
import org.xdat.data.ClusterSet;
import org.xdat.gui.buttons.ColorChoiceButton;
import org.xdat.gui.frames.ChartFrame;
import org.xdat.gui.panels.ChartPanel;
import org.xdat.gui.panels.ParallelCoordinatesChartPanel;
import org.xdat.gui.panels.SidebarPanel;

public class ParallelCoordinatesChartSidebarPanel
extends SidebarPanel {
    static final long serialVersionUID = 0L;
    static final boolean printLog = false;
    private static final Color CLUSTER_NAME_TEXT_FIELD_EDITING_COLOR = new Color(255, 205, 51);
    private static final Color CLUSTER_NAME_TEXT_FIELD_STANDARD_COLOR = new Color(230, 230, 230);
    private ParallelChartSidebarActionListener cmd;
    private ColorChoiceButton activeDesignColorButton;
    private JSlider activeDesignAlphaSlider;
    private JButton newClusterButton;
    private JScrollPane clusterScrollPane;
    private JPanel clusterPanel;
    private HashMap<Cluster, JSlider> clusterAlphaSliders;
    private Hashtable<ClusterListener, Cluster> clusterListeners;

    public ParallelCoordinatesChartSidebarPanel(Main mainWindow, ChartFrame chartFrame, ChartPanel chartPanel, ParallelCoordinatesChart chart) {
        super(mainWindow, chartFrame, chartPanel, chart);
    }

    @Override
    protected void buildPanel(JPanel parentPanel) {
        ParallelCoordinatesChart chart = (ParallelCoordinatesChart)this.getChart();
        parentPanel.setLayout(new BorderLayout());
        JPanel generalControlsPanel = new JPanel(new FlowLayout(3));
        generalControlsPanel.setPreferredSize(new Dimension(195, 140));
        parentPanel.add((Component)generalControlsPanel, "North");
        JPanel activeDesignColorButtonPanel = new JPanel(new FlowLayout(1));
        JLabel activeDesignColorLabel = new JLabel("Active Design Color");
        activeDesignColorButtonPanel.add(activeDesignColorLabel);
        this.activeDesignColorButton = new ColorChoiceButton(chart.getDefaultDesignColor(true, chart.isUseAlpha()), "Active Design Color");
        this.activeDesignColorButton.addActionListener(this.cmd);
        activeDesignColorButtonPanel.add(this.activeDesignColorButton);
        generalControlsPanel.add(activeDesignColorButtonPanel);
        JPanel activeDesignAlphaSliderLabelPanel = new JPanel(new FlowLayout(1));
        JPanel activeDesignAlphaSliderPanel = new JPanel(new FlowLayout(1));
        activeDesignAlphaSliderLabelPanel.setPreferredSize(new Dimension(180, 20));
        activeDesignAlphaSliderPanel.setPreferredSize(new Dimension(180, 30));
        generalControlsPanel.add(activeDesignAlphaSliderLabelPanel);
        generalControlsPanel.add(activeDesignAlphaSliderPanel);
        JLabel activeDesignAlphaLabel = new JLabel("Transparency");
        activeDesignAlphaSliderLabelPanel.add(activeDesignAlphaLabel);
        this.activeDesignAlphaSlider = new JSlider(0, 0, 255, 0);
        this.activeDesignAlphaSlider.addChangeListener(this.cmd);
        this.activeDesignAlphaSlider.setName("activeDesignAlphaSlider");
        this.activeDesignAlphaSlider.setPreferredSize(new Dimension(120, 30));
        activeDesignAlphaSliderPanel.add(this.activeDesignAlphaSlider);
        JPanel addClusterButtonPanel = new JPanel(new FlowLayout(1));
        addClusterButtonPanel.setPreferredSize(new Dimension(180, 35));
        this.newClusterButton = new JButton("Add Cluster");
        this.newClusterButton.addActionListener(this.cmd);
        addClusterButtonPanel.add(this.newClusterButton);
        generalControlsPanel.add(addClusterButtonPanel);
        parentPanel.add((Component)this.clusterScrollPane, "Center");
        JPanel contentPanel = new JPanel(new FlowLayout(4));
        this.clusterScrollPane.setViewportView(contentPanel);
        this.clusterPanel = new JPanel(new GridLayout(0, 1));
        contentPanel.add(this.clusterPanel);
        this.activeDesignColorButton.setCurrentColor(chart.getDefaultDesignColor(true, chart.isUseAlpha()));
        if (chart.isUseAlpha()) {
            this.activeDesignAlphaSlider.setValue(chart.getDefaultDesignColor(true, chart.isUseAlpha()).getAlpha());
        } else {
            this.activeDesignAlphaSlider.setValue(255);
            this.activeDesignAlphaSlider.setEnabled(false);
        }
        this.linkColorButtonToSlider(this.activeDesignColorButton, this.activeDesignAlphaSlider);
        this.updateClusterList(this.getMainWindow().getDataSheet().getClusterSet());
        this.validate();
    }

    public void setActionListener(ParallelChartSidebarActionListener cmd) {
        this.cmd = cmd;
    }

    public ParallelChartSidebarActionListener getChartDisplaySettingsActionListener() {
        return this.cmd;
    }

    public ColorChoiceButton getActiveDesignColorButton() {
        return this.activeDesignColorButton;
    }

    public JSlider getActiveDesignAlphaSlider() {
        return this.activeDesignAlphaSlider;
    }

    public JSlider getClusterAlphaSlider(Cluster cluster) {
        if (this.clusterAlphaSliders.containsKey(cluster)) {
            return this.clusterAlphaSliders.get(cluster);
        }
        return null;
    }

    public void updateClusterList(ClusterSet clusterSet) {
        int clusterCount = clusterSet.getClusterCount();
        for (ClusterListener l : this.clusterListeners.keySet()) {
            this.clusterListeners.get(l).removeClusterListener(l);
        }
        this.clusterPanel.removeAll();
        this.clusterPanel.setLayout(new GridLayout(clusterCount, 1));
        this.clusterAlphaSliders.clear();
        int i = 0;
        while (i < clusterCount) {
            final Cluster cluster = clusterSet.getCluster(i);
            JPanel wrapperPanel = new JPanel(new GridLayout(5, 1));
            final JTextField clusterNameTextField = new JTextField();
            clusterNameTextField.setEditable(true);
            clusterNameTextField.setBackground(CLUSTER_NAME_TEXT_FIELD_STANDARD_COLOR);
            clusterNameTextField.setToolTipText("Click to edit cluster name");
            clusterNameTextField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    ParallelCoordinatesChartSidebarPanel.this.handleUpdateUpdatedClusterName(clusterNameTextField, cluster, event.getActionCommand());
                }
            });
            clusterNameTextField.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent arg0) {
                    clusterNameTextField.setBackground(CLUSTER_NAME_TEXT_FIELD_STANDARD_COLOR);
                    clusterNameTextField.setToolTipText("Click to edit cluster name");
                    ParallelCoordinatesChartSidebarPanel.this.handleUpdateUpdatedClusterName(clusterNameTextField, cluster, clusterNameTextField.getText());
                }

                @Override
                public void focusGained(FocusEvent arg0) {
                    clusterNameTextField.setBackground(CLUSTER_NAME_TEXT_FIELD_EDITING_COLOR);
                    clusterNameTextField.setToolTipText(null);
                }
            });
            wrapperPanel.add(clusterNameTextField);
            JPanel clusterButtonPanel = new JPanel(new BorderLayout());
            wrapperPanel.add(clusterButtonPanel);
            final ColorChoiceButton clusterColorButton = new ColorChoiceButton(cluster.getActiveDesignColor(true), "clusterColor", 20, 25);
            clusterColorButton.addActionListener(this.cmd);
            clusterButtonPanel.add((Component)clusterColorButton, "West");
            final JButton removeClusterButton = new JButton("Remove");
            removeClusterButton.addActionListener(this.cmd);
            clusterButtonPanel.add((Component)removeClusterButton, "Center");
            final JButton applyClusterButton = new JButton("Apply");
            applyClusterButton.addActionListener(this.cmd);
            clusterButtonPanel.add((Component)applyClusterButton, "East");
            JLabel clusterAlphaLabel = new JLabel("Transparency");
            wrapperPanel.add(clusterAlphaLabel);
            final JSlider clusterAlphaSlider = new JSlider(0, 0, 255, cluster.getActiveDesignColor(true).getAlpha());
            this.clusterAlphaSliders.put(cluster, clusterAlphaSlider);
            clusterAlphaSlider.setPreferredSize(new Dimension(150, 10));
            clusterAlphaSlider.addChangeListener(this.cmd);
            wrapperPanel.add(clusterAlphaSlider);
            this.linkColorButtonToSlider(clusterColorButton, clusterAlphaSlider);
            final JCheckBox clusterActiveCheckbox = new JCheckBox("Active");
            clusterActiveCheckbox.addActionListener(this.cmd);
            clusterActiveCheckbox.setSelected(cluster.isActive());
            wrapperPanel.add(clusterActiveCheckbox);
            this.updateElementNames(cluster.getName(), clusterNameTextField, clusterColorButton, removeClusterButton, applyClusterButton, clusterAlphaSlider, clusterActiveCheckbox);
            ClusterListener listener = new ClusterListener(){

                @Override
                public void onNameChanged(Cluster source, String newName) {
                    ParallelCoordinatesChartSidebarPanel.this.updateElementNames(newName, clusterNameTextField, clusterColorButton, removeClusterButton, applyClusterButton, clusterAlphaSlider, clusterActiveCheckbox);
                    ParallelCoordinatesChartSidebarPanel.this.revalidate();
                    ParallelCoordinatesChartSidebarPanel.this.repaint();
                }
            };
            cluster.addClusterListener(listener);
            this.clusterListeners.put(listener, cluster);
            this.clusterPanel.add(wrapperPanel);
            ++i;
        }
        this.revalidate();
        this.repaint();
    }

    private void linkColorButtonToSlider(final ColorChoiceButton colorButton, JSlider clusterAlphaSlider) {
        clusterAlphaSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                Object source = event.getSource();
                if (source instanceof JSlider) {
                    JSlider slider = (JSlider)source;
                    int value = Math.min(slider.getValue(), 255);
                    colorButton.setAlpha(value);
                }
            }
        });
    }

    private void updateElementNames(String name, JTextField clusterNameLabel, JButton clusterColorButton, JButton removeClusterButton, JButton applyClusterButton, JSlider clusterAlphaSlider, JCheckBox clusterActiveCheckbox) {
        if (!clusterNameLabel.getText().equals(name)) {
            clusterNameLabel.setText(name);
        }
        clusterColorButton.setName(name);
        removeClusterButton.setName(name);
        applyClusterButton.setName(name);
        clusterAlphaSlider.setName(name);
        clusterActiveCheckbox.setName(name);
    }

    private void handleUpdateUpdatedClusterName(JTextField source, Cluster cluster, String newName) {
        if (newName == null || newName.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Invalid cluster name: \"" + newName + "\"", "Error on renaming cluster", 0);
            source.setText(cluster.getName());
        }
        if (newName.equals(cluster.getName())) {
            return;
        }
        cluster.setName(newName);
    }

    @Override
    protected void initialize() {
        this.clusterScrollPane = new JScrollPane();
        this.clusterScrollPane.setVerticalScrollBarPolicy(20);
        this.clusterListeners = new Hashtable();
        this.clusterAlphaSliders = new LinkedHashMap<Cluster, JSlider>(10);
        this.cmd = new ParallelChartSidebarActionListener(this.getMainWindow(), this, (ParallelCoordinatesChartPanel)this.getChartPanel());
    }

    private void log(String message) {
    }

    public void setAlphaSlidersEnabled(boolean enabled) {
        this.activeDesignAlphaSlider.setEnabled(enabled);
        for (JSlider slider : this.clusterAlphaSliders.values()) {
            slider.setEnabled(enabled);
        }
    }
}

