/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.gui.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import org.xdat.Main;
import org.xdat.UserPreferences;
import org.xdat.actionListeners.parallelCoordinatesDisplaySettings.ChartSpecificDisplaySettingsDialogActionListener;
import org.xdat.actionListeners.parallelCoordinatesDisplaySettings.DefaultDisplaySettingsDialogActionListener;
import org.xdat.actionListeners.parallelCoordinatesDisplaySettings.ParallelChartDisplaySettingsActionListener;
import org.xdat.chart.ParallelCoordinatesChart;
import org.xdat.gui.buttons.ColorChoiceButton;
import org.xdat.gui.buttons.MinMaxSpinnerModel;
import org.xdat.gui.dialogs.ParallelCoordinatesDisplaySettingsDialog;
import org.xdat.gui.frames.ChartFrame;
import org.xdat.gui.panels.TitledSubPanel;

public class ParallelCoordinatesChartDisplaySettingsPanel
extends JPanel {
    static final long serialVersionUID = 0L;
    static final boolean printLog = false;
    private Main mainWindow;
    private ParallelCoordinatesDisplaySettingsDialog dialog;
    private ChartFrame chartFrame;
    private ParallelChartDisplaySettingsActionListener cmd;
    private JCheckBox axisLabelVerticalOffsetCheckbox = new JCheckBox();
    private JCheckBox antiasingCheckbox = new JCheckBox();
    private JCheckBox alphaCheckbox = new JCheckBox();
    private ColorChoiceButton backGroundColorButton;
    private ColorChoiceButton activeDesignColorButton;
    private ColorChoiceButton selectedDesignColorButton;
    private ColorChoiceButton filteredDesignColorButton;
    private ColorChoiceButton filterColorButton;
    private JCheckBox showOnlySelectedDesignsCheckBox = new JCheckBox();
    private JRadioButton showfilteredDesignsTrueButton = new JRadioButton("Yes");
    private JRadioButton showfilteredDesignsFalseButton = new JRadioButton("No");
    private JRadioButton showDesignIDsTrueButton = new JRadioButton("Yes");
    private JRadioButton showDesignIDsFalseButton = new JRadioButton("No");
    private ButtonGroup showfilteredDesignsButtonGroup = new ButtonGroup();
    private ButtonGroup showDesignIDsButtonGroup = new ButtonGroup();
    private JSpinner designLineThicknessSpinner = new JSpinner(new MinMaxSpinnerModel(0, 10));
    private JSpinner selectedDesignLineThicknessSpinner = new JSpinner(new MinMaxSpinnerModel(0, 10));
    private JSpinner designLabelFontSizeSpinner = new JSpinner(new MinMaxSpinnerModel(0, 100));
    private JSpinner filterWidthSpinner = new JSpinner(new MinMaxSpinnerModel(1, 30));
    private JSpinner filterHeightSpinner = new JSpinner(new MinMaxSpinnerModel(1, 60));
    private JButton cancelButton = new JButton("Cancel");
    private JButton okButton = new JButton("Ok");

    public ParallelCoordinatesChartDisplaySettingsPanel(Main mainWindow, ParallelCoordinatesDisplaySettingsDialog dialog) {
        this.mainWindow = mainWindow;
        this.dialog = dialog;
        this.buildPanel();
        this.axisLabelVerticalOffsetCheckbox.setSelected(UserPreferences.getInstance().isParallelCoordinatesVerticallyOffsetAxisLabels());
        this.antiasingCheckbox.setSelected(UserPreferences.getInstance().isAntiAliasing());
        this.alphaCheckbox.setSelected(UserPreferences.getInstance().isUseAlpha());
        this.setShowFilteredDesignsSelection(UserPreferences.getInstance().isParallelCoordinatesShowFilteredDesigns());
        this.setShowDesignIDsSelection(UserPreferences.getInstance().isParallelCoordinatesShowDesignIDs());
        this.designLabelFontSizeSpinner.setValue(UserPreferences.getInstance().getParallelCoordinatesDesignLabelFontSize());
        this.designLineThicknessSpinner.setValue(UserPreferences.getInstance().getParallelCoordinatesLineThickness());
        this.selectedDesignLineThicknessSpinner.setValue(UserPreferences.getInstance().getParallelCoordinatesSelectedDesignLineThickness());
        this.backGroundColorButton.setCurrentColor(UserPreferences.getInstance().getParallelCoordinatesDefaultBackgroundColor());
        this.activeDesignColorButton.setCurrentColor(UserPreferences.getInstance().getParallelCoordinatesActiveDesignDefaultColor());
        this.selectedDesignColorButton.setCurrentColor(UserPreferences.getInstance().getParallelCoordinatesSelectedDesignDefaultColor());
        this.filteredDesignColorButton.setCurrentColor(UserPreferences.getInstance().getParallelCoordinatesFilteredDesignDefaultColor());
        this.filterColorButton.setCurrentColor(UserPreferences.getInstance().getParallelCoordinatesFilterDefaultColor());
        this.showOnlySelectedDesignsCheckBox.setSelected(UserPreferences.getInstance().isParallelCoordinatesShowOnlySelectedDesigns());
        this.filterWidthSpinner.setValue(UserPreferences.getInstance().getParallelCoordinatesFilterWidth());
        this.filterHeightSpinner.setValue(UserPreferences.getInstance().getParallelCoordinatesFilterHeight());
    }

    public ParallelCoordinatesChartDisplaySettingsPanel(Main mainWindow, ParallelCoordinatesDisplaySettingsDialog dialog, ChartFrame chartFrame) {
        this.mainWindow = mainWindow;
        this.dialog = dialog;
        this.chartFrame = chartFrame;
        ParallelCoordinatesChart c = (ParallelCoordinatesChart)chartFrame.getChart();
        this.buildPanel();
        this.axisLabelVerticalOffsetCheckbox.setSelected(c.isVerticallyOffsetAxisLabels());
        this.antiasingCheckbox.setSelected(c.isAntiAliasing());
        this.alphaCheckbox.setSelected(c.isUseAlpha());
        this.setShowFilteredDesignsSelection(c.isShowFilteredDesigns());
        this.setShowDesignIDsSelection(c.isShowDesignIDs());
        this.designLabelFontSizeSpinner.setValue(c.getDesignLabelFontSize());
        this.designLineThicknessSpinner.setValue(c.getLineThickness());
        this.selectedDesignLineThicknessSpinner.setValue(c.getSelectedDesignsLineThickness());
        this.backGroundColorButton.setCurrentColor(c.getBackGroundColor());
        this.activeDesignColorButton.setCurrentColor(c.getDefaultDesignColor(true, chartFrame.getChart().isUseAlpha()));
        this.selectedDesignColorButton.setCurrentColor(c.getSelectedDesignColor());
        this.filteredDesignColorButton.setCurrentColor(c.getDefaultDesignColor(false, chartFrame.getChart().isUseAlpha()));
        this.filterColorButton.setCurrentColor(c.getFilterColor());
        this.showOnlySelectedDesignsCheckBox.setSelected(c.isShowOnlySelectedDesigns());
        this.filterWidthSpinner.setValue(c.getFilterWidth());
        this.filterHeightSpinner.setValue(c.getFilterHeight());
    }

    private void buildPanel() {
        this.backGroundColorButton = new ColorChoiceButton(UserPreferences.getInstance().getParallelCoordinatesDefaultBackgroundColor(), "Background Color");
        this.activeDesignColorButton = new ColorChoiceButton(UserPreferences.getInstance().getParallelCoordinatesActiveDesignDefaultColor(), "Active Design Color");
        this.selectedDesignColorButton = new ColorChoiceButton(UserPreferences.getInstance().getParallelCoordinatesSelectedDesignDefaultColor(), "Selected Design Color");
        this.filteredDesignColorButton = new ColorChoiceButton(UserPreferences.getInstance().getParallelCoordinatesFilteredDesignDefaultColor(), "Filtered Design Color");
        this.filterColorButton = new ColorChoiceButton(UserPreferences.getInstance().getParallelCoordinatesFilterDefaultColor(), "Filter Color");
        TitledSubPanel contentPanel = new TitledSubPanel("");
        JPanel contentInnerPanel = new JPanel(new BorderLayout());
        JPanel labelPanel = new JPanel(new GridLayout(0, 1));
        JPanel controlsPanel = new JPanel(new GridLayout(0, 1));
        TitledSubPanel buttonsPanel = new TitledSubPanel("");
        JPanel showfilteredDesignsRadioButtonsPanel = new JPanel(new GridLayout(1, 2));
        JPanel showDesignIDsRadioButtonsPanel = new JPanel(new GridLayout(1, 2));
        JLabel axisLabelVerticalOffsetLabel = new JLabel("Offset Axis Labels");
        JLabel antiAliasingLabel = new JLabel("Use Anti Aliasing");
        JLabel useAlphaLabel = new JLabel("Use Transparency");
        JLabel backGroundColorLabel = new JLabel("Background Color");
        JLabel activeDesignColorLabel = new JLabel("Active Design Color");
        JLabel selectedDesignColorLabel = new JLabel("Selected Design Color");
        JLabel filteredDesignColorLabel = new JLabel("Filtered Design Color");
        JLabel filterColorLabel = new JLabel("Filter Color");
        JLabel showOnlySelectedDesignsLabel = new JLabel("Show only selected Designs");
        JLabel showfilteredDesignsLabel = new JLabel("Show filtered Designs");
        JLabel showDesignIDsLabel = new JLabel("Show Design IDs");
        this.showfilteredDesignsButtonGroup.add(this.showfilteredDesignsTrueButton);
        this.showfilteredDesignsButtonGroup.add(this.showfilteredDesignsFalseButton);
        this.showDesignIDsButtonGroup.add(this.showDesignIDsTrueButton);
        this.showDesignIDsButtonGroup.add(this.showDesignIDsFalseButton);
        JLabel designLabelFontSizeLabel = new JLabel("Design Label Font Size ");
        JLabel designLineThicknessLabel = new JLabel("Design Line Thickness ");
        JLabel selectedDesignLineThicknessLabel = new JLabel("Selected Design Line Thickness ");
        JLabel filterWidthLabel = new JLabel("Filter Symbol Width");
        JLabel filterHeightLabel = new JLabel("Filter Symbol Height");
        JPanel cancelButtonPanel = new JPanel();
        JPanel okButtonPanel = new JPanel();
        this.setLayout(new BorderLayout());
        contentPanel.setLayout(new BorderLayout());
        cancelButtonPanel.setLayout(new FlowLayout(2));
        okButtonPanel.setLayout(new FlowLayout(0));
        buttonsPanel.setLayout(new GridLayout(1, 2));
        this.add((Component)contentPanel, "Center");
        contentPanel.add((Component)contentInnerPanel, "North");
        contentInnerPanel.add((Component)labelPanel, "Center");
        contentInnerPanel.add((Component)controlsPanel, "East");
        this.add((Component)buttonsPanel, "South");
        labelPanel.add(axisLabelVerticalOffsetLabel);
        JPanel axisLabelVerticalOffsetCheckboxPanel = new JPanel(new FlowLayout(0));
        axisLabelVerticalOffsetCheckboxPanel.add(this.axisLabelVerticalOffsetCheckbox);
        controlsPanel.add(axisLabelVerticalOffsetCheckboxPanel);
        labelPanel.add(antiAliasingLabel);
        JPanel antiAliasingCheckboxPanel = new JPanel(new FlowLayout(0));
        antiAliasingCheckboxPanel.add(this.antiasingCheckbox);
        controlsPanel.add(antiAliasingCheckboxPanel);
        labelPanel.add(useAlphaLabel);
        JPanel alphaCheckboxPanel = new JPanel(new FlowLayout(0));
        alphaCheckboxPanel.add(this.alphaCheckbox);
        controlsPanel.add(alphaCheckboxPanel);
        labelPanel.add(backGroundColorLabel);
        JPanel backGroundColorButtonPanel = new JPanel(new FlowLayout(0));
        backGroundColorButtonPanel.add(this.backGroundColorButton);
        controlsPanel.add(backGroundColorButtonPanel);
        labelPanel.add(activeDesignColorLabel);
        JPanel activeDesignColorButtonPanel = new JPanel(new FlowLayout(0));
        controlsPanel.add(activeDesignColorButtonPanel);
        activeDesignColorButtonPanel.add(this.activeDesignColorButton);
        labelPanel.add(selectedDesignColorLabel);
        JPanel selectedDesignColorButtonPanel = new JPanel(new FlowLayout(0));
        controlsPanel.add(selectedDesignColorButtonPanel);
        selectedDesignColorButtonPanel.add(this.selectedDesignColorButton);
        labelPanel.add(filteredDesignColorLabel);
        JPanel filteredDesignColorButtonPanel = new JPanel(new FlowLayout(0));
        filteredDesignColorButtonPanel.add(this.filteredDesignColorButton);
        controlsPanel.add(filteredDesignColorButtonPanel);
        labelPanel.add(filterColorLabel);
        JPanel filterColorButtonPanel = new JPanel(new FlowLayout(0));
        filterColorButtonPanel.add(this.filterColorButton);
        controlsPanel.add(filterColorButtonPanel);
        labelPanel.add(showfilteredDesignsLabel);
        controlsPanel.add(showfilteredDesignsRadioButtonsPanel);
        showfilteredDesignsRadioButtonsPanel.add(this.showfilteredDesignsTrueButton);
        showfilteredDesignsRadioButtonsPanel.add(this.showfilteredDesignsFalseButton);
        labelPanel.add(showDesignIDsLabel);
        controlsPanel.add(showDesignIDsRadioButtonsPanel);
        labelPanel.add(showOnlySelectedDesignsLabel);
        JPanel showOnlySelectedDesignsCheckboxPanel = new JPanel(new FlowLayout(0));
        showOnlySelectedDesignsCheckboxPanel.add(this.showOnlySelectedDesignsCheckBox);
        controlsPanel.add(showOnlySelectedDesignsCheckboxPanel);
        labelPanel.add(designLabelFontSizeLabel);
        controlsPanel.add(this.designLabelFontSizeSpinner);
        labelPanel.add(selectedDesignLineThicknessLabel);
        controlsPanel.add(this.selectedDesignLineThicknessSpinner);
        labelPanel.add(designLineThicknessLabel);
        controlsPanel.add(this.designLineThicknessSpinner);
        showDesignIDsRadioButtonsPanel.add(this.showDesignIDsTrueButton);
        showDesignIDsRadioButtonsPanel.add(this.showDesignIDsFalseButton);
        this.showfilteredDesignsTrueButton.setActionCommand("showfilteredDesignsTrue");
        this.showfilteredDesignsFalseButton.setActionCommand("showfilteredDesignsFalse");
        this.showDesignIDsTrueButton.setActionCommand("showDesignIDsTrue");
        this.showDesignIDsFalseButton.setActionCommand("showDesignIDsFalse");
        labelPanel.add(filterWidthLabel);
        controlsPanel.add(this.filterWidthSpinner);
        labelPanel.add(filterHeightLabel);
        controlsPanel.add(this.filterHeightSpinner);
        buttonsPanel.add(cancelButtonPanel);
        buttonsPanel.add(okButtonPanel);
        cancelButtonPanel.add(this.cancelButton);
        okButtonPanel.add(this.okButton);
    }

    public void setActionListener(ParallelChartDisplaySettingsActionListener cmd) {
        this.cmd = cmd;
        this.backGroundColorButton.addActionListener(cmd);
        this.activeDesignColorButton.addActionListener(cmd);
        this.selectedDesignColorButton.addActionListener(cmd);
        this.filteredDesignColorButton.addActionListener(cmd);
        this.filterColorButton.addActionListener(cmd);
        this.showfilteredDesignsTrueButton.addActionListener(cmd);
        this.showfilteredDesignsFalseButton.addActionListener(cmd);
        this.showDesignIDsTrueButton.addActionListener(cmd);
        this.showDesignIDsFalseButton.addActionListener(cmd);
    }

    public void setOkCancelButtonTargetDefaultSettings() {
        DefaultDisplaySettingsDialogActionListener cmd = new DefaultDisplaySettingsDialogActionListener(this.dialog);
        this.log("setOkCancelButtonTargetDefaultSettings called");
        this.cancelButton.addActionListener(cmd);
        this.okButton.addActionListener(cmd);
    }

    public void setOkCancelButtonTargetChart(ParallelCoordinatesChart chart) {
        this.log("setOkCancelButtonTargetChart called");
        this.cancelButton.addActionListener(new ChartSpecificDisplaySettingsDialogActionListener(this.mainWindow, this.dialog, chart, this.chartFrame));
        this.okButton.addActionListener(new ChartSpecificDisplaySettingsDialogActionListener(this.mainWindow, this.dialog, chart, this.chartFrame));
    }

    public ParallelChartDisplaySettingsActionListener getChartDisplaySettingsActionListener() {
        return this.cmd;
    }

    public boolean getShowFilteredDesignsSelection() {
        return this.showfilteredDesignsTrueButton.getModel().equals(this.showfilteredDesignsButtonGroup.getSelection());
    }

    public void setShowFilteredDesignsSelection(boolean showFilteredDesignsSelection) {
        if (showFilteredDesignsSelection) {
            this.showfilteredDesignsButtonGroup.setSelected(this.showfilteredDesignsTrueButton.getModel(), true);
        } else {
            this.showfilteredDesignsButtonGroup.setSelected(this.showfilteredDesignsFalseButton.getModel(), true);
        }
    }

    public boolean getShowDesignIDsSelection() {
        return this.showfilteredDesignsTrueButton.getModel().equals(this.showfilteredDesignsButtonGroup.getSelection());
    }

    public void setShowDesignIDsSelection(boolean showFilteredDesignsSelection) {
        this.log("setShowDesignIDsSelection: argument is " + showFilteredDesignsSelection);
        if (showFilteredDesignsSelection) {
            this.showDesignIDsButtonGroup.setSelected(this.showDesignIDsTrueButton.getModel(), true);
        } else {
            this.showDesignIDsButtonGroup.setSelected(this.showDesignIDsFalseButton.getModel(), true);
        }
    }

    public JSpinner getDesignLabelFontSizeSpinner() {
        return this.designLabelFontSizeSpinner;
    }

    public JSpinner getDesignLineThicknessSpinner() {
        return this.designLineThicknessSpinner;
    }

    public JSpinner getSelectedDesignLineThicknessSpinner() {
        return this.selectedDesignLineThicknessSpinner;
    }

    public JCheckBox getAxisLabelVerticalOffsetCheckbox() {
        return this.axisLabelVerticalOffsetCheckbox;
    }

    public JCheckBox getAntiAliasingCheckbox() {
        return this.antiasingCheckbox;
    }

    public JCheckBox getAlphaCheckbox() {
        return this.alphaCheckbox;
    }

    public JCheckBox getShowOnlySelectedDesignsCheckBox() {
        return this.showOnlySelectedDesignsCheckBox;
    }

    public ColorChoiceButton getActiveDesignColorButton() {
        return this.activeDesignColorButton;
    }

    public ColorChoiceButton getSelectedDesignColorButton() {
        return this.selectedDesignColorButton;
    }

    public ColorChoiceButton getBackGroundColorButton() {
        return this.backGroundColorButton;
    }

    public ColorChoiceButton getFilterColorButton() {
        return this.filterColorButton;
    }

    public ColorChoiceButton getFilteredDesignColorButton() {
        return this.filteredDesignColorButton;
    }

    public JSpinner getFilterHeightSpinner() {
        return this.filterHeightSpinner;
    }

    public JSpinner getFilterWidthSpinner() {
        return this.filterWidthSpinner;
    }

    private void log(String message) {
    }
}

