/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.gui.panels;

import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;
import org.xdat.chart.Chart;
import org.xdat.data.DataSheet;

public abstract class ChartPanel
extends JPanel {
    static final long serialVersionUID = 1L;
    static final boolean printLog = false;
    private Chart chart;
    private DataSheet dataSheet;
    private int marginTop = 20;
    private int marginBottom = 80;
    private int marginLeft = 80;
    private int marginRight = 20;

    public ChartPanel(DataSheet dataSheet, Chart chart) {
        this.log("constructor called");
        this.dataSheet = dataSheet;
        this.chart = chart;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.setBackground(this.chart.getBackGroundColor());
        this.drawPlotFieldBackground(g);
    }

    public void drawPlotFieldBackground(Graphics g) {
        g.setColor(this.chart.getBackGroundColor());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    public Dimension getPreferredSize() {
        int width = this.marginLeft + this.marginRight + this.chart.getWidth();
        int height = this.marginTop + this.marginBottom + this.chart.getHeight();
        Dimension preferredSize = new Dimension(width, height);
        return preferredSize;
    }

    public int getMarginTop() {
        return this.marginTop;
    }

    public int getMarginBottom() {
        return this.marginBottom;
    }

    public int getMarginLeft() {
        return this.marginLeft;
    }

    public int getMarginRight() {
        return this.marginRight;
    }

    public Chart getChart() {
        return this.chart;
    }

    public DataSheet getDataSheet() {
        return this.dataSheet;
    }

    private void log(String message) {
    }
}

