/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import org.xdat.Main;
import org.xdat.actionListeners.scatter2DChartSettings.ParallelChartFrameComboModel;
import org.xdat.actionListeners.scatter2DChartSettings.Scatter2DChartDisplaySettingsActionListener;
import org.xdat.chart.ScatterChart2D;
import org.xdat.gui.buttons.ColorChoiceButton;
import org.xdat.gui.buttons.MinMaxSpinnerModel;
import org.xdat.gui.frames.ChartFrame;
import org.xdat.gui.panels.Scatter2DChartAxisPanel;
import org.xdat.gui.panels.TitledSubPanel;

public class ScatterChart2DSettingsDialog
extends JDialog {
    static final long serialVersionUID = 2L;
    static final boolean printLog = false;
    private ColorChoiceButton fgColorButton;
    private ColorChoiceButton bgColorButton;
    private ColorChoiceButton standardDesignColorButton;
    private ColorChoiceButton selectedDesignColorButton;
    private ChartFrame chartFrame;

    public ScatterChart2DSettingsDialog(Main mainWindow, ChartFrame chartFrame, ScatterChart2D scatterChart2D) {
        super((Frame)chartFrame, String.valueOf(scatterChart2D.getTitle()) + " Settings");
        try {
            this.chartFrame = chartFrame;
            chartFrame.registerComponentForRepaint(this);
            this.setDefaultCloseOperation(2);
            this.setModal(false);
            this.buildPanel(mainWindow, chartFrame, scatterChart2D);
            Dimension parentSize = chartFrame.getSize();
            int xPos = Math.max(chartFrame.getX() + (int)(0.5 * ((double)parentSize.width - this.getSize().getWidth())), 0);
            int yPos = Math.max(chartFrame.getY() + (int)(0.5 * ((double)parentSize.height - this.getSize().getHeight())), 0);
            this.setLocation(xPos, yPos);
            this.setVisible(true);
        }
        catch (HeadlessException e) {
            this.log(e.getMessage());
        }
    }

    public void buildPanel(Main mainWindow, ChartFrame chartFrame, ScatterChart2D scatterChart2D) {
        Scatter2DChartDisplaySettingsActionListener cmd = new Scatter2DChartDisplaySettingsActionListener(chartFrame, scatterChart2D, this);
        this.getContentPane().removeAll();
        this.getContentPane().setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel(new BorderLayout());
        TitledSubPanel displayModeSelectionPanel = new TitledSubPanel("Display Mode");
        displayModeSelectionPanel.setLayout(new GridLayout(3, 1));
        ButtonGroup displayModeButtonGroup = new ButtonGroup();
        int displayMode = scatterChart2D.getScatterPlot2D().getDisplayedDesignSelectionMode();
        JRadioButton displayAllDesignsButton = new JRadioButton("Display all designs", displayMode == 0);
        JRadioButton displaySelectedDesignsButton = new JRadioButton("Display selected designs", displayMode == 1);
        JRadioButton displayActiveDesignsButton = new JRadioButton("Display designs visible in parallel chart: ", displayMode == 2);
        displayModeButtonGroup.add(displayAllDesignsButton);
        displayModeButtonGroup.add(displaySelectedDesignsButton);
        displayModeButtonGroup.add(displayActiveDesignsButton);
        JComboBox parallelChartSelectionComboBox = new JComboBox();
        ParallelChartFrameComboModel comboModel = new ParallelChartFrameComboModel(mainWindow, this.chartFrame, scatterChart2D.getScatterPlot2D());
        parallelChartSelectionComboBox.setModel(comboModel);
        mainWindow.registerComboModel(comboModel);
        JPanel visibleDesignsPanel = new JPanel(new GridLayout(1, 2));
        visibleDesignsPanel.add(displayActiveDesignsButton);
        visibleDesignsPanel.add(parallelChartSelectionComboBox);
        displayModeSelectionPanel.add(displayAllDesignsButton);
        displayModeSelectionPanel.add(displaySelectedDesignsButton);
        displayModeSelectionPanel.add(visibleDesignsPanel);
        mainPanel.add((Component)displayModeSelectionPanel, "North");
        displayAllDesignsButton.addActionListener(cmd);
        displaySelectedDesignsButton.addActionListener(cmd);
        displayActiveDesignsButton.addActionListener(cmd);
        JPanel axisSettingsPanel = new JPanel(new GridLayout(1, 2));
        Scatter2DChartAxisPanel xAxisPanel = new Scatter2DChartAxisPanel(mainWindow, chartFrame, scatterChart2D, 1);
        Scatter2DChartAxisPanel yAxisPanel = new Scatter2DChartAxisPanel(mainWindow, chartFrame, scatterChart2D, 2);
        axisSettingsPanel.add(yAxisPanel);
        axisSettingsPanel.add(xAxisPanel);
        mainPanel.add((Component)axisSettingsPanel, "Center");
        TitledSubPanel designDisplaySettingsPanelOuter = new TitledSubPanel("Design display settings");
        designDisplaySettingsPanelOuter.setLayout(new BorderLayout());
        JPanel designDisplaySettingsPanel = new JPanel(new BorderLayout());
        designDisplaySettingsPanelOuter.add((Component)designDisplaySettingsPanel, "West");
        designDisplaySettingsPanel.setLayout(new BorderLayout());
        JPanel designDisplaySettingsLabelPanel = new JPanel(new GridLayout(0, 1));
        JPanel designDisplaySettingsControlsPanel = new JPanel(new GridLayout(0, 1));
        designDisplaySettingsPanel.add((Component)designDisplaySettingsLabelPanel, "Center");
        designDisplaySettingsPanel.add((Component)designDisplaySettingsControlsPanel, "East");
        mainPanel.add((Component)designDisplaySettingsPanelOuter, "South");
        JLabel fgColorLabel = new JLabel("Foreground Color   ");
        JLabel bgColorLabel = new JLabel("Background Color   ");
        JLabel standardDesignColorLabel = new JLabel("Designs standard Color   ");
        JLabel selectedDesignColorLabel = new JLabel("Selected designs Color   ");
        JLabel dataPointSizeLabel = new JLabel("Data Point Size   ");
        this.fgColorButton = new ColorChoiceButton(scatterChart2D.getScatterPlot2D().getDecorationsColor(), "Foreground Color");
        this.bgColorButton = new ColorChoiceButton(scatterChart2D.getScatterPlot2D().getBackGroundColor(), "Background Color");
        this.standardDesignColorButton = new ColorChoiceButton(scatterChart2D.getScatterPlot2D().getActiveDesignColor(), "Active Design Color");
        this.selectedDesignColorButton = new ColorChoiceButton(scatterChart2D.getScatterPlot2D().getSelectedDesignColor(), "Selected Design Color");
        JSpinner dataPointSizeSpinner = new JSpinner(new MinMaxSpinnerModel(1, 20));
        dataPointSizeSpinner.setName("dataPointSizeSpinner");
        dataPointSizeSpinner.addChangeListener(cmd);
        dataPointSizeSpinner.setValue(scatterChart2D.getScatterPlot2D().getDotRadius());
        designDisplaySettingsLabelPanel.add(fgColorLabel);
        designDisplaySettingsLabelPanel.add(bgColorLabel);
        designDisplaySettingsLabelPanel.add(standardDesignColorLabel);
        designDisplaySettingsLabelPanel.add(selectedDesignColorLabel);
        designDisplaySettingsControlsPanel.add(this.fgColorButton);
        designDisplaySettingsControlsPanel.add(this.bgColorButton);
        designDisplaySettingsControlsPanel.add(this.standardDesignColorButton);
        designDisplaySettingsControlsPanel.add(this.selectedDesignColorButton);
        this.fgColorButton.addActionListener(cmd);
        this.bgColorButton.addActionListener(cmd);
        this.standardDesignColorButton.addActionListener(cmd);
        this.selectedDesignColorButton.addActionListener(cmd);
        JPanel dataPointPanel = new JPanel(new GridLayout(1, 2));
        dataPointPanel.add(dataPointSizeLabel);
        dataPointPanel.add(dataPointSizeSpinner);
        designDisplaySettingsPanel.add((Component)dataPointPanel, "South");
        JPanel panelForMainPanelAndLowerButtonsPanel = new JPanel(new BorderLayout());
        panelForMainPanelAndLowerButtonsPanel.add((Component)mainPanel, "Center");
        TitledSubPanel lowerButtonsPanel = new TitledSubPanel("Save / restore Settings");
        lowerButtonsPanel.setLayout(new GridLayout(1, 2));
        JButton setAsDefaultButton = new JButton("Set current settings as default");
        setAsDefaultButton.addActionListener(cmd);
        JButton loadFromDefaultButton = new JButton("Load default settings");
        loadFromDefaultButton.addActionListener(cmd);
        lowerButtonsPanel.add(setAsDefaultButton);
        lowerButtonsPanel.add(loadFromDefaultButton);
        panelForMainPanelAndLowerButtonsPanel.add((Component)lowerButtonsPanel, "South");
        this.add((Component)panelForMainPanelAndLowerButtonsPanel, "Center");
        this.pack();
        this.repaint();
    }

    @Override
    public void dispose() {
        this.log("dispose");
        this.chartFrame.unRegisterComponentForRepaint(this);
        super.dispose();
    }

    public ColorChoiceButton getFgColorButton() {
        return this.fgColorButton;
    }

    public ColorChoiceButton getBgColorButton() {
        return this.bgColorButton;
    }

    public ColorChoiceButton getStandardDesignColorButton() {
        return this.standardDesignColorButton;
    }

    public ColorChoiceButton getSelectedDesignColorButton() {
        return this.selectedDesignColorButton;
    }

    private void log(String message) {
    }
}

