/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import org.xdat.Main;
import org.xdat.actionListeners.clusterDialog.ClusterDialogActionListener;
import org.xdat.data.DataSheet;
import org.xdat.gui.tables.ColorEditor;
import org.xdat.gui.tables.ColorRenderer;
import org.xdat.gui.tables.GenericTableColumnModel;

public class ClusterDialog
extends JDialog {
    static final long serialVersionUID = 1L;
    static final boolean printLog = false;
    private DataSheet dataSheet;
    private JTable clusterTable;

    public ClusterDialog(JFrame parent, Main mainWindow, DataSheet dataSheet) {
        super((Frame)parent, "Data Clustering");
        this.log("constructor called.");
        this.setModal(true);
        this.dataSheet = dataSheet;
        this.setDefaultCloseOperation(2);
        this.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel(new BorderLayout());
        JPanel controlsPanel = new JPanel(new BorderLayout());
        JPanel controlButtonsPanel = new JPanel(new FlowLayout(0));
        controlButtonsPanel.setPreferredSize(new Dimension(300, 50));
        JPanel tablePanel = new JPanel(new BorderLayout());
        JPanel buttonsPanel = new JPanel(new GridLayout(1, 2));
        JButton addButton = new JButton("Add");
        JButton removeButton = new JButton("Remove");
        JButton cancelButton = new JButton("Cancel");
        JButton okButton = new JButton("Ok");
        GenericTableColumnModel cm = new GenericTableColumnModel();
        TableColumn nameCol = new TableColumn(0, 100);
        nameCol.setHeaderValue("Cluster");
        nameCol.setResizable(true);
        cm.addColumn(nameCol);
        ColorRenderer colorRenderer = new ColorRenderer(false);
        TableColumn colorCol = new TableColumn(1, 50, colorRenderer, new ColorEditor(this));
        colorCol.setHeaderValue("Color");
        colorCol.setResizable(true);
        cm.addColumn(colorCol);
        TableColumn lineThicknessCol = new TableColumn(2, 30);
        lineThicknessCol.setHeaderValue("Line Thickness");
        lineThicknessCol.setResizable(true);
        cm.addColumn(lineThicknessCol);
        TableColumn activeCol = new TableColumn(3, 30);
        activeCol.setHeaderValue("Active");
        activeCol.setResizable(true);
        cm.addColumn(activeCol);
        this.dataSheet.getClusterSet().createBuffer();
        this.clusterTable = new JTable(dataSheet.getClusterSet(), cm);
        JScrollPane scrollPane = new JScrollPane(this.clusterTable);
        ClusterDialogActionListener cmd = new ClusterDialogActionListener(mainWindow, this);
        addButton.addActionListener(cmd);
        removeButton.addActionListener(cmd);
        cancelButton.addActionListener(cmd);
        okButton.addActionListener(cmd);
        this.add((Component)mainPanel, "Center");
        mainPanel.add((Component)controlsPanel, "North");
        mainPanel.add((Component)tablePanel, "Center");
        mainPanel.add((Component)buttonsPanel, "South");
        controlsPanel.add((Component)controlButtonsPanel, "West");
        controlButtonsPanel.add(addButton);
        controlButtonsPanel.add(removeButton);
        tablePanel.add((Component)scrollPane, "Center");
        buttonsPanel.add(cancelButton);
        buttonsPanel.add(okButton);
        Dimension parentSize = parent.getSize();
        this.setSize(new Dimension(250, 400));
        int xPos = Math.max(parent.getX() + (int)(0.5 * (double)(parentSize.width - 250)), 0);
        int yPos = Math.max(parent.getY() + (int)(0.5 * (double)(parentSize.height - 400)), 0);
        this.setLocation(xPos, yPos);
        this.setVisible(true);
    }

    private void log(String message) {
    }

    public JTable getClusterTable() {
        return this.clusterTable;
    }

    public DataSheet getDataSheet() {
        return this.dataSheet;
    }
}

