/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.gui.buttons;

import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class MinMaxSpinnerModel
extends SpinnerNumberModel {
    static final long serialVersionUID = 0L;
    private int min;
    private int max;
    private JSpinner upperBoundSpinner;
    private JSpinner lowerBoundSpinner;

    public MinMaxSpinnerModel(int min, int max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public void setValue(Object value) {
        int integerValue = (Integer)value;
        int upperBound = this.max;
        int lowerBound = this.min;
        if (this.upperBoundSpinner != null) {
            upperBound = Math.min((Integer)this.upperBoundSpinner.getValue(), this.max);
        }
        if (this.lowerBoundSpinner != null) {
            lowerBound = Math.max((Integer)this.lowerBoundSpinner.getValue(), this.min);
        }
        if (integerValue > upperBound) {
            super.setValue(upperBound);
        } else if (integerValue < lowerBound) {
            super.setValue(lowerBound);
        } else {
            super.setValue(integerValue);
        }
    }

    public void setLowerBoundSpinner(JSpinner lowerBoundSpinner) {
        this.lowerBoundSpinner = lowerBoundSpinner;
    }

    public void setUpperBoundSpinner(JSpinner upperBoundSpinner) {
        this.upperBoundSpinner = upperBoundSpinner;
    }
}

