/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.gui.buttons;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.JButton;

public class ColorChoiceButton
extends JButton {
    static final long serialVersionUID = 1L;
    private Color currentColor;
    private int width = 16;
    private int height = 16;

    public ColorChoiceButton(Color currentColor, String actionCommand) {
        this(currentColor, actionCommand, 16, 16);
    }

    public ColorChoiceButton(Color currentColor, String actionCommand, int width, int height) {
        this.currentColor = currentColor;
        this.width = width;
        this.height = height;
        this.setActionCommand(actionCommand);
        this.setLayout(new GridLayout(1, 1));
        this.setPreferredSize(new Dimension(this.width, this.height));
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.currentColor);
        g.fillRect(0, 0, this.width, this.height);
    }

    public void actionPerformed(ActionEvent e) {
    }

    public void setCurrentColor(Color currentColor) {
        this.currentColor = currentColor;
    }

    public void setAlpha(int alpha) {
        this.currentColor = new Color(this.currentColor.getRed(), this.currentColor.getGreen(), this.currentColor.getBlue(), alpha);
        this.repaint();
    }
}

