/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.chart;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.ProgressMonitor;
import org.xdat.UserPreferences;
import org.xdat.chart.Axis;
import org.xdat.chart.Chart;
import org.xdat.data.DataSheet;
import org.xdat.data.Design;

public class ParallelCoordinatesChart
extends Chart
implements Serializable {
    static final long serialVersionUID = 4L;
    static final int BOTTOM_PADDING = 60;
    static final boolean printLog = false;
    private Color backGroundColor;
    private int topMargin = 10;
    private boolean verticallyOffsetAxisLabels = true;
    private int axisLabelVerticalDistance = 10;
    private Vector<Axis> axes = new Vector(0, 1);
    private int designLabelFontSize;
    private int lineThickness = 1;
    private int selectedDesignsLineThickness = 1;
    private Color activeDesignColor;
    private Color activeDesignColorNoAlpha;
    private Color selectedDesignColor;
    private Color filteredDesignColor;
    private Color filteredDesignColorNoAlpha;
    private Color filterColor;
    private boolean showDesignIDs;
    private boolean showFilteredDesigns;
    private boolean showOnlySelectedDesigns;
    private int filterHeight;
    private int filterWidth;

    public ParallelCoordinatesChart(DataSheet dataSheet, ProgressMonitor progressMonitor, int id) {
        super(dataSheet, id);
        this.setLocation(new Point(100, 100));
        this.setFrameSize(new Dimension(1280, 800));
        this.log("constructor called. Read Base settings.");
        UserPreferences userPreferences = UserPreferences.getInstance();
        this.backGroundColor = userPreferences.getParallelCoordinatesDefaultBackgroundColor();
        this.showDesignIDs = userPreferences.isParallelCoordinatesShowDesignIDs();
        this.showFilteredDesigns = userPreferences.isParallelCoordinatesShowFilteredDesigns();
        this.verticallyOffsetAxisLabels = userPreferences.isParallelCoordinatesVerticallyOffsetAxisLabels();
        this.setActiveDesignColor(userPreferences.getParallelCoordinatesActiveDesignDefaultColor());
        this.selectedDesignColor = userPreferences.getParallelCoordinatesSelectedDesignDefaultColor();
        this.setFilteredDesignColor(userPreferences.getParallelCoordinatesFilteredDesignDefaultColor());
        this.designLabelFontSize = userPreferences.getParallelCoordinatesDesignLabelFontSize();
        this.lineThickness = userPreferences.getParallelCoordinatesLineThickness();
        this.selectedDesignsLineThickness = userPreferences.getParallelCoordinatesSelectedDesignLineThickness();
        this.filterColor = userPreferences.getParallelCoordinatesFilterDefaultColor();
        this.showOnlySelectedDesigns = userPreferences.isParallelCoordinatesShowOnlySelectedDesigns();
        this.filterHeight = userPreferences.getParallelCoordinatesFilterHeight();
        this.filterWidth = userPreferences.getParallelCoordinatesFilterWidth();
        this.log("constructor: Base settings read. Creating axes...");
        progressMonitor.setMaximum(dataSheet.getParameterCount() - 1);
        progressMonitor.setNote("Building Chart...");
        int i = 0;
        while (i < dataSheet.getParameterCount() && !progressMonitor.isCanceled()) {
            Axis newAxis = new Axis(dataSheet, this, dataSheet.getParameter(i));
            this.addAxis(newAxis);
            progressMonitor.setProgress(i);
            ++i;
        }
        if (!progressMonitor.isCanceled()) {
            progressMonitor.setNote("Building Filters...");
            progressMonitor.setProgress(0);
            i = 0;
            while (i < dataSheet.getParameterCount() && !progressMonitor.isCanceled()) {
                this.axes.get(i).addFilters();
                progressMonitor.setProgress(i);
                ++i;
            }
        }
    }

    @Override
    public String getTitle() {
        return "Parallel Coordinates Chart " + this.getID();
    }

    @Override
    public int getWidth() {
        int width = 0;
        if (this.getAxis(0).isActive()) {
            width += (int)(0.5 * (double)this.getAxis(0).getWidth());
        }
        int i = 1;
        while (i < this.getAxisCount()) {
            if (this.getAxis(i).isActive()) {
                width += this.getAxis(i).getWidth();
            }
            ++i;
        }
        return width;
    }

    @Override
    public int getHeight() {
        int height = this.getAxisTopPos() + this.getAxisHeight();
        return height;
    }

    public int getAxisMaxWidth() {
        int width = 0;
        int i = 0;
        while (i < this.getAxisCount()) {
            if (this.getAxis(i).isActive() && width < this.getAxis(i).getWidth()) {
                width = this.getAxis(i).getWidth();
            }
            ++i;
        }
        return width;
    }

    public void setAxisWidth(int width) {
        int i = 0;
        while (i < this.axes.size()) {
            this.axes.get(i).setWidth(width);
            ++i;
        }
    }

    public void incrementAxisWidth(int deltaWidth) {
        int i = 0;
        while (i < this.axes.size()) {
            this.axes.get(i).setWidth(Math.max(0, this.axes.get(i).getWidth() + deltaWidth));
            ++i;
        }
    }

    public void setAxisColor(Color color) {
        int i = 0;
        while (i < this.axes.size()) {
            this.axes.get(i).setAxisColor(color);
            ++i;
        }
    }

    public int getAxisTopPos() {
        int topPos = this.verticallyOffsetAxisLabels ? 2 * this.getMaxAxisLabelFontSize() + this.axisLabelVerticalDistance + this.getTopMargin() * 2 + this.getFilterHeight() : this.getMaxAxisLabelFontSize() + this.getTopMargin() * 2 + this.getFilterHeight();
        return topPos;
    }

    public Axis getAxis(int index) {
        return this.axes.get(index);
    }

    public Axis getAxis(String parameterName) {
        int i = 0;
        while (i < this.axes.size()) {
            if (parameterName.equals(this.axes.get(i).getParameter().getName())) {
                return this.axes.get(i);
            }
            ++i;
        }
        throw new IllegalArgumentException("Axis " + parameterName + " not found");
    }

    public int getMaxAxisLabelFontSize() {
        int maxAxisLabelFontSize = 0;
        int i = 0;
        while (i < this.axes.size()) {
            if (maxAxisLabelFontSize < this.axes.get(i).getAxisLabelFontSize()) {
                maxAxisLabelFontSize = this.axes.get(i).getAxisLabelFontSize();
            }
            ++i;
        }
        return maxAxisLabelFontSize;
    }

    public int getActiveAxisCount() {
        int axesCount = 0;
        int i = 0;
        while (i < this.axes.size()) {
            if (this.axes.get(i).isActive()) {
                ++axesCount;
            }
            ++i;
        }
        return axesCount;
    }

    public int getAxisCount() {
        return this.axes.size();
    }

    public int getAxisLabelVerticalDistance() {
        return this.axisLabelVerticalDistance;
    }

    public void setAxisLabelVerticalDistance(int axisLabelVerticalDistance) {
        this.axisLabelVerticalDistance = axisLabelVerticalDistance;
    }

    public boolean isVerticallyOffsetAxisLabels() {
        return this.verticallyOffsetAxisLabels;
    }

    public void setVerticallyOffsetAxisLabels(boolean verticallyOffsetAxisLabels) {
        this.verticallyOffsetAxisLabels = verticallyOffsetAxisLabels;
    }

    public void addAxis(Axis axis) {
        this.axes.add(axis);
    }

    public void addAxis(int index, Axis axis) {
        this.axes.add(index, axis);
    }

    public void removeAxis(int index) {
        this.axes.remove(index);
    }

    public void removeAxis(String parameterName) {
        int i = 0;
        while (i < this.axes.size()) {
            if (parameterName.equals(this.axes.get(i).getParameter().getName())) {
                this.axes.remove(i);
                return;
            }
            ++i;
        }
        throw new IllegalArgumentException("Axis " + parameterName + " not found");
    }

    public void moveAxis(int oldIndex, int newIndex) {
        this.log("moveAxis called with arguments " + oldIndex + " and " + newIndex);
        Axis axis = this.axes.remove(oldIndex);
        this.axes.insertElementAt(axis, newIndex);
    }

    public int getAxisHeight() {
        return this.getFrameSize().height - this.getAxisTopPos() - 60;
    }

    private void log(String message) {
    }

    public int getDesignLabelFontSize() {
        return this.designLabelFontSize;
    }

    public void setDesignLabelFontSize(int designLabelFontSize) {
        this.designLabelFontSize = designLabelFontSize;
    }

    public int getLineThickness() {
        return this.lineThickness;
    }

    public void setLineThickness(int lineThickness) {
        this.lineThickness = lineThickness;
    }

    public Color getDesignColor(Design design, boolean designActive, boolean useAlpha) {
        if (designActive && design.hasGradientColor()) {
            return design.getGradientColor();
        }
        if (designActive && design.getCluster() != null) {
            return design.getCluster().getActiveDesignColor(useAlpha);
        }
        if (designActive) {
            return useAlpha ? this.activeDesignColor : this.activeDesignColorNoAlpha;
        }
        return useAlpha ? this.filteredDesignColor : this.filteredDesignColorNoAlpha;
    }

    public int getDesignLineThickness(Design design) {
        if (design.getCluster() != null) {
            return design.getCluster().getLineThickness();
        }
        return this.lineThickness;
    }

    public int getSelectedDesignsLineThickness() {
        return this.selectedDesignsLineThickness;
    }

    public void setSelectedDesignsLineThickness(int selectedDesignsLineThickness) {
        this.selectedDesignsLineThickness = selectedDesignsLineThickness;
    }

    public Color getDefaultDesignColor(boolean designActive, boolean useAlpha) {
        if (designActive) {
            return useAlpha ? this.activeDesignColor : this.activeDesignColorNoAlpha;
        }
        return useAlpha ? this.filteredDesignColor : this.filteredDesignColorNoAlpha;
    }

    public void setActiveDesignColor(Color activeDesignColor) {
        this.activeDesignColor = activeDesignColor;
        this.activeDesignColorNoAlpha = new Color(activeDesignColor.getRed(), activeDesignColor.getGreen(), activeDesignColor.getBlue());
    }

    public void setFilteredDesignColor(Color filteredDesignColor) {
        this.filteredDesignColor = filteredDesignColor;
        this.filteredDesignColorNoAlpha = new Color(filteredDesignColor.getRed(), filteredDesignColor.getGreen(), filteredDesignColor.getBlue());
    }

    public Color getSelectedDesignColor() {
        return this.selectedDesignColor;
    }

    public void setSelectedDesignColor(Color selectedDesignColor) {
        this.selectedDesignColor = selectedDesignColor;
    }

    public boolean isShowDesignIDs() {
        return this.showDesignIDs;
    }

    public void setShowDesignIDs(boolean showDesignIDs) {
        this.showDesignIDs = showDesignIDs;
    }

    public boolean isShowFilteredDesigns() {
        return this.showFilteredDesigns;
    }

    public void setShowFilteredDesigns(boolean showFilteredDesigns) {
        this.showFilteredDesigns = showFilteredDesigns;
    }

    public boolean isShowOnlySelectedDesigns() {
        return this.showOnlySelectedDesigns;
    }

    public void setShowOnlySelectedDesigns(boolean showOnlySelectedDesigns) {
        this.showOnlySelectedDesigns = showOnlySelectedDesigns;
    }

    public Color getFilterColor() {
        return this.filterColor;
    }

    public void setFilterColor(Color filterColor) {
        this.filterColor = filterColor;
    }

    public int getTopMargin() {
        return this.topMargin;
    }

    @Override
    public void resetDisplaySettingsToDefault() {
        UserPreferences userPreferences = UserPreferences.getInstance();
        this.backGroundColor = userPreferences.getParallelCoordinatesDefaultBackgroundColor();
        this.showDesignIDs = userPreferences.isParallelCoordinatesShowDesignIDs();
        this.showFilteredDesigns = userPreferences.isParallelCoordinatesShowFilteredDesigns();
        this.showOnlySelectedDesigns = userPreferences.isParallelCoordinatesShowOnlySelectedDesigns();
        this.setActiveDesignColor(userPreferences.getParallelCoordinatesActiveDesignDefaultColor());
        this.selectedDesignColor = userPreferences.getParallelCoordinatesSelectedDesignDefaultColor();
        this.setFilteredDesignColor(userPreferences.getParallelCoordinatesFilteredDesignDefaultColor());
        this.designLabelFontSize = userPreferences.getParallelCoordinatesDesignLabelFontSize();
        this.lineThickness = userPreferences.getParallelCoordinatesLineThickness();
        this.selectedDesignsLineThickness = userPreferences.getParallelCoordinatesSelectedDesignLineThickness();
        this.verticallyOffsetAxisLabels = userPreferences.isParallelCoordinatesVerticallyOffsetAxisLabels();
        this.filterColor = userPreferences.getParallelCoordinatesFilterDefaultColor();
        this.filterHeight = userPreferences.getParallelCoordinatesFilterHeight();
        this.filterWidth = userPreferences.getParallelCoordinatesFilterWidth();
        int i = 0;
        while (i < this.axes.size()) {
            this.axes.get(i).resetSettingsToDefault();
            ++i;
        }
    }

    @Override
    public Color getBackGroundColor() {
        return this.backGroundColor;
    }

    @Override
    public void setBackGroundColor(Color backGroundColor) {
        this.backGroundColor = backGroundColor;
    }

    public int getFilterHeight() {
        return this.filterHeight;
    }

    public void setFilterHeight(int filterHeight) {
        this.filterHeight = filterHeight;
    }

    public int getFilterWidth() {
        return this.filterWidth;
    }

    public void setFilterWidth(int filterWidth) {
        this.filterWidth = filterWidth;
    }

    public void applyAllFilters() {
        int i = 0;
        while (i < this.getDataSheet().getParameterCount()) {
            this.axes.get(i).applyFilters();
            ++i;
        }
    }

    public void autofitAllAxes() {
        int i = 0;
        while (i < this.axes.size()) {
            this.axes.get(i).autofit();
            ++i;
        }
    }
}

