/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.chart;

import java.io.Serializable;
import org.xdat.chart.Axis;
import org.xdat.data.DataSheet;
import org.xdat.data.Parameter;

public class Filter
implements Serializable {
    static final long serialVersionUID = 2L;
    static final boolean printLog = false;
    public static final int UPPER_FILTER = 0;
    public static final int LOWER_FILTER = 1;
    public static final double FILTER_TOLERANCE = 1.0E-5;
    private DataSheet dataSheet;
    private int filterType;
    private Axis axis;
    private int xPos;
    private double value;

    public Filter(DataSheet dataSheet, Axis axis, int filterType) {
        this.log("constructor called");
        this.dataSheet = dataSheet;
        this.axis = axis;
        this.filterType = filterType;
        this.reset();
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
        this.apply();
    }

    public int getXPos() {
        return this.xPos;
    }

    public void setXPos(int pos) {
        this.xPos = pos;
    }

    public int getYPos() {
        int yPos;
        if (this.axis.getTicCount() == 1) {
            return this.getAxis().getChart().getAxisTopPos() + (int)((double)this.getAxis().getChart().getAxisHeight() * 0.5);
        }
        double upperLimit = this.axis.getMax();
        double lowerLimit = this.axis.getMin();
        if (this.value > upperLimit) {
            this.value = upperLimit;
        } else if (this.value < lowerLimit) {
            this.value = lowerLimit;
        }
        double valueRange = upperLimit - lowerLimit;
        int topPos = this.axis.getChart().getAxisTopPos() - 1;
        int bottomPos = topPos + this.getAxis().getChart().getAxisHeight() + 1;
        double posRange = bottomPos - topPos;
        if (this.axis.isAxisInverted()) {
            double ratio = (this.value - lowerLimit) / valueRange;
            yPos = topPos + (int)(posRange * ratio);
        } else {
            double ratio = (this.value - lowerLimit) / valueRange;
            yPos = bottomPos - (int)(posRange * ratio);
        }
        return yPos;
    }

    public void setYPos(int pos) {
        double upperLimit = this.axis.getMax();
        double lowerLimit = this.axis.getMin();
        double valueRange = upperLimit - lowerLimit;
        int topPos = this.axis.getChart().getAxisTopPos() - 1;
        int bottomPos = topPos + this.getAxis().getChart().getAxisHeight() + 1;
        double posRange = bottomPos - topPos;
        double ratio = this.axis.isAxisInverted() ? (double)(pos - topPos) / posRange : (double)(bottomPos - pos) / posRange;
        this.value = lowerLimit + valueRange * ratio;
        this.apply();
    }

    public int getHighestPos() {
        int pos = this.getFilterType() == 0 ? this.getAxis().getChart().getAxisTopPos() : (this.getFilterType() == 1 ? this.getAxis().getUpperFilter().getYPos() : this.getAxis().getChart().getAxisTopPos());
        return pos - 1;
    }

    public int getLowestPos() {
        int pos = this.getFilterType() == 0 ? this.getAxis().getLowerFilter().getYPos() : (this.getFilterType() == 1 ? this.getAxis().getChart().getAxisTopPos() + this.getAxis().getChart().getAxisHeight() : this.getAxis().getChart().getAxisTopPos() + this.getAxis().getChart().getAxisHeight());
        return pos + 1;
    }

    public int getFilterType() {
        return this.filterType;
    }

    public Axis getAxis() {
        return this.axis;
    }

    public void apply() {
        block26: {
            double value;
            double tolerance;
            Parameter param;
            block32: {
                block31: {
                    block30: {
                        block29: {
                            block28: {
                                block27: {
                                    block25: {
                                        param = this.axis.getParameter();
                                        tolerance = this.getAxis().getRange() * 1.0E-5;
                                        if (tolerance <= 0.0) {
                                            tolerance = 1.0E-5;
                                        }
                                        value = this.getValue();
                                        if (this.filterType != 0 || !this.axis.isFilterInverted() || !this.axis.isAxisInverted()) break block25;
                                        int i = 0;
                                        while (i < this.dataSheet.getDesignCount()) {
                                            if (this.dataSheet.getDesign(i).getDoubleValue(param) - tolerance > value) {
                                                this.dataSheet.getDesign(i).setActive(this, false);
                                            } else {
                                                this.dataSheet.getDesign(i).setActive(this, true);
                                            }
                                            ++i;
                                        }
                                        break block26;
                                    }
                                    if (this.filterType != 1 || !this.axis.isFilterInverted() || !this.axis.isAxisInverted()) break block27;
                                    int i = 0;
                                    while (i < this.dataSheet.getDesignCount()) {
                                        if (this.dataSheet.getDesign(i).getDoubleValue(param) + tolerance < value) {
                                            this.dataSheet.getDesign(i).setActive(this, false);
                                        } else {
                                            this.dataSheet.getDesign(i).setActive(this, true);
                                        }
                                        ++i;
                                    }
                                    break block26;
                                }
                                if (this.filterType != 0 || !this.axis.isAxisInverted()) break block28;
                                int i = 0;
                                while (i < this.dataSheet.getDesignCount()) {
                                    if (this.dataSheet.getDesign(i).getDoubleValue(param) + tolerance < value) {
                                        this.dataSheet.getDesign(i).setActive(this, false);
                                    } else {
                                        this.dataSheet.getDesign(i).setActive(this, true);
                                    }
                                    ++i;
                                }
                                break block26;
                            }
                            if (this.filterType != 1 || !this.axis.isAxisInverted()) break block29;
                            int i = 0;
                            while (i < this.dataSheet.getDesignCount()) {
                                if (this.dataSheet.getDesign(i).getDoubleValue(param) - tolerance > value) {
                                    this.dataSheet.getDesign(i).setActive(this, false);
                                } else {
                                    this.dataSheet.getDesign(i).setActive(this, true);
                                }
                                ++i;
                            }
                            break block26;
                        }
                        if (this.filterType != 0 || !this.axis.isFilterInverted()) break block30;
                        int i = 0;
                        while (i < this.dataSheet.getDesignCount()) {
                            if (this.dataSheet.getDesign(i).getDoubleValue(param) + tolerance < value) {
                                this.dataSheet.getDesign(i).setActive(this, false);
                            } else {
                                this.dataSheet.getDesign(i).setActive(this, true);
                            }
                            ++i;
                        }
                        break block26;
                    }
                    if (this.filterType != 1 || !this.axis.isFilterInverted()) break block31;
                    int i = 0;
                    while (i < this.dataSheet.getDesignCount()) {
                        if (this.dataSheet.getDesign(i).getDoubleValue(param) - tolerance > value) {
                            this.dataSheet.getDesign(i).setActive(this, false);
                        } else {
                            this.dataSheet.getDesign(i).setActive(this, true);
                        }
                        ++i;
                    }
                    break block26;
                }
                if (this.filterType != 0) break block32;
                int i = 0;
                while (i < this.dataSheet.getDesignCount()) {
                    if (this.dataSheet.getDesign(i).getDoubleValue(param) - tolerance > value) {
                        this.dataSheet.getDesign(i).setActive(this, false);
                    } else {
                        this.dataSheet.getDesign(i).setActive(this, true);
                    }
                    ++i;
                }
                break block26;
            }
            if (this.filterType != 1) break block26;
            int i = 0;
            while (i < this.dataSheet.getDesignCount()) {
                if (this.dataSheet.getDesign(i).getDoubleValue(param) + tolerance < value) {
                    this.dataSheet.getDesign(i).setActive(this, false);
                } else {
                    this.dataSheet.getDesign(i).setActive(this, true);
                }
                ++i;
            }
        }
    }

    public void reset() {
        if (this.filterType == 0 && this.axis.isAxisInverted()) {
            this.setValue(this.axis.getMax());
        } else if (this.filterType == 0) {
            double value = this.axis.getMax();
            this.log("reset: maxValue = " + value);
            this.setValue(value);
        } else if (this.filterType == 1 && this.axis.isAxisInverted()) {
            this.setValue(this.axis.getMax());
        } else {
            this.setValue(this.axis.getMin());
        }
    }

    private void log(String message) {
    }
}

