/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.actionListeners.scatter2DChartSettings;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.xdat.Main;
import org.xdat.chart.ScatterChart2D;
import org.xdat.chart.ScatterPlot2D;
import org.xdat.gui.frames.ChartFrame;
import org.xdat.gui.panels.Scatter2DChartAxisPanel;

public class Scatter2DChartAxisPanelActionListener
implements ActionListener,
ChangeListener {
    static final boolean printLog = false;
    private Main mainWindow;
    private ScatterChart2D chart;
    private ChartFrame frame;
    private int axis;
    private Scatter2DChartAxisPanel panel;

    public Scatter2DChartAxisPanelActionListener(Main mainWindow, ChartFrame chartFrame, ScatterChart2D chart, Scatter2DChartAxisPanel panel, int axis) {
        this.mainWindow = mainWindow;
        this.frame = chartFrame;
        this.chart = chart;
        this.panel = panel;
        this.axis = axis;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand == "autofitAxis" && this.axis == 1) {
            boolean newState = this.panel.getAutoFitAxisCheckbox().isSelected();
            this.chart.getScatterPlot2D().setAutofitX(newState);
            if (newState) {
                this.panel.setTextFieldsEnabled(false);
                this.chart.getScatterPlot2D().autofitX(this.mainWindow.getDataSheet());
            } else {
                this.panel.setTextFieldsEnabled(true);
            }
        } else if (actionCommand == "autofitAxis" && this.axis == 2) {
            boolean newState = this.panel.getAutoFitAxisCheckbox().isSelected();
            this.chart.getScatterPlot2D().setAutofitY(newState);
            if (newState) {
                this.panel.setTextFieldsEnabled(false);
                this.chart.getScatterPlot2D().autofitY(this.mainWindow.getDataSheet());
            } else {
                this.panel.setTextFieldsEnabled(true);
            }
        } else if (((JTextField)e.getSource()).getName().equals("minTextField")) {
            if (this.axis == 1) {
                double newMinValue = this.validateDoubleInput(e.getActionCommand(), this.chart.getScatterPlot2D().getMinX());
                this.chart.getScatterPlot2D().setMinX(newMinValue);
                ((JTextField)e.getSource()).setText(Double.toString(newMinValue));
            } else {
                double newMinValue = this.validateDoubleInput(e.getActionCommand(), this.chart.getScatterPlot2D().getMinY());
                this.chart.getScatterPlot2D().setMinY(newMinValue);
                ((JTextField)e.getSource()).setText(Double.toString(newMinValue));
            }
        } else if (((JTextField)e.getSource()).getName().equals("maxTextField")) {
            if (this.axis == 1) {
                double newMaxValue = this.validateDoubleInput(e.getActionCommand(), this.chart.getScatterPlot2D().getMaxX());
                this.chart.getScatterPlot2D().setMaxX(newMaxValue);
                ((JTextField)e.getSource()).setText(Double.toString(newMaxValue));
            } else {
                double newMaxValue = this.validateDoubleInput(e.getActionCommand(), this.chart.getScatterPlot2D().getMaxY());
                this.chart.getScatterPlot2D().setMaxY(newMaxValue);
                ((JTextField)e.getSource()).setText(Double.toString(newMaxValue));
            }
        } else {
            System.out.println("Scatter2DChartDisplaySettingsActionListener: command: " + e.getActionCommand());
            System.out.println("Scatter2DChartDisplaySettingsActionListener: source: " + ((JTextField)e.getSource()).getName());
        }
        this.frame.repaint();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int value = Integer.parseInt(((JSpinner)e.getSource()).getValue().toString());
        String source = ((JSpinner)e.getSource()).getName();
        ScatterPlot2D plot = this.chart.getScatterPlot2D();
        if (source.equals("ticCountSpinner")) {
            if (this.axis == 1) {
                plot.setTicCountX(value);
            } else {
                plot.setTicCountY(value);
            }
        } else if (source.equals("ticLabelFontSizeSpinner")) {
            if (this.axis == 1) {
                plot.setTicLabelFontSizeX(value);
            } else {
                plot.setTicLabelFontSizeY(value);
            }
        } else if (source.equals("axisLabelFontSizeSpinner")) {
            if (this.axis == 1) {
                plot.setAxisLabelFontSizeX(value);
            } else {
                plot.setAxisLabelFontSizeY(value);
            }
        } else {
            System.out.println("Scatter2DChartDisplaySettingsChangeListener: value: " + value);
            System.out.println("Scatter2DChartDisplaySettingsChangeListener: source: " + source);
        }
        this.frame.repaint();
    }

    private double validateDoubleInput(String input, double fallBackValue) {
        try {
            return Double.parseDouble(input);
        }
        catch (NumberFormatException e) {
            return fallBackValue;
        }
    }

    private void log(String message) {
    }
}

