/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.actionListeners.scatter2DChartSettings;

import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.MutableComboBoxModel;
import org.xdat.Main;
import org.xdat.chart.ParallelCoordinatesChart;
import org.xdat.chart.ScatterPlot2D;
import org.xdat.gui.frames.ChartFrame;

public class ParallelChartFrameComboModel
extends AbstractListModel
implements MutableComboBoxModel {
    static final long serialVersionUID = 0L;
    static final boolean printLog = false;
    private Main mainWindow;
    private ChartFrame chartFrame;
    private ScatterPlot2D plot;
    private Vector<String> chartNames = new Vector();

    public ParallelChartFrameComboModel(Main mainWindow, ChartFrame chartFrame, ScatterPlot2D plot) {
        this.mainWindow = mainWindow;
        this.chartFrame = chartFrame;
        this.plot = plot;
        int i = 0;
        while (i < mainWindow.getChartFrameCount()) {
            if (mainWindow.getChartFrame(i).getChart().getClass().equals(ParallelCoordinatesChart.class)) {
                this.addElement(mainWindow.getChartFrame(i).getChart().getTitle());
            }
            ++i;
        }
    }

    @Override
    public void setSelectedItem(Object anItem) {
        if (anItem.toString().equals("No chart selected             ")) {
            this.plot.setParallelCoordinatesChartForFiltering(null);
        } else {
            this.plot.setParallelCoordinatesChartForFiltering((ParallelCoordinatesChart)this.mainWindow.getChartFrame(anItem.toString()).getChart());
        }
        this.log("setSelectedItem");
        this.chartFrame.repaint();
    }

    @Override
    public Object getSelectedItem() {
        this.log("getSelectedItem");
        if (this.plot.getParallelCoordinatesChartForFiltering() == null) {
            return "No chart selected             ";
        }
        return this.plot.getParallelCoordinatesChartForFiltering().getTitle();
    }

    @Override
    public Object getElementAt(int index) {
        this.log("getElementAt");
        if (this.chartNames.size() == 0 && index == 0) {
            return "No chart selected             ";
        }
        return this.chartNames.get(index);
    }

    @Override
    public int getSize() {
        this.log("getSize " + Math.max(this.chartNames.size(), 1));
        return Math.max(this.chartNames.size(), 1);
    }

    public void addElement(Object obj) {
        this.chartNames.add(obj.toString());
        this.fireIntervalAdded(this, 0, this.chartNames.size());
        this.log("addElement");
    }

    public void insertElementAt(Object obj, int index) {
        this.chartNames.insertElementAt(obj.toString(), index);
        this.fireIntervalAdded(this, 0, this.chartNames.size());
        this.log("insertElementAt");
    }

    @Override
    public void removeElement(Object obj) {
        this.chartNames.remove(obj);
        this.fireIntervalRemoved(this, 0, this.chartNames.size());
        this.log("removeElement");
    }

    @Override
    public void removeElementAt(int index) {
        this.chartNames.remove(index);
        this.fireIntervalRemoved(this, 0, this.chartNames.size());
        this.log("removeElementAt");
    }

    private void log(String message) {
    }
}

