/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.actionListeners.parallelCoordinatesChartFrame;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import org.xdat.Main;
import org.xdat.chart.ParallelCoordinatesChart;
import org.xdat.gui.dialogs.ParameterSetSelectionDialog;
import org.xdat.gui.frames.ChartFrame;

public class ChartFrameSelectParametersMenuActionListener
implements ActionListener {
    static final boolean printLog = false;
    private Main mainWindow;
    private ChartFrame chartFrame;
    private ParallelCoordinatesChart chart;

    public ChartFrameSelectParametersMenuActionListener(Main mainWindow, ChartFrame chartFrame, ParallelCoordinatesChart chart) {
        this.mainWindow = mainWindow;
        this.chartFrame = chartFrame;
        this.chart = chart;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        this.log("Action Command = " + actionCommand);
        if (actionCommand.equals("Select All")) {
            Component[] menuComps = this.chartFrame.getJMenuBar().getMenu(0).getMenuComponents();
            int i = 0;
            while (i < menuComps.length) {
                if (menuComps[i].getClass().equals(JCheckBoxMenuItem.class)) {
                    this.chart.getAxis(((JCheckBoxMenuItem)menuComps[i]).getText()).setActive(true);
                }
                ++i;
            }
        } else if (actionCommand.equals("Unselect All")) {
            Component[] menuComps = this.chartFrame.getJMenuBar().getMenu(0).getMenuComponents();
            int i = 0;
            while (i < menuComps.length) {
                if (menuComps[i].getClass().equals(JCheckBoxMenuItem.class)) {
                    this.chart.getAxis(((JCheckBoxMenuItem)menuComps[i]).getText()).setActive(false);
                }
                ++i;
            }
        } else if (actionCommand.equals("Reverse Selection")) {
            Component[] menuComps = this.chartFrame.getJMenuBar().getMenu(0).getMenuComponents();
            int i = 0;
            while (i < menuComps.length) {
                if (menuComps[i].getClass().equals(JCheckBoxMenuItem.class)) {
                    this.chart.getAxis(((JCheckBoxMenuItem)menuComps[i]).getText()).setActive(!this.chart.getAxis(((JCheckBoxMenuItem)menuComps[i]).getText()).isActive());
                }
                ++i;
            }
        } else if (actionCommand.equals("Custom Selection")) {
            this.log("creating ParameterSetSelectionDialog");
            new ParameterSetSelectionDialog(this.mainWindow, this.chartFrame);
        } else {
            this.log("Axis " + actionCommand + " active is " + this.chart.getAxis(actionCommand).isActive());
            this.chart.getAxis(actionCommand).setActive(!this.chart.getAxis(actionCommand).isActive());
            this.log("After state change axis " + actionCommand + " active is " + this.chart.getAxis(actionCommand).isActive());
        }
        this.chartFrame.getChartPanel().setSize(this.chartFrame.getChartPanel().getPreferredSize());
        this.chartFrame.validate();
        this.chartFrame.repaint();
    }

    private void log(String message) {
    }
}

