/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.actionListeners.mainMenu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.xdat.Main;
import org.xdat.Session;
import org.xdat.UserPreferences;

public class MainFileMenuActionListener
implements ActionListener {
    private Main mainWindow;
    static final boolean printLog = false;

    public MainFileMenuActionListener(Main mainWindow) {
        this.mainWindow = mainWindow;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.log("constructor called");
        if (e.getActionCommand().equals("Load Session")) {
            int returnVal;
            JFileChooser chooser = new JFileChooser();
            FileNameExtensionFilter filter = new FileNameExtensionFilter("*.ses files", "ses");
            chooser.setFileFilter(filter);
            chooser.addChoosableFileFilter(filter);
            if (UserPreferences.getInstance().getCurrentDir() != null) {
                chooser.setCurrentDirectory(new File(UserPreferences.getInstance().getCurrentDir()));
            }
            if ((returnVal = chooser.showOpenDialog(this.mainWindow)) == 0) {
                String filepath = chooser.getSelectedFile().getAbsolutePath();
                UserPreferences.getInstance().setLastFile(chooser.getSelectedFile().getAbsolutePath());
                this.mainWindow.loadSession(filepath);
                this.mainWindow.initialiseDataPanel();
            }
        } else if (e.getActionCommand().equals("Save Session As...")) {
            this.saveSessionAs();
        } else if (e.getActionCommand().equals("Save Session")) {
            this.log("save session called");
            Session session = this.mainWindow.getCurrentSession();
            if (session.getSessionDirectory() == null || session.getSessionName() == null) {
                this.saveSessionAs();
            } else {
                String filepath = String.valueOf(session.getSessionDirectory()) + System.getProperty("file.separator") + session.getSessionName() + ".ses";
                this.mainWindow.saveSessionAs(filepath);
            }
        } else if (e.getActionCommand().equals("Exit")) {
            this.mainWindow.setVisible(false);
            this.mainWindow.dispose();
            System.exit(0);
        } else {
            System.out.println(e.getActionCommand());
        }
    }

    private void saveSessionAs() {
        int returnVal;
        Session session = this.mainWindow.getCurrentSession();
        JFileChooser chooser = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("*.ses files", "ses");
        chooser.setFileFilter(filter);
        chooser.addChoosableFileFilter(filter);
        if (UserPreferences.getInstance().getCurrentDir() != null) {
            chooser.setCurrentDirectory(new File(UserPreferences.getInstance().getCurrentDir()));
        }
        if ((returnVal = chooser.showSaveDialog(this.mainWindow)) == 0) {
            String filepath = chooser.getSelectedFile().getAbsolutePath();
            String filename = chooser.getSelectedFile().getName();
            session.setSessionDirectory(chooser.getSelectedFile().getParent());
            if (filename.endsWith(".ses")) {
                session.setSessionName(filename.substring(0, filename.length() - 4));
                this.mainWindow.saveSessionAs(filepath);
            } else {
                session.setSessionName(filename);
                this.mainWindow.saveSessionAs(String.valueOf(filepath) + ".ses");
            }
            UserPreferences.getInstance().setLastFile(filepath);
            this.mainWindow.setTitle("xdat   -   " + filepath + ".ses");
        }
    }

    private void log(String message) {
    }
}

