/*
 * Decompiled with CFR 0.152.
 */
package org.xdat.actionListeners.mainMenu;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import org.xdat.Main;
import org.xdat.chart.ScatterChart2D;
import org.xdat.exceptions.NoParametersDefinedException;
import org.xdat.gui.frames.ChartFrame;
import org.xdat.workerThreads.ParallelCoordinatesChartCreationThread;

public class MainChartMenuActionListener
implements ActionListener {
    private Main mainWindow;
    static final boolean printLog = false;

    public MainChartMenuActionListener(Main mainWindow) {
        this.log("constructor called");
        this.mainWindow = mainWindow;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Create Parallel Coordinates Chart")) {
            if (this.mainWindow.getDataSheet() == null) {
                JOptionPane.showMessageDialog(this.mainWindow, "Please create a data sheet first by selecting Data->Import.", "Create Chart", 1);
            } else {
                ProgressMonitor progressMonitor = new ProgressMonitor(this.mainWindow, "", "Building Chart...", 0, 100);
                progressMonitor.setProgress(0);
                ParallelCoordinatesChartCreationThread sw = new ParallelCoordinatesChartCreationThread(this.mainWindow, progressMonitor);
                sw.execute();
            }
        } else if (e.getActionCommand().equals("Create Scatter Chart 2D")) {
            if (this.mainWindow.getDataSheet() == null) {
                JOptionPane.showMessageDialog(this.mainWindow, "Please create a data sheet first by selecting Data->Import.", "Create Chart", 1);
            } else {
                ScatterChart2D chart = new ScatterChart2D(this.mainWindow.getDataSheet(), true, new Dimension(600, 600), this.mainWindow.getUniqueChartId(ScatterChart2D.class));
                try {
                    new ChartFrame(this.mainWindow, chart);
                    this.mainWindow.getCurrentSession().addChart(chart);
                }
                catch (NoParametersDefinedException e1) {
                    JOptionPane.showMessageDialog(this.mainWindow, "Cannot create chart when no parameters are defined.", "No parameters defined!", 0);
                }
            }
        } else {
            System.out.println(e.getActionCommand());
        }
    }

    private void log(String message) {
    }
}

