/*
 * Decompiled with CFR 0.152.
 */
package workerThreads;

import chart.ParallelCoordinatesChart;
import exceptions.NoParametersDefinedException;
import gui.frames.ChartFrame;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;
import xdat.Main;

public class ParallelCoordinatesChartCreationThread
extends SwingWorker {
    static final boolean printLog = false;
    private Main mainWindow;
    private ProgressMonitor progressMonitor;

    public ParallelCoordinatesChartCreationThread(Main mainWindow, ProgressMonitor progressMonitor) {
        this.mainWindow = mainWindow;
        this.progressMonitor = progressMonitor;
    }

    public Object doInBackground() {
        ParallelCoordinatesChart chart = new ParallelCoordinatesChart(this.mainWindow.getDataSheet(), this.progressMonitor, this.mainWindow.getUniqueChartId(ParallelCoordinatesChart.class));
        if (this.progressMonitor.isCanceled()) {
            return null;
        }
        try {
            new ChartFrame(this.mainWindow, chart);
            this.mainWindow.getCurrentSession().addChart(chart);
        }
        catch (NoParametersDefinedException e) {
            JOptionPane.showMessageDialog(this.mainWindow, "Cannot create chart when no parameters are defined.", "No parameters defined!", 0);
        }
        return null;
    }

    @Override
    protected void done() {
        super.done();
        this.log("done: progressMonitor isCanceled = " + this.progressMonitor.isCanceled());
    }

    private void log(String message) {
    }
}

