/*
 * Decompiled with CFR 0.152.
 */
package workerThreads;

import chart.ParallelCoordinatesChart;
import data.DataSheet;
import exceptions.InconsistentDataException;
import gui.frames.ChartFrame;
import java.io.IOException;
import java.util.Hashtable;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;
import xdat.Main;

public class DataSheetUpdateThread
extends SwingWorker {
    static final boolean printLog = false;
    private String pathToInputFile;
    private boolean dataHasHeaders;
    private Main mainWindow;
    private ProgressMonitor progressMonitor;

    public DataSheetUpdateThread(String pathToInputFile, boolean dataHasHeaders, Main mainWindow, ProgressMonitor progressMonitor) {
        this.log("constructor called");
        this.pathToInputFile = pathToInputFile;
        this.dataHasHeaders = dataHasHeaders;
        this.mainWindow = mainWindow;
        this.progressMonitor = progressMonitor;
    }

    public Object doInBackground() {
        try {
            Hashtable<ChartFrame, double[]> upperFilterValues = new Hashtable<ChartFrame, double[]>();
            Hashtable<ChartFrame, double[]> lowerFilterValues = new Hashtable<ChartFrame, double[]>();
            int i = 0;
            while (i < this.mainWindow.getChartFrameCount()) {
                ChartFrame f = this.mainWindow.getChartFrame(i);
                if (f.getChart().getClass().equals(ParallelCoordinatesChart.class)) {
                    ParallelCoordinatesChart c = (ParallelCoordinatesChart)f.getChart();
                    double[] ufValues = new double[c.getAxisCount()];
                    double[] lfValues = new double[c.getAxisCount()];
                    int a = 0;
                    while (a < c.getAxisCount()) {
                        ufValues[a] = c.getAxis(a).getUpperFilter().getValue();
                        this.log("doInBackground: " + c.getAxis(a).getName() + ": filterGetValue = " + ufValues[a]);
                        lfValues[a] = c.getAxis(a).getLowerFilter().getValue();
                        ++a;
                    }
                    upperFilterValues.put(f, ufValues);
                    lowerFilterValues.put(f, lfValues);
                }
                ++i;
            }
            DataSheet dataSheet = this.mainWindow.getDataSheet();
            dataSheet.updateData(this.pathToInputFile, this.dataHasHeaders, this.progressMonitor);
            int i2 = 0;
            while (i2 < this.mainWindow.getChartFrameCount()) {
                ChartFrame f = this.mainWindow.getChartFrame(i2);
                if (f.getChart().getClass().equals(ParallelCoordinatesChart.class)) {
                    ParallelCoordinatesChart c = (ParallelCoordinatesChart)f.getChart();
                    double[] ufValues = (double[])upperFilterValues.get(f);
                    double[] lfValues = (double[])lowerFilterValues.get(f);
                    int a = 0;
                    while (a < c.getAxisCount()) {
                        this.log("doInBackground: " + c.getAxis(a).getName() + ": filterSetValue = " + ufValues[a]);
                        c.getAxis(a).getUpperFilter().setValue(ufValues[a]);
                        c.getAxis(a).getLowerFilter().setValue(lfValues[a]);
                        ++a;
                    }
                }
                f.repaint();
                ++i2;
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.mainWindow, "Error on updating data from file:\n " + e.getMessage(), "Update Data", 0);
        }
        catch (InconsistentDataException e1) {
            JOptionPane.showMessageDialog(this.mainWindow, String.valueOf(e1.getMessage()) + "\nThe previous state will be restored.", "Update Data", 0);
        }
        this.progressMonitor.close();
        return null;
    }

    private void log(String message) {
    }
}

