/*
 * Decompiled with CFR 0.152.
 */
package gui.panels;

import actionListeners.scatter2DChartSettings.Scatter2DChartAxisPanelActionListener;
import actionListeners.scatter2DChartSettings.Scatter2DChartAxisSelectionListener;
import chart.ScatterChart2D;
import gui.buttons.MinMaxSpinnerModel;
import gui.frames.ChartFrame;
import gui.panels.TitledSubPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import xdat.Main;

public class Scatter2DChartAxisPanel
extends JPanel {
    static final long serialVersionUID = 0L;
    public static final int X_AXIS = 1;
    public static final int Y_AXIS = 2;
    private int axis;
    private ScatterChart2D chart;
    static final boolean printLog = false;
    private JTextField axisMinTextField = new JTextField();
    private JTextField axisMaxTextField = new JTextField();
    private JCheckBox autoFitAxisCheckbox = new JCheckBox();
    private JSpinner ticCountSpinner = new JSpinner(new MinMaxSpinnerModel(1, 500));

    public Scatter2DChartAxisPanel(Main mainWindow, ChartFrame chartFrame, ScatterChart2D chart, int axis) {
        String title;
        Scatter2DChartAxisPanelActionListener cmd = new Scatter2DChartAxisPanelActionListener(mainWindow, chartFrame, chart, this, axis);
        String selectedParam = "";
        this.chart = chart;
        this.axis = axis;
        if (axis == 1) {
            title = "X-Axis";
            selectedParam = chart.getScatterPlot2D().getParameterForXAxis().getName();
        } else if (axis == 2) {
            title = "Y-Axis";
            selectedParam = chart.getScatterPlot2D().getParameterForYAxis().getName();
        } else {
            throw new RuntimeException("Invalid axis type " + axis);
        }
        TitledSubPanel mainPanel = new TitledSubPanel(title);
        this.setLayout(new GridLayout(1, 1));
        this.add(mainPanel);
        mainPanel.setLayout(new BorderLayout());
        JList parameterSelectionList = new JList(mainWindow.getDataSheet());
        parameterSelectionList.setVisibleRowCount(6);
        parameterSelectionList.setAutoscrolls(true);
        parameterSelectionList.setSelectionMode(0);
        int i = 0;
        while (i < parameterSelectionList.getModel().getSize()) {
            if (parameterSelectionList.getModel().getElementAt(i).equals(selectedParam)) {
                parameterSelectionList.setSelectedIndex(i);
                break;
            }
            ++i;
        }
        parameterSelectionList.addListSelectionListener(new Scatter2DChartAxisSelectionListener(chartFrame, chart, this, axis));
        JScrollPane scrollPane = new JScrollPane(parameterSelectionList, 20, 30);
        mainPanel.add((Component)scrollPane, "North");
        JPanel otherControlsPanel = new JPanel(new BorderLayout());
        JPanel labelPanel = new JPanel(new GridLayout(0, 1));
        JPanel controlsPanel = new JPanel(new GridLayout(0, 1));
        otherControlsPanel.add((Component)labelPanel, "West");
        otherControlsPanel.add((Component)controlsPanel, "Center");
        mainPanel.add((Component)otherControlsPanel, "Center");
        JLabel autoFitAxisLabel = new JLabel("Autofit axis  ");
        JLabel axisMinLabel = new JLabel("Axis minimum   ");
        JLabel axisMaxLabel = new JLabel("Axis maximum   ");
        JLabel axisLabelFontSizeLabel = new JLabel("Axis Title Fontsize  ");
        JLabel nrOfTicsLabel = new JLabel("Number of Tics  ");
        JLabel ticLabelFontSizeLabel = new JLabel("Tic Label Font Size  ");
        labelPanel.add(autoFitAxisLabel);
        labelPanel.add(axisMinLabel);
        labelPanel.add(axisMaxLabel);
        labelPanel.add(axisLabelFontSizeLabel);
        labelPanel.add(nrOfTicsLabel);
        labelPanel.add(ticLabelFontSizeLabel);
        JSpinner axisLabelFontSizeSpinner = new JSpinner(new MinMaxSpinnerModel(0, 100));
        axisLabelFontSizeSpinner.setName("axisLabelFontSizeSpinner");
        axisLabelFontSizeSpinner.addChangeListener(cmd);
        this.ticCountSpinner.setName("ticCountSpinner");
        this.ticCountSpinner.addChangeListener(cmd);
        JSpinner ticLabelFontSizeSpinner = new JSpinner(new MinMaxSpinnerModel(0, 100));
        ticLabelFontSizeSpinner.setName("ticLabelFontSizeSpinner");
        ticLabelFontSizeSpinner.addChangeListener(cmd);
        if (axis == 1) {
            axisLabelFontSizeSpinner.setValue(chart.getScatterPlot2D().getAxisLabelFontSizeX());
            this.ticCountSpinner.setValue(chart.getScatterPlot2D().getTicCountX());
            ticLabelFontSizeSpinner.setValue(chart.getScatterPlot2D().getTicLabelFontSizeX());
        } else {
            axisLabelFontSizeSpinner.setValue(chart.getScatterPlot2D().getAxisLabelFontSizeY());
            this.ticCountSpinner.setValue(chart.getScatterPlot2D().getTicCountY());
            ticLabelFontSizeSpinner.setValue(chart.getScatterPlot2D().getTicLabelFontSizeY());
        }
        controlsPanel.add(this.autoFitAxisCheckbox);
        controlsPanel.add(this.axisMinTextField);
        controlsPanel.add(this.axisMaxTextField);
        controlsPanel.add(axisLabelFontSizeSpinner);
        controlsPanel.add(this.ticCountSpinner);
        controlsPanel.add(ticLabelFontSizeSpinner);
        this.autoFitAxisCheckbox.addActionListener(cmd);
        this.autoFitAxisCheckbox.setActionCommand("autofitAxis");
        this.axisMinTextField.addActionListener(cmd);
        this.axisMinTextField.setName("minTextField");
        this.axisMaxTextField.addActionListener(cmd);
        this.axisMaxTextField.setName("maxTextField");
        if (axis == 1) {
            if (chart.getScatterPlot2D().isAutofitX()) {
                this.autoFitAxisCheckbox.setSelected(true);
                this.setTextFieldsEnabled(false);
            } else {
                this.autoFitAxisCheckbox.setSelected(false);
                this.setTextFieldsEnabled(true);
            }
        } else if (chart.getScatterPlot2D().isAutofitY()) {
            this.autoFitAxisCheckbox.setSelected(true);
            this.setTextFieldsEnabled(false);
        } else {
            this.autoFitAxisCheckbox.setSelected(false);
            this.setTextFieldsEnabled(true);
        }
    }

    public void setTextFieldsEnabled(boolean enabled) {
        this.axisMaxTextField.setEnabled(enabled);
        this.axisMinTextField.setEnabled(enabled);
        if (this.axis == 1) {
            this.axisMaxTextField.setText(Double.toString(this.chart.getScatterPlot2D().getMaxX()));
            this.axisMinTextField.setText(Double.toString(this.chart.getScatterPlot2D().getMinX()));
        } else {
            this.axisMaxTextField.setText(Double.toString(this.chart.getScatterPlot2D().getMaxY()));
            this.axisMinTextField.setText(Double.toString(this.chart.getScatterPlot2D().getMinY()));
        }
    }

    public void updateTicCountSpinnerEnabled() {
        if (this.axis == 1) {
            if (this.chart.getScatterPlot2D().getParameterForXAxis().isNumeric()) {
                this.ticCountSpinner.setEnabled(true);
            } else {
                this.ticCountSpinner.setEnabled(false);
            }
        } else if (this.axis == 2) {
            if (this.chart.getScatterPlot2D().getParameterForYAxis().isNumeric()) {
                this.ticCountSpinner.setEnabled(true);
            } else {
                this.ticCountSpinner.setEnabled(false);
            }
        }
    }

    public JTextField getAxisMinTextField() {
        return this.axisMinTextField;
    }

    public JTextField getAxisMaxTextField() {
        return this.axisMaxTextField;
    }

    public JCheckBox getAutoFitAxisCheckbox() {
        return this.autoFitAxisCheckbox;
    }

    private void log(String message) {
    }
}

