/*
 * Decompiled with CFR 0.152.
 */
package gui.panels;

import actionListeners.parallelCoordinatesDisplaySettings.ChartSpecificDisplaySettingsDialogActionListener;
import actionListeners.parallelCoordinatesDisplaySettings.DefaultDisplaySettingsDialogActionListener;
import actionListeners.parallelCoordinatesDisplaySettings.ParallelChartDisplaySettingsActionListener;
import chart.ParallelCoordinatesChart;
import gui.buttons.ColorChoiceButton;
import gui.buttons.MinMaxSpinnerModel;
import gui.dialogs.ParallelCoordinatesDisplaySettingsDialog;
import gui.frames.ChartFrame;
import gui.panels.TitledSubPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import xdat.Main;

public class ParallelCoordinatesChartDisplaySettingsPanel
extends JPanel {
    static final long serialVersionUID = 0L;
    static final boolean printLog = false;
    private Main mainWindow;
    private ParallelCoordinatesDisplaySettingsDialog dialog;
    private ChartFrame chartFrame;
    private ParallelChartDisplaySettingsActionListener cmd;
    private JCheckBox axisLabelVerticalOffsetCheckbox = new JCheckBox();
    private ColorChoiceButton backGroundColorButton;
    private ColorChoiceButton activeDesignColorButton;
    private ColorChoiceButton selectedDesignColorButton;
    private ColorChoiceButton filteredDesignColorButton;
    private ColorChoiceButton filterColorButton;
    private JCheckBox showOnlySelectedDesignsCheckBox = new JCheckBox();
    private JRadioButton showfilteredDesignsTrueButton = new JRadioButton("Yes");
    private JRadioButton showfilteredDesignsFalseButton = new JRadioButton("No");
    private JRadioButton showDesignIDsTrueButton = new JRadioButton("Yes");
    private JRadioButton showDesignIDsFalseButton = new JRadioButton("No");
    private ButtonGroup showfilteredDesignsButtonGroup = new ButtonGroup();
    private ButtonGroup showDesignIDsButtonGroup = new ButtonGroup();
    private JSpinner designLineThicknessSpinner = new JSpinner(new MinMaxSpinnerModel(0, 10));
    private JSpinner selectedDesignLineThicknessSpinner = new JSpinner(new MinMaxSpinnerModel(0, 10));
    private JSpinner designLabelFontSizeSpinner = new JSpinner(new MinMaxSpinnerModel(0, 100));
    private JSpinner filterWidthSpinner = new JSpinner(new MinMaxSpinnerModel(1, 30));
    private JSpinner filterHeightSpinner = new JSpinner(new MinMaxSpinnerModel(1, 60));
    private JButton cancelButton = new JButton("Cancel");
    private JButton okButton = new JButton("Ok");

    public ParallelCoordinatesChartDisplaySettingsPanel(Main mainWindow, ParallelCoordinatesDisplaySettingsDialog dialog) {
        this.mainWindow = mainWindow;
        this.dialog = dialog;
        this.buildPanel();
        this.axisLabelVerticalOffsetCheckbox.setSelected(Main.getUserPreferences().isParallelCoordinatesVerticallyOffsetAxisLabels());
        this.setShowFilteredDesignsSelection(Main.getUserPreferences().isParallelCoordinatesShowFilteredDesigns());
        this.setShowDesignIDsSelection(Main.getUserPreferences().isParallelCoordinatesShowDesignIDs());
        this.designLabelFontSizeSpinner.setValue(Main.getUserPreferences().getParallelCoordinatesDesignLabelFontSize());
        this.designLineThicknessSpinner.setValue(Main.getUserPreferences().getParallelCoordinatesLineThickness());
        this.selectedDesignLineThicknessSpinner.setValue(Main.getUserPreferences().getParallelCoordinatesSelectedDesignLineThickness());
        this.backGroundColorButton.setCurrentColor(Main.getUserPreferences().getParallelCoordinatesDefaultBackgroundColor());
        this.activeDesignColorButton.setCurrentColor(Main.getUserPreferences().getParallelCoordinatesActiveDesignDefaultColor());
        this.selectedDesignColorButton.setCurrentColor(Main.getUserPreferences().getParallelCoordinatesSelectedDesignDefaultColor());
        this.filteredDesignColorButton.setCurrentColor(Main.getUserPreferences().getParallelCoordinatesFilteredDesignDefaultColor());
        this.filterColorButton.setCurrentColor(Main.getUserPreferences().getParallelCoordinatesFilterDefaultColor());
        this.showOnlySelectedDesignsCheckBox.setSelected(Main.getUserPreferences().isParallelCoordinatesShowOnlySelectedDesigns());
        this.filterWidthSpinner.setValue(Main.getUserPreferences().getParallelCoordinatesFilterWidth());
        this.filterHeightSpinner.setValue(Main.getUserPreferences().getParallelCoordinatesFilterHeight());
    }

    public ParallelCoordinatesChartDisplaySettingsPanel(Main mainWindow, ParallelCoordinatesDisplaySettingsDialog dialog, ChartFrame chartFrame) {
        this.mainWindow = mainWindow;
        this.dialog = dialog;
        this.chartFrame = chartFrame;
        ParallelCoordinatesChart c = (ParallelCoordinatesChart)chartFrame.getChart();
        this.buildPanel();
        this.axisLabelVerticalOffsetCheckbox.setSelected(c.isVerticallyOffsetAxisLabels());
        this.setShowFilteredDesignsSelection(c.isShowFilteredDesigns());
        this.setShowDesignIDsSelection(c.isShowDesignIDs());
        this.designLabelFontSizeSpinner.setValue(c.getDesignLabelFontSize());
        this.designLineThicknessSpinner.setValue(c.getLineThickness());
        this.selectedDesignLineThicknessSpinner.setValue(c.getSelectedDesignsLineThickness());
        this.backGroundColorButton.setCurrentColor(c.getBackGroundColor());
        this.activeDesignColorButton.setCurrentColor(c.getDefaultDesignColor(true));
        this.selectedDesignColorButton.setCurrentColor(c.getSelectedDesignColor());
        this.filteredDesignColorButton.setCurrentColor(c.getDefaultDesignColor(false));
        this.filterColorButton.setCurrentColor(c.getFilterColor());
        this.showOnlySelectedDesignsCheckBox.setSelected(c.isShowOnlySelectedDesigns());
        this.filterWidthSpinner.setValue(c.getFilterWidth());
        this.filterHeightSpinner.setValue(c.getFilterHeight());
    }

    private void buildPanel() {
        this.backGroundColorButton = new ColorChoiceButton(Main.getUserPreferences().getParallelCoordinatesDefaultBackgroundColor(), "Background Color");
        this.activeDesignColorButton = new ColorChoiceButton(Main.getUserPreferences().getParallelCoordinatesActiveDesignDefaultColor(), "Active Design Color");
        this.selectedDesignColorButton = new ColorChoiceButton(Main.getUserPreferences().getParallelCoordinatesSelectedDesignDefaultColor(), "Selected Design Color");
        this.filteredDesignColorButton = new ColorChoiceButton(Main.getUserPreferences().getParallelCoordinatesFilteredDesignDefaultColor(), "Filtered Design Color");
        this.filterColorButton = new ColorChoiceButton(Main.getUserPreferences().getParallelCoordinatesFilterDefaultColor(), "Filter Color");
        TitledSubPanel contentPanel = new TitledSubPanel("");
        JPanel contentInnerPanel = new JPanel(new BorderLayout());
        JPanel labelPanel = new JPanel(new GridLayout(0, 1));
        JPanel controlsPanel = new JPanel(new GridLayout(0, 1));
        TitledSubPanel buttonsPanel = new TitledSubPanel("");
        JPanel showfilteredDesignsRadioButtonsPanel = new JPanel(new GridLayout(1, 2));
        JPanel showDesignIDsRadioButtonsPanel = new JPanel(new GridLayout(1, 2));
        JLabel axisLabelVerticalOffsetLabel = new JLabel("Offset Axis Labels");
        JLabel backGroundColorLabel = new JLabel("Background Color");
        JLabel activeDesignColorLabel = new JLabel("Active Design Color");
        JLabel selectedDesignColorLabel = new JLabel("Selected Design Color");
        JLabel filteredDesignColorLabel = new JLabel("Filtered Design Color");
        JLabel filterColorLabel = new JLabel("Filter Color");
        JLabel showOnlySelectedDesignsLabel = new JLabel("Show only selected Designs");
        JLabel showfilteredDesignsLabel = new JLabel("Show filtered Designs");
        JLabel showDesignIDsLabel = new JLabel("Show Design IDs");
        this.showfilteredDesignsButtonGroup.add(this.showfilteredDesignsTrueButton);
        this.showfilteredDesignsButtonGroup.add(this.showfilteredDesignsFalseButton);
        this.showDesignIDsButtonGroup.add(this.showDesignIDsTrueButton);
        this.showDesignIDsButtonGroup.add(this.showDesignIDsFalseButton);
        JLabel designLabelFontSizeLabel = new JLabel("Design Label Font Size ");
        JLabel designLineThicknessLabel = new JLabel("Design Line Thickness ");
        JLabel selectedDesignLineThicknessLabel = new JLabel("Selected Design Line Thickness ");
        JLabel filterWidthLabel = new JLabel("Filter Symbol Width");
        JLabel filterHeightLabel = new JLabel("Filter Symbol Height");
        JPanel cancelButtonPanel = new JPanel();
        JPanel okButtonPanel = new JPanel();
        this.setLayout(new BorderLayout());
        contentPanel.setLayout(new BorderLayout());
        cancelButtonPanel.setLayout(new FlowLayout(2));
        okButtonPanel.setLayout(new FlowLayout(0));
        buttonsPanel.setLayout(new GridLayout(1, 2));
        this.add((Component)contentPanel, "Center");
        contentPanel.add((Component)contentInnerPanel, "North");
        contentInnerPanel.add((Component)labelPanel, "Center");
        contentInnerPanel.add((Component)controlsPanel, "East");
        this.add((Component)buttonsPanel, "South");
        labelPanel.add(axisLabelVerticalOffsetLabel);
        JPanel axisLabelVerticalOffsetCheckboxPanel = new JPanel(new FlowLayout(0));
        axisLabelVerticalOffsetCheckboxPanel.add(this.axisLabelVerticalOffsetCheckbox);
        controlsPanel.add(axisLabelVerticalOffsetCheckboxPanel);
        labelPanel.add(backGroundColorLabel);
        JPanel backGroundColorButtonPanel = new JPanel(new FlowLayout(0));
        backGroundColorButtonPanel.add(this.backGroundColorButton);
        controlsPanel.add(backGroundColorButtonPanel);
        labelPanel.add(activeDesignColorLabel);
        JPanel activeDesignColorButtonPanel = new JPanel(new FlowLayout(0));
        controlsPanel.add(activeDesignColorButtonPanel);
        activeDesignColorButtonPanel.add(this.activeDesignColorButton);
        labelPanel.add(selectedDesignColorLabel);
        JPanel selectedDesignColorButtonPanel = new JPanel(new FlowLayout(0));
        controlsPanel.add(selectedDesignColorButtonPanel);
        selectedDesignColorButtonPanel.add(this.selectedDesignColorButton);
        labelPanel.add(filteredDesignColorLabel);
        JPanel filteredDesignColorButtonPanel = new JPanel(new FlowLayout(0));
        filteredDesignColorButtonPanel.add(this.filteredDesignColorButton);
        controlsPanel.add(filteredDesignColorButtonPanel);
        labelPanel.add(filterColorLabel);
        JPanel filterColorButtonPanel = new JPanel(new FlowLayout(0));
        filterColorButtonPanel.add(this.filterColorButton);
        controlsPanel.add(filterColorButtonPanel);
        labelPanel.add(showfilteredDesignsLabel);
        controlsPanel.add(showfilteredDesignsRadioButtonsPanel);
        showfilteredDesignsRadioButtonsPanel.add(this.showfilteredDesignsTrueButton);
        showfilteredDesignsRadioButtonsPanel.add(this.showfilteredDesignsFalseButton);
        labelPanel.add(showDesignIDsLabel);
        controlsPanel.add(showDesignIDsRadioButtonsPanel);
        labelPanel.add(showOnlySelectedDesignsLabel);
        JPanel showOnlySelectedDesignsCheckboxPanel = new JPanel(new FlowLayout(0));
        showOnlySelectedDesignsCheckboxPanel.add(this.showOnlySelectedDesignsCheckBox);
        controlsPanel.add(showOnlySelectedDesignsCheckboxPanel);
        labelPanel.add(designLabelFontSizeLabel);
        controlsPanel.add(this.designLabelFontSizeSpinner);
        labelPanel.add(selectedDesignLineThicknessLabel);
        controlsPanel.add(this.selectedDesignLineThicknessSpinner);
        labelPanel.add(designLineThicknessLabel);
        controlsPanel.add(this.designLineThicknessSpinner);
        showDesignIDsRadioButtonsPanel.add(this.showDesignIDsTrueButton);
        showDesignIDsRadioButtonsPanel.add(this.showDesignIDsFalseButton);
        this.showfilteredDesignsTrueButton.setActionCommand("showfilteredDesignsTrue");
        this.showfilteredDesignsFalseButton.setActionCommand("showfilteredDesignsFalse");
        this.showDesignIDsTrueButton.setActionCommand("showDesignIDsTrue");
        this.showDesignIDsFalseButton.setActionCommand("showDesignIDsFalse");
        labelPanel.add(filterWidthLabel);
        controlsPanel.add(this.filterWidthSpinner);
        labelPanel.add(filterHeightLabel);
        controlsPanel.add(this.filterHeightSpinner);
        buttonsPanel.add(cancelButtonPanel);
        buttonsPanel.add(okButtonPanel);
        cancelButtonPanel.add(this.cancelButton);
        okButtonPanel.add(this.okButton);
    }

    public void setActionListener(ParallelChartDisplaySettingsActionListener cmd) {
        this.cmd = cmd;
        this.backGroundColorButton.addActionListener(cmd);
        this.activeDesignColorButton.addActionListener(cmd);
        this.selectedDesignColorButton.addActionListener(cmd);
        this.filteredDesignColorButton.addActionListener(cmd);
        this.filterColorButton.addActionListener(cmd);
        this.showfilteredDesignsTrueButton.addActionListener(cmd);
        this.showfilteredDesignsFalseButton.addActionListener(cmd);
        this.showDesignIDsTrueButton.addActionListener(cmd);
        this.showDesignIDsFalseButton.addActionListener(cmd);
    }

    public void setOkCancelButtonTargetDefaultSettings() {
        DefaultDisplaySettingsDialogActionListener cmd = new DefaultDisplaySettingsDialogActionListener(this.dialog);
        this.log("setOkCancelButtonTargetDefaultSettings called");
        this.cancelButton.addActionListener(cmd);
        this.okButton.addActionListener(cmd);
    }

    public void setOkCancelButtonTargetChart(ParallelCoordinatesChart chart) {
        this.log("setOkCancelButtonTargetChart called");
        this.cancelButton.addActionListener(new ChartSpecificDisplaySettingsDialogActionListener(this.mainWindow, this.dialog, chart, this.chartFrame));
        this.okButton.addActionListener(new ChartSpecificDisplaySettingsDialogActionListener(this.mainWindow, this.dialog, chart, this.chartFrame));
    }

    public ParallelChartDisplaySettingsActionListener getChartDisplaySettingsActionListener() {
        return this.cmd;
    }

    public boolean getShowFilteredDesignsSelection() {
        return this.showfilteredDesignsTrueButton.getModel().equals(this.showfilteredDesignsButtonGroup.getSelection());
    }

    public void setShowFilteredDesignsSelection(boolean showFilteredDesignsSelection) {
        if (showFilteredDesignsSelection) {
            this.showfilteredDesignsButtonGroup.setSelected(this.showfilteredDesignsTrueButton.getModel(), true);
        } else {
            this.showfilteredDesignsButtonGroup.setSelected(this.showfilteredDesignsFalseButton.getModel(), true);
        }
    }

    public boolean getShowDesignIDsSelection() {
        return this.showfilteredDesignsTrueButton.getModel().equals(this.showfilteredDesignsButtonGroup.getSelection());
    }

    public void setShowDesignIDsSelection(boolean showFilteredDesignsSelection) {
        this.log("setShowDesignIDsSelection: argument is " + showFilteredDesignsSelection);
        if (showFilteredDesignsSelection) {
            this.showDesignIDsButtonGroup.setSelected(this.showDesignIDsTrueButton.getModel(), true);
        } else {
            this.showDesignIDsButtonGroup.setSelected(this.showDesignIDsFalseButton.getModel(), true);
        }
    }

    public JSpinner getDesignLabelFontSizeSpinner() {
        return this.designLabelFontSizeSpinner;
    }

    public JSpinner getDesignLineThicknessSpinner() {
        return this.designLineThicknessSpinner;
    }

    public JSpinner getSelectedDesignLineThicknessSpinner() {
        return this.selectedDesignLineThicknessSpinner;
    }

    public JCheckBox getAxisLabelVerticalOffsetCheckbox() {
        return this.axisLabelVerticalOffsetCheckbox;
    }

    public JCheckBox getShowOnlySelectedDesignsCheckBox() {
        return this.showOnlySelectedDesignsCheckBox;
    }

    public ColorChoiceButton getActiveDesignColorButton() {
        return this.activeDesignColorButton;
    }

    public ColorChoiceButton getSelectedDesignColorButton() {
        return this.selectedDesignColorButton;
    }

    public ColorChoiceButton getBackGroundColorButton() {
        return this.backGroundColorButton;
    }

    public ColorChoiceButton getFilterColorButton() {
        return this.filterColorButton;
    }

    public ColorChoiceButton getFilteredDesignColorButton() {
        return this.filteredDesignColorButton;
    }

    public JSpinner getFilterHeightSpinner() {
        return this.filterHeightSpinner;
    }

    public JSpinner getFilterWidthSpinner() {
        return this.filterWidthSpinner;
    }

    private void log(String message) {
    }
}

