/*
 * Decompiled with CFR 0.152.
 */
package gui.dialogs;

import actionListeners.parallelCoordinatesChartFrame.ParameterSetSelectionDialogActionListener;
import chart.ParallelCoordinatesChart;
import gui.buttons.CustomButton;
import gui.frames.ChartFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import xdat.Main;

public class ParameterSetSelectionDialog
extends JDialog {
    static final long serialVersionUID = 2L;
    static final boolean printLog = false;
    private Vector<JCheckBox> checkBoxes = new Vector(0, 1);

    public ParameterSetSelectionDialog(Main mainWindow, ChartFrame chartFrame) {
        super((Frame)chartFrame, "Select active parameters");
        try {
            this.setModal(true);
            this.setLayout(new BorderLayout());
            JPanel mainPanel = new JPanel(new BorderLayout());
            JPanel controlsPanel = new JPanel(new BorderLayout());
            JPanel controlButtonsPanel = new JPanel(new FlowLayout(0));
            controlButtonsPanel.setPreferredSize(new Dimension(400, 50));
            JPanel checkBoxOuterPanel = new JPanel(new BorderLayout());
            JPanel checkBoxInnerPanel = new JPanel(new GridLayout(0, 1));
            JPanel buttonsPanel = new JPanel(new GridLayout(1, 2));
            CustomButton selectAllButton = new CustomButton("Select All", "images/selectAllButtonDefault.png", "images/selectAllButtonPressed.png", "Select All");
            CustomButton unselectAllButton = new CustomButton("Unselect All", "images/UnSelectAllButtonDefault.png", "images/UnSelectAllButtonPressed.png", "Unselect All");
            CustomButton invertSelectionButton = new CustomButton("Invert Selection", "images/reverseSelectionButtonDefault.png", "images/reverseSelectionButtonPressed.png", "Invert Selection");
            JButton cancelButton = new JButton("Cancel");
            JButton okButton = new JButton("Ok");
            this.log("Add Listeners");
            ParameterSetSelectionDialogActionListener cmd = new ParameterSetSelectionDialogActionListener(chartFrame, this);
            selectAllButton.addActionListener(cmd);
            unselectAllButton.addActionListener(cmd);
            invertSelectionButton.addActionListener(cmd);
            cancelButton.addActionListener(cmd);
            okButton.addActionListener(cmd);
            this.log("Add Components");
            this.add((Component)mainPanel, "Center");
            mainPanel.add((Component)controlsPanel, "North");
            mainPanel.add((Component)new JScrollPane(checkBoxOuterPanel), "Center");
            mainPanel.add((Component)buttonsPanel, "South");
            checkBoxOuterPanel.add((Component)checkBoxInnerPanel, "North");
            controlsPanel.add((Component)controlButtonsPanel, "West");
            controlButtonsPanel.add(selectAllButton);
            controlButtonsPanel.add(unselectAllButton);
            controlButtonsPanel.add(invertSelectionButton);
            buttonsPanel.add(cancelButton);
            buttonsPanel.add(okButton);
            ParallelCoordinatesChart c = (ParallelCoordinatesChart)chartFrame.getChart();
            int i = 0;
            while (i < mainWindow.getDataSheet().getParameterCount()) {
                this.log("constructor: adding checkbox " + mainWindow.getDataSheet().getParameter(i).getName());
                JCheckBox cb = new JCheckBox(mainWindow.getDataSheet().getParameter(i).getName(), c.getAxis(i).isActive());
                this.checkBoxes.add(cb);
                checkBoxInnerPanel.add(cb);
                ++i;
            }
            this.log("constructor: all checkboxes added ");
            Dimension screenSize = this.getToolkit().getScreenSize();
            this.setSize(new Dimension(350, 400));
            int yPos = (int)(0.5 * ((double)screenSize.height - this.getSize().getHeight()));
            int xPos = (int)(0.5 * ((double)screenSize.width - this.getSize().getWidth()));
            this.log("constructor: ypos = " + yPos + " , xPos = " + xPos);
            this.setLocation(xPos, yPos);
            this.setVisible(true);
        }
        catch (HeadlessException e) {
            this.log(e.getMessage());
        }
    }

    private void log(String message) {
    }

    public JCheckBox getCheckBox(int index) {
        return this.checkBoxes.get(index);
    }

    public int getCheckBoxCount() {
        return this.checkBoxes.size();
    }
}

