/*
 * Decompiled with CFR 0.152.
 */
package data;

import chart.Axis;
import chart.Filter;
import chart.ParallelCoordinatesChart;
import data.Cluster;
import data.NumberParser;
import data.Parameter;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Hashtable;

public class Design
implements Serializable {
    static final long serialVersionUID = 4L;
    static final boolean printLog = false;
    private Hashtable<Parameter, String> stringParameterValues = new Hashtable(0, 1.0f);
    private Hashtable<Parameter, Float> numericalParameterValues = new Hashtable(0, 1.0f);
    private int id;
    private Cluster cluster;
    private Hashtable<Filter, Boolean> activationMap = new Hashtable(0, 1.0f);
    private boolean insideBounds;
    private boolean selected = false;

    public Design(int id) {
        this.id = id;
    }

    public void setValue(Parameter param, String parameterValue) {
        block3: {
            try {
                this.numericalParameterValues.put(param, Float.valueOf(NumberParser.parseNumber(parameterValue)));
                param.setAtLeastOneNumeric(true);
                if (this.stringParameterValues.containsKey(param)) {
                    this.stringParameterValues.remove(param);
                }
            }
            catch (ParseException e1) {
                this.log("setValue: parameterValue " + parameterValue + " was not recogized as numeric. Parameter " + param.getName() + " set to non-numeric.");
                param.setNumeric(false);
                this.stringParameterValues.put(param, parameterValue);
                if (!this.numericalParameterValues.containsKey(param)) break block3;
                this.numericalParameterValues.remove(param);
            }
        }
    }

    public double getDoubleValue(Parameter param) {
        if (this.stringParameterValues.containsKey(param)) {
            return param.getDoubleValueOf(this.stringParameterValues.get(param));
        }
        if (this.numericalParameterValues.containsKey(param) && param.isNumeric()) {
            return this.numericalParameterValues.get(param).floatValue();
        }
        if (this.numericalParameterValues.containsKey(param)) {
            return param.getDoubleValueOf(Float.toString(this.numericalParameterValues.get(param).floatValue()));
        }
        throw new IllegalArgumentException("Unknown parameter " + param.getName());
    }

    public String getStringValue(Parameter param) {
        if (this.stringParameterValues.containsKey(param)) {
            return this.stringParameterValues.get(param);
        }
        if (this.numericalParameterValues.containsKey(param)) {
            return Float.toString(this.numericalParameterValues.get(param).floatValue());
        }
        throw new IllegalArgumentException("Unknown parameter " + param.getName());
    }

    public void removeParameter(Parameter param) {
        if (this.stringParameterValues.containsKey(param)) {
            this.stringParameterValues.remove(param);
        } else if (this.numericalParameterValues.containsKey(param)) {
            this.numericalParameterValues.remove(param);
        } else {
            throw new IllegalArgumentException("Unknown parameter " + param.getName());
        }
    }

    public boolean isActive(ParallelCoordinatesChart chart) {
        int i = 0;
        while (i < chart.getAxisCount()) {
            Filter uf = chart.getAxis(i).getUpperFilter();
            Filter lf = chart.getAxis(i).getLowerFilter();
            if (!this.activationMap.containsKey(uf)) {
                this.activationMap.put(uf, true);
            }
            if (!this.activationMap.containsKey(lf)) {
                this.activationMap.put(lf, true);
            }
            if (chart.getAxis(i).isFilterInverted()) {
                if (!this.activationMap.get(uf).booleanValue() && !this.activationMap.get(lf).booleanValue()) {
                    return false;
                }
            } else {
                if (!this.activationMap.get(uf).booleanValue()) {
                    return false;
                }
                if (!this.activationMap.get(lf).booleanValue()) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public void setActive(Filter filter, boolean active) {
        this.log("setting activation of filter to " + active);
        this.activationMap.put(filter, active);
    }

    public void evaluateBounds(ParallelCoordinatesChart chart) {
        this.insideBounds = true;
        int i = 0;
        while (i < chart.getAxisCount()) {
            if (!this.isInsideBounds(chart.getAxis(i))) {
                this.insideBounds = false;
                return;
            }
            ++i;
        }
    }

    private boolean isInsideBounds(Axis axis) {
        double value = this.getDoubleValue(axis.getParameter());
        double max = axis.getMax();
        double min = axis.getMin();
        return min <= value && value <= max;
    }

    public boolean isInsideBounds(ParallelCoordinatesChart chart) {
        return this.insideBounds;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    private void log(String message) {
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }
}

