/*
 * Decompiled with CFR 0.152.
 */
package actionListeners.scatter2DChartFrame;

import chart.ScatterChart2D;
import gui.dialogs.ScatterChart2DSettingsDialog;
import gui.frames.ChartFrame;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import xdat.Main;

public class Scatter2DChartFrameOptionsMenuActionListener
implements ActionListener {
    private Main mainWindow;
    static final boolean printLog = false;
    private ScatterChart2D chart;
    private ChartFrame chartFrame;

    public Scatter2DChartFrameOptionsMenuActionListener(Main mainWindow, ScatterChart2D chart, ChartFrame chartFrame) {
        this.mainWindow = mainWindow;
        this.chart = chart;
        this.chartFrame = chartFrame;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.log("constructor called");
        if (e.getActionCommand().equals("Settings")) {
            new ScatterChart2DSettingsDialog(this.mainWindow, this.chartFrame, this.chart);
        } else if (e.getActionCommand().equals("Reset to Default")) {
            this.chart.resetDisplaySettingsToDefault();
            this.chartFrame.repaint();
        } else if (e.getActionCommand().equals("Export to png")) {
            int returnVal;
            JFileChooser chooser = new JFileChooser();
            if (Main.getUserPreferences().getCurrentDir() != null) {
                chooser.setCurrentDirectory(new File(Main.getUserPreferences().getCurrentDir()));
            }
            if ((returnVal = chooser.showSaveDialog(null)) == 0) {
                String filepath = chooser.getSelectedFile().getAbsolutePath();
                String filename = chooser.getSelectedFile().getName();
                if (!filename.endsWith(".png")) {
                    filepath = String.valueOf(filepath) + ".png";
                }
                Main.getUserPreferences().setLastFile(filepath);
                try {
                    BufferedImage bi = new BufferedImage(this.chartFrame.getChartPanel().getWidth(), this.chartFrame.getChartPanel().getHeight(), 2);
                    Graphics2D g = bi.createGraphics();
                    this.chartFrame.getChartPanel().paint(g);
                    g.dispose();
                    ImageIO.write((RenderedImage)bi, "png", new File(filepath));
                }
                catch (IOException exc) {
                    JOptionPane.showMessageDialog(this.chartFrame, "IOException on saving image: " + exc.getMessage(), "Export to Image", 0);
                }
            }
        } else {
            System.out.println(e.getActionCommand());
        }
    }

    private void log(String message) {
    }
}

