/*
 * Decompiled with CFR 0.152.
 */
package actionListeners.parallelCoordinatesDisplaySettings;

import chart.ParallelCoordinatesChart;
import gui.panels.ParallelCoordinatesChartDisplaySettingsPanel;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JColorChooser;
import xdat.Main;
import xdat.UserPreferences;

public class ParallelChartDisplaySettingsActionListener
implements ActionListener {
    static final boolean printLog = false;
    private UserPreferences userPreferences;
    private ParallelCoordinatesChartDisplaySettingsPanel panel;
    private Color backGroundColor;
    private Color activeDesignColor;
    private Color selectedDesignColor;
    private Color filteredDesignColor;
    private Color filterColor;
    private boolean showFilteredDesigns;
    private boolean showDesignIDs;

    public ParallelChartDisplaySettingsActionListener(Main mainWindow, ParallelCoordinatesChartDisplaySettingsPanel panel) {
        this.log("constructor called for default settings.");
        this.userPreferences = Main.getUserPreferences();
        this.panel = panel;
        this.backGroundColor = this.userPreferences.getParallelCoordinatesDefaultBackgroundColor();
        this.activeDesignColor = this.userPreferences.getParallelCoordinatesActiveDesignDefaultColor();
        this.selectedDesignColor = this.userPreferences.getParallelCoordinatesSelectedDesignDefaultColor();
        this.filteredDesignColor = this.userPreferences.getParallelCoordinatesFilteredDesignDefaultColor();
        this.filterColor = this.userPreferences.getParallelCoordinatesFilterDefaultColor();
        this.showFilteredDesigns = this.userPreferences.isParallelCoordinatesShowFilteredDesigns();
        this.showDesignIDs = this.userPreferences.isParallelCoordinatesShowDesignIDs();
    }

    public ParallelChartDisplaySettingsActionListener(Main mainWindow, ParallelCoordinatesChartDisplaySettingsPanel panel, ParallelCoordinatesChart chart) {
        this.log("constructor called for chart specific settings.");
        this.userPreferences = Main.getUserPreferences();
        this.panel = panel;
        this.backGroundColor = chart.getBackGroundColor();
        this.activeDesignColor = chart.getDefaultDesignColor(true);
        this.selectedDesignColor = chart.getSelectedDesignColor();
        this.filteredDesignColor = chart.getDefaultDesignColor(false);
        this.filterColor = chart.getFilterColor();
        this.showFilteredDesigns = chart.isShowFilteredDesigns();
        this.showDesignIDs = chart.isShowDesignIDs();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand == "Background Color") {
            Color newColor = JColorChooser.showDialog(this.panel, "Background Color", this.backGroundColor);
            if (newColor != null) {
                this.backGroundColor = newColor;
            }
            this.panel.getBackGroundColorButton().setCurrentColor(this.backGroundColor);
        } else if (actionCommand == "Active Design Color") {
            Color newColor = JColorChooser.showDialog(this.panel, "Active Design Color", this.activeDesignColor);
            if (newColor != null) {
                this.activeDesignColor = newColor;
            }
            this.panel.getActiveDesignColorButton().setCurrentColor(this.activeDesignColor);
        } else if (actionCommand == "Selected Design Color") {
            Color newColor = JColorChooser.showDialog(this.panel, "Selected Design Color", this.selectedDesignColor);
            if (newColor != null) {
                this.selectedDesignColor = newColor;
            }
            this.panel.getSelectedDesignColorButton().setCurrentColor(this.selectedDesignColor);
        } else if (actionCommand == "Filtered Design Color") {
            Color newColor = JColorChooser.showDialog(this.panel, "Filtered Design Color", this.filteredDesignColor);
            if (newColor != null) {
                this.filteredDesignColor = newColor;
            }
            this.panel.getFilteredDesignColorButton().setCurrentColor(this.filteredDesignColor);
        } else if (actionCommand == "Filter Color") {
            Color newColor = JColorChooser.showDialog(this.panel, "Filter Color", this.filterColor);
            if (newColor != null) {
                this.filterColor = newColor;
            }
            this.panel.getFilterColorButton().setCurrentColor(this.filterColor);
        } else if (actionCommand == "showfilteredDesignsTrue") {
            this.showFilteredDesigns = true;
        } else if (actionCommand == "showfilteredDesignsFalse") {
            this.showFilteredDesigns = false;
        } else if (actionCommand == "showDesignIDsTrue") {
            this.showDesignIDs = true;
        } else if (actionCommand == "showDesignIDsFalse") {
            this.showDesignIDs = false;
        } else if (actionCommand != "Yes" && actionCommand != "No") {
            System.out.println("ChartDisplaySettingsActionListener: " + e.getActionCommand());
        }
    }

    private void log(String message) {
    }

    public Color getActiveDesignColor() {
        return this.activeDesignColor;
    }

    public Color getSelectedDesignColor() {
        return this.selectedDesignColor;
    }

    public Color getBackGroundColor() {
        return this.backGroundColor;
    }

    public Color getFilterColor() {
        return this.filterColor;
    }

    public Color getFilteredDesignColor() {
        return this.filteredDesignColor;
    }

    public boolean isShowDesignIDs() {
        return this.showDesignIDs;
    }

    public boolean isShowFilteredDesigns() {
        return this.showFilteredDesigns;
    }
}

