/*
 * Decompiled with CFR 0.152.
 */
package actionListeners.parallelCoordinatesDisplaySettings;

import chart.Axis;
import chart.ParallelCoordinatesChart;
import gui.frames.ChartFrame;
import gui.tables.DataSheetTableColumnModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import xdat.Main;

public class ParallelChartContextMenuActionListener
implements ActionListener {
    static final boolean printLog = true;
    private Main mainWindow;
    private ChartFrame chartFrame;
    private Axis axis;

    public ParallelChartContextMenuActionListener(Main mainWindow, ChartFrame chartFrame, Axis axis) {
        this.mainWindow = mainWindow;
        this.chartFrame = chartFrame;
        this.axis = axis;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals("setCurrentFilterAsNewRange")) {
            this.axis.setFilterAsNewRange();
            this.chartFrame.repaint();
        } else if (actionCommand.equals("resetFilter")) {
            this.axis.resetFilters();
            this.chartFrame.repaint();
        } else if (actionCommand.equals("autofit")) {
            this.axis.autofit();
            this.chartFrame.repaint();
        } else if (actionCommand.equals("moveAxisLeft")) {
            DataSheetTableColumnModel cm = (DataSheetTableColumnModel)this.mainWindow.getDataSheetTablePanel().getDataTable().getColumnModel();
            int currentIndex = this.mainWindow.getDataSheet().getParameterIndex(this.axis.getName());
            boolean jumpedAxisWasInactive = true;
            while (currentIndex > 0 && jumpedAxisWasInactive) {
                jumpedAxisWasInactive = !((ParallelCoordinatesChart)this.chartFrame.getChart()).getAxis(currentIndex - 1).isActive();
                cm.moveColumn(currentIndex + 1, currentIndex);
                --currentIndex;
            }
        } else if (actionCommand.equals("moveAxisRight")) {
            DataSheetTableColumnModel cm = (DataSheetTableColumnModel)this.mainWindow.getDataSheetTablePanel().getDataTable().getColumnModel();
            int currentIndex = this.mainWindow.getDataSheet().getParameterIndex(this.axis.getName());
            boolean jumpedAxisWasInactive = true;
            while (currentIndex + 2 < cm.getColumnCount() && jumpedAxisWasInactive) {
                jumpedAxisWasInactive = !((ParallelCoordinatesChart)this.chartFrame.getChart()).getAxis(currentIndex + 1).isActive();
                cm.moveColumn(currentIndex + 1, currentIndex + 2);
                ++currentIndex;
            }
        } else if (actionCommand.equals("hideAxis")) {
            this.axis.setActive(false);
            this.chartFrame.repaint();
        } else if (actionCommand.equals("addTic")) {
            this.axis.setTicCount(this.axis.getTicCount() + 1);
            this.chartFrame.repaint();
        } else if (actionCommand.equals("removeTic")) {
            this.axis.setTicCount(Math.max(2, this.axis.getTicCount() - 1));
            this.chartFrame.repaint();
        } else if (actionCommand.equals("reduceDistanceThisAxis")) {
            this.axis.setWidth(Math.max(0, this.axis.getWidth() - 10));
            this.chartFrame.repaint();
        } else if (actionCommand.equals("increaseDistanceThisAxis")) {
            this.axis.setWidth(Math.max(0, this.axis.getWidth() + 10));
            this.chartFrame.repaint();
        } else if (actionCommand.equals("resetAllFilters")) {
            ParallelCoordinatesChart chart = this.axis.getChart();
            int i = 0;
            while (i < chart.getAxisCount()) {
                chart.getAxis(i).resetFilters();
                ++i;
            }
            this.chartFrame.repaint();
        } else if (actionCommand.equals("reduceDistanceAllAxes")) {
            ParallelCoordinatesChart chart = this.axis.getChart();
            int i = 0;
            while (i < chart.getAxisCount()) {
                chart.getAxis(i).setWidth(Math.max(0, chart.getAxis(i).getWidth() - 10));
                ++i;
            }
            this.chartFrame.repaint();
        } else if (actionCommand.equals("increaseDistanceAllAxes")) {
            ParallelCoordinatesChart chart = this.axis.getChart();
            int i = 0;
            while (i < chart.getAxisCount()) {
                chart.getAxis(i).setWidth(Math.max(0, chart.getAxis(i).getWidth() + 10));
                ++i;
            }
            this.chartFrame.repaint();
        } else {
            System.out.println(e.getActionCommand());
        }
    }

    private void log(String message) {
        if (Main.isLoggingEnabled()) {
            System.out.println(String.valueOf(this.getClass().getName()) + "." + message);
        }
    }
}

