/*
 * Decompiled with CFR 0.152.
 */
package actionListeners.parallelCoordinatesDisplaySettings;

import chart.Axis;
import chart.ParallelCoordinatesChart;
import gui.panels.AxisDisplaySettingsPanel;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import xdat.Main;

public class AxisDisplaySettingsActionListener
implements ActionListener,
ChangeListener {
    static final boolean printLog = false;
    private JDialog dialog;
    private Color axisColor;
    private Color axisLabelColor;
    private Color ticLabelColor;
    private boolean invertFilter;
    private boolean invertAxis;
    private boolean autoFitAxis;
    private AxisDisplaySettingsPanel panel;
    private ParallelCoordinatesChart parallelCoordinatesChart;
    private Axis currentAxis;
    private boolean spinnerValueChanged = false;

    public AxisDisplaySettingsActionListener(Main mainWindow, JDialog dialog, AxisDisplaySettingsPanel panel) {
        this.log("constructor for default settings called");
        this.panel = panel;
        this.dialog = dialog;
        this.axisColor = Main.getUserPreferences().getParallelCoordinatesAxisColor();
        this.axisLabelColor = Main.getUserPreferences().getParallelCoordinatesAxisLabelFontColor();
        this.ticLabelColor = Main.getUserPreferences().getParallelCoordinatesAxisTicLabelFontColor();
        this.invertFilter = Main.getUserPreferences().isFilterInverted();
        this.autoFitAxis = Main.getUserPreferences().isParallelCoordinatesAutoFitAxis();
    }

    public AxisDisplaySettingsActionListener(JDialog dialog, AxisDisplaySettingsPanel panel, ParallelCoordinatesChart chart) {
        this.log("constructor for chart specific settings called");
        this.dialog = dialog;
        this.panel = panel;
        this.parallelCoordinatesChart = chart;
        this.readSettings();
    }

    private void readSettings() {
        Axis axis = this.parallelCoordinatesChart.getAxis(this.panel.getAxisChoiceCombo().getSelectedItem().toString());
        this.log("readSettings: reading axis " + axis.getName());
        this.currentAxis = axis;
        this.axisColor = axis.getAxisColor();
        this.axisLabelColor = axis.getAxisLabelFontColor();
        this.ticLabelColor = axis.getAxisTicLabelFontColor();
        this.invertFilter = axis.isFilterInverted();
        this.invertAxis = axis.isAxisInverted();
        this.autoFitAxis = axis.isAutoFit();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.spinnerValueChanged = true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand == "Axis Color") {
            Color newColor = JColorChooser.showDialog(this.panel, "Axis Color", this.axisColor);
            if (newColor != null) {
                this.axisColor = newColor;
            }
            this.panel.getAxisColorButton().setCurrentColor(this.axisColor);
        } else if (actionCommand == "Axis Label Color") {
            Color newColor = JColorChooser.showDialog(this.panel, "Axis Label Color", this.axisLabelColor);
            if (newColor != null) {
                this.axisLabelColor = newColor;
            }
            this.panel.getAxisLabelColorButton().setCurrentColor(this.axisLabelColor);
        } else if (actionCommand == "Tic Label Color") {
            Color newColor = JColorChooser.showDialog(this.panel, "Tic Label Color", this.ticLabelColor);
            if (newColor != null) {
                this.ticLabelColor = newColor;
            }
            this.panel.getTicLabelColorButton().setCurrentColor(this.ticLabelColor);
        } else if (actionCommand == "invertFilterTrue") {
            this.invertFilter = true;
        } else if (actionCommand == "invertFilterFalse") {
            this.invertFilter = false;
        } else if (actionCommand == "invertAxisTrue") {
            this.invertAxis = true;
        } else if (actionCommand == "invertAxisFalse") {
            this.invertAxis = false;
        } else if (actionCommand == "autoFitAxisTrue") {
            this.autoFitAxis = true;
            this.panel.setAxisRangeFieldsEnabled(false);
        } else if (actionCommand == "autoFitAxisFalse") {
            this.autoFitAxis = false;
            this.panel.setAxisRangeFieldsEnabled(true);
        } else if (e.getActionCommand().equals("comboBoxChanged")) {
            this.log(" current axis 1 is " + this.currentAxis.getName());
            this.log(" selected axis 1 is " + this.panel.getAxisChoiceCombo().getSelectedItem().toString());
            if (this.isSettingsChanged()) {
                if (JOptionPane.showConfirmDialog(this.panel, "Save changes made to axis " + this.currentAxis.getName() + "?", "Axis Display Settings", 0) == 0) {
                    this.applySettings(this.currentAxis);
                } else {
                    this.dialog.repaint();
                }
            }
            this.readSettings();
            this.log(" current axis 2 is " + this.currentAxis.getName());
            this.log(" selected axis 2 is " + this.panel.getAxisChoiceCombo().getSelectedItem().toString());
            this.panel.setStates(this.parallelCoordinatesChart.getAxis(this.panel.getAxisChoiceCombo().getSelectedItem().toString()));
            this.spinnerValueChanged = false;
        } else {
            System.out.println(e.getActionCommand());
        }
    }

    private void log(String message) {
    }

    public Color getAxisColor() {
        return this.axisColor;
    }

    public Color getAxisLabelColor() {
        return this.axisLabelColor;
    }

    public boolean isInvertFilter() {
        return this.invertFilter;
    }

    public Color getTicLabelColor() {
        return this.ticLabelColor;
    }

    public Axis getCurrentAxis() {
        return this.currentAxis;
    }

    public void setCurrentAxis(Axis currentAxis) {
        this.currentAxis = currentAxis;
    }

    public void applySettings(Axis axis) {
        double upperFilterValue = Math.max(axis.getUpperFilter().getValue(), axis.getLowerFilter().getValue());
        double lowerFilterValue = Math.min(axis.getUpperFilter().getValue(), axis.getLowerFilter().getValue());
        axis.setAxisColor(this.axisColor);
        axis.setWidth((Integer)this.panel.getAxisWidthSpinner().getValue());
        axis.setAxisLabelFontColor(this.axisLabelColor);
        axis.setAxisLabelFontSize((Integer)this.panel.getAxisLabelFontSizeSpinner().getValue());
        axis.setTicLength((Integer)this.panel.getTicSizeSpinner().getValue());
        axis.setTicCount((Integer)this.panel.getTicCountSpinner().getValue());
        axis.setTicLabelFontColor(this.ticLabelColor);
        axis.setTicLabelFontSize((Integer)this.panel.getTicLabelFontSizeSpinner().getValue());
        axis.setFilterInverted(this.invertFilter);
        axis.setAxisInverted(this.invertAxis);
        axis.setAutoFit(this.autoFitAxis);
        if (this.autoFitAxis) {
            axis.autofit();
        } else {
            if (this.panel.getAxisMin() < this.panel.getAxisMax()) {
                axis.setMin(this.panel.getAxisMin());
            }
            if (this.panel.getAxisMax() > axis.getMin()) {
                axis.setMax(this.panel.getAxisMax());
            }
        }
        if (axis.isAxisInverted()) {
            this.log("applySettings: axis is inverted. Upper filter value should be the minimum of " + upperFilterValue + " and " + lowerFilterValue);
            axis.getUpperFilter().setValue(Math.min(upperFilterValue, lowerFilterValue));
            this.log("applySettings: Upper filter set to  " + axis.getUpperFilter().getValue());
            axis.getLowerFilter().setValue(Math.max(upperFilterValue, lowerFilterValue));
        } else {
            axis.getUpperFilter().setValue(Math.max(upperFilterValue, lowerFilterValue));
            axis.getLowerFilter().setValue(Math.min(upperFilterValue, lowerFilterValue));
        }
        this.panel.getChartFrame().getChartPanel().setSize(this.panel.getChartFrame().getChartPanel().getPreferredSize());
        this.panel.getChartFrame().repaint();
    }

    private boolean isSettingsChanged() {
        boolean settingsUnChanged;
        boolean bl = settingsUnChanged = !(this.axisColor != this.currentAxis.getAxisColor() || this.axisLabelColor != this.currentAxis.getAxisLabelFontColor() || this.ticLabelColor != this.currentAxis.getAxisLabelFontColor() || this.invertFilter != this.currentAxis.isFilterInverted() || this.invertAxis != this.currentAxis.isAxisInverted() || this.autoFitAxis != this.currentAxis.isAutoFit() || this.panel.getAxisMin() != this.currentAxis.getMin() && this.currentAxis.getParameter().isNumeric() || this.panel.getAxisMax() != this.currentAxis.getMax() && this.currentAxis.getParameter().isNumeric());
        return !settingsUnChanged || this.spinnerValueChanged;
    }

    public boolean isInvertAxis() {
        return this.invertAxis;
    }

    public boolean isAutoFitAxis() {
        return this.autoFitAxis;
    }
}

