/*
 * Decompiled with CFR 0.152.
 */
package xdat;

import chart.Chart;
import data.DataSheet;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;
import xdat.Main;

public class Session
implements Serializable {
    static final long serialVersionUID = 2L;
    static final boolean printLog = false;
    public static final String sessionFileExtension = ".ses";
    private String sessionName = "Untitled";
    private String sessionDirectory;
    private DataSheet currentDataSheet;
    private Vector<Chart> charts = new Vector(0, 1);

    public Session() {
        this.log("constructor called.");
    }

    public void saveToFile(String pathToFile) throws IOException {
        FileOutputStream fs = new FileOutputStream(pathToFile);
        ObjectOutputStream os = new ObjectOutputStream(fs);
        os.writeObject(this);
        os.close();
    }

    public static Session readFromFile(Main mainWindow, String pathToFile) throws InvalidClassException, IOException, ClassNotFoundException {
        FileInputStream fs = new FileInputStream(pathToFile);
        ObjectInputStream is = new ObjectInputStream(fs);
        Session readSession = (Session)is.readObject();
        is.close();
        return readSession;
    }

    public Chart getChart(int index) {
        return this.charts.get(index);
    }

    public int getChartCount() {
        return this.charts.size();
    }

    public void addChart(Chart chart) {
        this.charts.add(chart);
    }

    public boolean removeChart(Chart chart) {
        return this.charts.remove(chart);
    }

    public void clearAllCharts() {
        this.charts.removeAllElements();
    }

    public DataSheet getCurrentDataSheet() {
        return this.currentDataSheet;
    }

    public void setCurrentDataSheet(DataSheet currentDataSheet) {
        this.currentDataSheet = currentDataSheet;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public String getSessionDirectory() {
        return this.sessionDirectory;
    }

    public void setSessionDirectory(String sessionDirectory) {
        this.sessionDirectory = sessionDirectory;
    }

    private void log(String message) {
    }
}

