/*
 * Decompiled with CFR 0.152.
 */
package xdat;

import actionListeners.scatter2DChartSettings.ParallelChartFrameComboModel;
import chart.Chart;
import chart.ParallelCoordinatesChart;
import data.DataSheet;
import exceptions.NoParametersDefinedException;
import gui.WindowClosingAdapter;
import gui.dialogs.LicenseDisplayDialog;
import gui.frames.ChartFrame;
import gui.menus.mainWIndow.MainMenuBar;
import gui.panels.DataSheetTablePanel;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InvalidClassException;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ListDataListener;
import xdat.Session;
import xdat.UserPreferences;

public class Main
extends JFrame {
    public static final long serialVersionUID = 6L;
    public static final String versionString = "2.0";
    public static final boolean loggingEnabled = false;
    public static final boolean printLog = false;
    private MainMenuBar mainMenuBar;
    private transient DataSheetTablePanel dataSheetTablePanel;
    private Session currentSession;
    private Vector<ChartFrame> chartFrames = new Vector(0, 1);
    private transient Vector<ListDataListener> listDataListener = new Vector();
    private transient Vector<ParallelChartFrameComboModel> comboModels = new Vector(0);

    public Main() {
        super("xdat   -   Untitled");
        new UserPreferences(versionString);
        if (!this.checkLicense()) {
            this.dispose();
            return;
        }
        this.currentSession = new Session();
        this.addWindowListener(new WindowClosingAdapter(true));
        this.mainMenuBar = new MainMenuBar(this);
        this.setJMenuBar(this.mainMenuBar);
        Dimension screenSize = this.getToolkit().getScreenSize();
        this.setLocation((int)(0.25 * (double)screenSize.width), (int)(0.25 * (double)screenSize.height));
        this.setSize((int)(0.5 * (double)screenSize.width), (int)(0.5 * (double)screenSize.height));
        this.setVisible(true);
    }

    public void initialiseDataPanel() {
        this.log("updateDataPanel called");
        if (this.dataSheetTablePanel == null) {
            this.log("updateDataPanel: dataSheetTablePanel null");
            this.dataSheetTablePanel = new DataSheetTablePanel(this);
            this.setContentPane(this.dataSheetTablePanel);
            this.dataSheetTablePanel.revalidate();
        } else if (this.currentSession.getCurrentDataSheet() != null) {
            this.log("updateDataPanel: DataSheet non-null");
            this.dataSheetTablePanel.initialiseRunsTableModel();
            this.dataSheetTablePanel.revalidate();
        } else {
            this.setContentPane(new JPanel());
            this.repaint();
        }
    }

    public void updateDataPanel() {
        this.log("updateDataPanel called");
        if (this.dataSheetTablePanel == null) {
            this.log("updateDataPanel: dataSheetTablePanel null");
            this.dataSheetTablePanel = new DataSheetTablePanel(this);
            this.setContentPane(this.dataSheetTablePanel);
            this.dataSheetTablePanel.revalidate();
        } else if (this.currentSession.getCurrentDataSheet() != null) {
            this.log("updateDataPanel: DataSheet non-null");
            this.dataSheetTablePanel.updateRunsTableModel();
            this.dataSheetTablePanel.revalidate();
        } else {
            this.setContentPane(new JPanel());
            this.repaint();
        }
    }

    public static void main(String[] args) {
        new Main();
    }

    public DataSheet getDataSheet() {
        return this.currentSession.getCurrentDataSheet();
    }

    public void setDataSheet(DataSheet dataSheet) {
        this.currentSession.setCurrentDataSheet(dataSheet);
        if (dataSheet == null) {
            this.remove(this.dataSheetTablePanel);
        }
        this.initialiseDataPanel();
        this.repaint();
    }

    public static UserPreferences getUserPreferences() {
        return new UserPreferences(versionString);
    }

    public static String getVersionString() {
        return versionString;
    }

    public Session getCurrentSession() {
        return this.currentSession;
    }

    public void setCurrentSession(Session currentSession) {
        this.currentSession = currentSession;
    }

    public void addChartFrame(ChartFrame chartFrame) {
        this.chartFrames.add(chartFrame);
        this.addChartToComboboxes(chartFrame);
    }

    public void removeChartFrame(ChartFrame chartFrame) {
        this.chartFrames.remove(chartFrame);
        this.currentSession.removeChart(chartFrame.getChart());
        this.removeChartFromComboboxes(chartFrame);
    }

    public ChartFrame getChartFrame(int index) {
        return this.chartFrames.get(index);
    }

    public ChartFrame getChartFrame(String title) {
        int i = 0;
        while (i < this.getChartFrameCount()) {
            if (title.equals(this.getChartFrame(i).getTitle())) {
                return this.getChartFrame(i);
            }
            ++i;
        }
        throw new RuntimeException("No chart found with title " + title);
    }

    public int getChartFrameCount() {
        return this.chartFrames.size();
    }

    public int getUniqueChartId(Class chartClass) {
        int id = 0;
        int i = 0;
        while (i < this.getChartFrameCount()) {
            if (chartClass.equals(this.chartFrames.get(i).getChart().getClass())) {
                id = this.chartFrames.get(i).getChart().getID();
            }
            ++i;
        }
        return ++id;
    }

    public void disposeAllChartFrames() {
        int i = this.chartFrames.size() - 1;
        while (i >= 0) {
            this.removeChartFromComboboxes(this.chartFrames.get(i));
            this.chartFrames.get(i).dispose();
            --i;
        }
        this.chartFrames.removeAllElements();
        this.currentSession.clearAllCharts();
    }

    public void rebuildAllChartFrames() {
        this.log("rebuildAllChartFrames:------------------------------------- ");
        Chart[] charts = new Chart[this.currentSession.getChartCount()];
        this.log("rebuildAllChartFrames: currently " + charts.length + " charts active. ");
        int i = 0;
        while (i < charts.length) {
            this.log("rebuildAllChartFrames: reading chart " + i);
            charts[i] = this.currentSession.getChart(i);
            ++i;
        }
        this.disposeAllChartFrames();
        this.log("rebuildAllChartFrames: still " + charts.length + " charts active. ");
        i = 0;
        while (i < charts.length) {
            this.log("rebuildAllChartFrames: creating chart " + i);
            try {
                ChartFrame newFrame = new ChartFrame(this, charts[i]);
                this.chartFrames.add(newFrame);
                this.currentSession.addChart(charts[i]);
            }
            catch (NoParametersDefinedException e) {
                JOptionPane.showMessageDialog(this, "Cannot create chart when no parameters are defined.", "No parameters defined!", 0);
            }
            ++i;
        }
        this.log("rebuildAllChartFrames: done. Session has now " + this.currentSession.getChartCount() + " active charts.");
    }

    public void repaintAllChartFrames() {
        this.log("repaintAllChartFrames:------------------------------------- ");
        int i = 0;
        while (i < this.chartFrames.size()) {
            this.chartFrames.get(i).repaint();
            ++i;
        }
    }

    public void refilterAllChartFrames(int columnIndex) {
        this.log("refilterAllChartFrames:------------------------------------- ");
        int i = 0;
        while (i < this.chartFrames.size()) {
            Chart c = this.chartFrames.get(i).getChart();
            if (c.getClass().equals(ParallelCoordinatesChart.class)) {
                ((ParallelCoordinatesChart)c).getAxis(columnIndex).applyFilters();
            }
            ++i;
        }
    }

    public void autofitAxisAllChartFrames(int axisIndex) {
        this.log("autofitAxisAllChartFrames:------------------------------------- ");
        int i = 0;
        while (i < this.chartFrames.size()) {
            Chart c = this.chartFrames.get(i).getChart();
            if (c.getClass().equals(ParallelCoordinatesChart.class)) {
                ((ParallelCoordinatesChart)c).getAxis(axisIndex).autofit();
            }
            ++i;
        }
    }

    public void resetFiltersOnAxisAllChartFrames(int axisIndex) {
        this.log("resetFiltersOnAxisAllChartFrames:------------------------------------- ");
        int i = 0;
        while (i < this.chartFrames.size()) {
            Chart c = this.chartFrames.get(i).getChart();
            if (c.getClass().equals(ParallelCoordinatesChart.class)) {
                ((ParallelCoordinatesChart)c).getAxis(axisIndex).resetFilters();
            }
            ++i;
        }
    }

    public void loadSession(String pathToFile) {
        try {
            this.disposeAllChartFrames();
            this.currentSession = Session.readFromFile(this, pathToFile);
            this.setTitle("xdat   -   " + pathToFile);
            this.log("loadSession called. " + this.getChartFrameCount() + " chart frames to load.");
            ChartFrame[] chartFrames = new ChartFrame[this.currentSession.getChartCount()];
            int i = 0;
            while (i < chartFrames.length) {
                try {
                    new ChartFrame(this, this.currentSession.getChart(i));
                }
                catch (NoParametersDefinedException e) {
                    JOptionPane.showMessageDialog(this, "Cannot create chart when no parameters are defined.", "No parameters defined!", 0);
                }
                ++i;
            }
            if (this.currentSession.getCurrentDataSheet() != null) {
                this.getMainMenuBar().setItemsRequiringDataSheetEnabled(true);
            } else {
                this.initialiseDataPanel();
                this.getMainMenuBar().setItemsRequiringDataSheetEnabled(false);
            }
        }
        catch (InvalidClassException e) {
            JOptionPane.showMessageDialog(this, "The file " + pathToFile + " is not a proper xdat version " + versionString + " Session file", "Load Session", 0);
        }
        catch (ClassNotFoundException e) {
            JOptionPane.showMessageDialog(this, "The file " + pathToFile + " is not a proper xdat version " + versionString + " Session file", "Load Session", 0);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Error on loading session: " + e.getMessage(), "Load Session", 0);
        }
    }

    public void saveSessionAs(String pathToFile) {
        int i = 0;
        while (i < this.currentSession.getChartCount()) {
            this.log("saving session with chart " + i);
            ++i;
        }
        try {
            this.currentSession.saveToFile(pathToFile);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "IOException on saving session: " + e.getMessage(), "Save Session", 0);
        }
    }

    private boolean checkLicense() {
        if (!Main.getUserPreferences().isLicenseAccepted()) {
            new LicenseDisplayDialog(Main.getUserPreferences());
        }
        return Main.getUserPreferences().isLicenseAccepted();
    }

    public static boolean isLoggingEnabled() {
        return false;
    }

    public MainMenuBar getMainMenuBar() {
        return this.mainMenuBar;
    }

    private void log(String message) {
    }

    public DataSheetTablePanel getDataSheetTablePanel() {
        return this.dataSheetTablePanel;
    }

    public void addChartToComboboxes(ChartFrame chartFrame) {
        int i = 0;
        while (i < this.comboModels.size()) {
            if (chartFrame.getChart().getClass().equals(ParallelCoordinatesChart.class)) {
                this.comboModels.get(i).addElement(chartFrame.getChart().getTitle());
            }
            ++i;
        }
    }

    public void removeChartFromComboboxes(ChartFrame chartFrame) {
        int i = 0;
        while (i < this.comboModels.size()) {
            if (chartFrame.getChart().getClass().equals(ParallelCoordinatesChart.class)) {
                this.comboModels.get(i).removeElement(chartFrame.getChart().getTitle());
            }
            ++i;
        }
    }

    public void registerComboModel(ParallelChartFrameComboModel comboModel) {
        this.comboModels.add(comboModel);
    }

    public void unRegisterComboModel(ParallelChartFrameComboModel comboModel) {
        this.comboModels.remove(comboModel);
    }
}

