/*
 * Decompiled with CFR 0.152.
 */
package gui.menus.parallelCoordinatesChart;

import actionListeners.parallelCoordinatesDisplaySettings.ParallelChartContextMenuActionListener;
import chart.Axis;
import gui.frames.ChartFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import xdat.Main;

public class ParallelCoordinatesContextMenu
extends JPopupMenu {
    static final long serialVersionUID = 0L;

    public ParallelCoordinatesContextMenu(Main mainWindow, ChartFrame chartFrame, Axis axis) {
        this.add(new JLabel(" Axis settings: " + axis.getName()));
        this.add(new JPopupMenu.Separator());
        ParallelChartContextMenuActionListener cmd = new ParallelChartContextMenuActionListener(mainWindow, chartFrame, axis);
        JMenuItem setFilterAsNewRangeMenuItem = new JMenuItem("Set current filter as new range");
        setFilterAsNewRangeMenuItem.setActionCommand("setCurrentFilterAsNewRange");
        if (axis.isFilterInverted() || !axis.getParameter().isNumeric()) {
            setFilterAsNewRangeMenuItem.setEnabled(false);
        } else {
            setFilterAsNewRangeMenuItem.addActionListener(cmd);
        }
        this.add(setFilterAsNewRangeMenuItem);
        JMenuItem autofitMenuItem = new JMenuItem("Autofit");
        autofitMenuItem.setActionCommand("autofit");
        if (!axis.getParameter().isNumeric()) {
            autofitMenuItem.setEnabled(false);
        } else {
            autofitMenuItem.addActionListener(cmd);
        }
        this.add(autofitMenuItem);
        JMenuItem moveColumnLeftMenuItem = new JMenuItem("Move left                               ");
        this.addCustomHint(moveColumnLeftMenuItem, "(Left-click & drag)");
        moveColumnLeftMenuItem.setActionCommand("moveAxisLeft");
        moveColumnLeftMenuItem.addActionListener(cmd);
        this.add(moveColumnLeftMenuItem);
        JMenuItem moveColumnRightMenuItem = new JMenuItem("Move right                               ");
        moveColumnRightMenuItem.setActionCommand("moveAxisRight");
        this.addCustomHint(moveColumnRightMenuItem, "(Left-click & drag)");
        moveColumnRightMenuItem.addActionListener(cmd);
        this.add(moveColumnRightMenuItem);
        JMenuItem hideMenuItem = new JMenuItem("Hide axis                               ");
        hideMenuItem.setActionCommand("hideAxis");
        hideMenuItem.addActionListener(cmd);
        this.add(hideMenuItem);
        JMenuItem addTicMenuItem = new JMenuItem("Add tic                               ");
        addTicMenuItem.setActionCommand("addTic");
        this.addCustomHint(addTicMenuItem, "(Alt+Mouse Whl Up)");
        if (!axis.getParameter().isNumeric()) {
            addTicMenuItem.setEnabled(false);
        } else {
            addTicMenuItem.addActionListener(cmd);
        }
        this.add(addTicMenuItem);
        JMenuItem removeTicMenuItem = new JMenuItem("Remove tic                               ");
        removeTicMenuItem.setActionCommand("removeTic");
        this.addCustomHint(removeTicMenuItem, "(Alt+Mouse Whl Down)");
        if (!axis.getParameter().isNumeric()) {
            removeTicMenuItem.setEnabled(false);
        } else {
            removeTicMenuItem.addActionListener(cmd);
        }
        this.add(removeTicMenuItem);
        JMenuItem increaseDistanceThisAxisMenuItem = new JMenuItem("Increase spacing                               ");
        increaseDistanceThisAxisMenuItem.setActionCommand("increaseDistanceThisAxis");
        this.addCustomHint(increaseDistanceThisAxisMenuItem, "(Ctrl+Mouse Whl Up)");
        increaseDistanceThisAxisMenuItem.addActionListener(cmd);
        this.add(increaseDistanceThisAxisMenuItem);
        JMenuItem reduceDistanceThisAxisMenuItem = new JMenuItem("Reduce spacing                                ");
        reduceDistanceThisAxisMenuItem.setActionCommand("reduceDistanceThisAxis");
        this.addCustomHint(reduceDistanceThisAxisMenuItem, "(Ctrl+Mouse Whl Down)");
        reduceDistanceThisAxisMenuItem.addActionListener(cmd);
        this.add(reduceDistanceThisAxisMenuItem);
        JMenuItem increaseDistanceAllAxesMenuItem = new JMenuItem("Increase spacing all axes                               ");
        increaseDistanceAllAxesMenuItem.setActionCommand("increaseDistanceAllAxes");
        this.addCustomHint(increaseDistanceAllAxesMenuItem, "(Mouse Whl Up)");
        increaseDistanceAllAxesMenuItem.addActionListener(cmd);
        this.add(increaseDistanceAllAxesMenuItem);
        JMenuItem reduceDistanceAllAxesMenuItem = new JMenuItem("Reduce spacing all axes                                ");
        reduceDistanceAllAxesMenuItem.setActionCommand("reduceDistanceAllAxes");
        this.addCustomHint(reduceDistanceAllAxesMenuItem, "(Mouse Whl Down)");
        reduceDistanceAllAxesMenuItem.addActionListener(cmd);
        this.add(reduceDistanceAllAxesMenuItem);
    }

    private void addCustomHint(JMenuItem item, String hint) {
        item.setLayout(new BorderLayout());
        JLabel label = new JLabel(String.valueOf(hint) + " ");
        label.setFont(new Font("SansSerif", 0, 12));
        label.setForeground(new Color(140, 140, 180));
        item.add((Component)label, "East");
    }
}

