/*
 * Decompiled with CFR 0.152.
 */
package gui.frames;

import chart.Chart;
import chart.ParallelCoordinatesChart;
import chart.ScatterChart2D;
import exceptions.NoParametersDefinedException;
import gui.ChartFrameClosingAdapter;
import gui.menus.ScatterChart2D.ScatterChart2DFrameMenuBar;
import gui.menus.parallelCoordinatesChart.ParallelCoordinateChartFrameMenuBar;
import gui.panels.ChartPanel;
import gui.panels.ParallelCoordinatesChartPanel;
import gui.panels.ScatterChart2DPanel;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import xdat.Main;

public class ChartFrame
extends JFrame
implements ComponentListener {
    static final long serialVersionUID = 1L;
    static final boolean printLog = false;
    private Main mainWindow;
    private Chart chart;
    private ChartPanel chartPanel;
    private Vector<JDialog> registeredDialog = new Vector(0);

    public ChartFrame(Main mainWindow, Chart chart) throws NoParametersDefinedException {
        super(chart.getTitle());
        this.log("constructor invoked.");
        if (mainWindow.getDataSheet().getParameterCount() < 1) {
            throw new NoParametersDefinedException();
        }
        this.addWindowListener(new ChartFrameClosingAdapter(this, mainWindow));
        this.mainWindow = mainWindow;
        this.chart = chart;
        mainWindow.addChartFrame(this);
        this.setLayout(new GridLayout(1, 1));
        if (chart.getClass().equals(ParallelCoordinatesChart.class)) {
            try {
                this.chartPanel = new ParallelCoordinatesChartPanel(mainWindow, this, (ParallelCoordinatesChart)this.chart);
                this.setJMenuBar(new ParallelCoordinateChartFrameMenuBar(mainWindow, this, (ParallelCoordinatesChart)this.chart));
                JScrollPane scrollPane = new JScrollPane(this.chartPanel, 21, 30);
                this.add(scrollPane);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (chart.getClass().equals(ScatterChart2D.class)) {
            this.chartPanel = new ScatterChart2DPanel(mainWindow, (ScatterChart2D)this.chart);
            this.setJMenuBar(new ScatterChart2DFrameMenuBar(mainWindow, this, (ScatterChart2D)chart));
            this.add((Component)this.chartPanel, "Center");
        } else {
            throw new RuntimeException("Unknown Chart Type!");
        }
        this.setLocation(this.chart.getLocation());
        this.getContentPane().setPreferredSize(this.chart.getFrameSize());
        this.pack();
        this.addComponentListener(this);
        this.setVisible(true);
    }

    public Chart getChart() {
        return this.chart;
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }

    @Override
    public void dispose() {
        this.log("dispose called");
        this.mainWindow.removeChartFrame(this);
        super.dispose();
    }

    private void log(String message) {
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        int i = 0;
        while (i < this.registeredDialog.size()) {
            this.registeredDialog.get(i).repaint();
            ++i;
        }
    }

    public void registerComponentForRepaint(JDialog comp) {
        this.log("registerComponentForRepaint");
        this.registeredDialog.add(comp);
    }

    public void unRegisterComponentForRepaint(JDialog comp) {
        this.log("unRegisterComponentForRepaint");
        if (this.registeredDialog.contains(comp)) {
            this.registeredDialog.remove(comp);
        }
    }

    public Main getMainWindow() {
        return this.mainWindow;
    }

    @Override
    public void componentHidden(ComponentEvent arg0) {
    }

    @Override
    public void componentMoved(ComponentEvent arg0) {
        this.chart.setLocation(this.getLocation());
    }

    @Override
    public void componentResized(ComponentEvent arg0) {
        this.chart.setFrameSize(this.getContentPane().getSize());
    }

    @Override
    public void componentShown(ComponentEvent arg0) {
    }
}

