/*
 * Decompiled with CFR 0.152.
 */
package gui.dialogs;

import actionListeners.parallelCoordinatesDisplaySettings.AxisDisplaySettingsActionListener;
import actionListeners.parallelCoordinatesDisplaySettings.ParallelChartDisplaySettingsActionListener;
import chart.ParallelCoordinatesChart;
import gui.WindowClosingAdapter;
import gui.frames.ChartFrame;
import gui.panels.AxisDisplaySettingsPanel;
import gui.panels.ParallelCoordinatesChartDisplaySettingsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import javax.swing.JDialog;
import javax.swing.JTabbedPane;
import xdat.Main;

public class ParallelCoordinatesDisplaySettingsDialog
extends JDialog {
    static final long serialVersionUID = 1L;
    private static final boolean printLog = false;
    private Main mainWindow;
    private ParallelCoordinatesChartDisplaySettingsPanel chartDisplaySettingsPanel;
    private AxisDisplaySettingsPanel axisDisplaySettingsPanel;

    public ParallelCoordinatesDisplaySettingsDialog(Main mainWindow) throws HeadlessException {
        super(mainWindow, "Parallel Coord Settings", true);
        this.mainWindow = mainWindow;
        this.chartDisplaySettingsPanel = new ParallelCoordinatesChartDisplaySettingsPanel(this.mainWindow, this);
        this.axisDisplaySettingsPanel = new AxisDisplaySettingsPanel(this.mainWindow, this);
        this.chartDisplaySettingsPanel.setActionListener(new ParallelChartDisplaySettingsActionListener(mainWindow, this.chartDisplaySettingsPanel));
        this.axisDisplaySettingsPanel.setActionListener(new AxisDisplaySettingsActionListener(mainWindow, this, this.axisDisplaySettingsPanel));
        this.buildDialog();
        this.chartDisplaySettingsPanel.setOkCancelButtonTargetDefaultSettings();
        this.axisDisplaySettingsPanel.setOkCancelButtonTargetDefaultSettings();
        this.setVisible(true);
    }

    public ParallelCoordinatesDisplaySettingsDialog(Main mainWindow, ParallelCoordinatesChart chart, ChartFrame chartFrame) throws HeadlessException {
        super((Frame)chartFrame, "Display Settings");
        this.setModal(true);
        this.mainWindow = mainWindow;
        this.chartDisplaySettingsPanel = new ParallelCoordinatesChartDisplaySettingsPanel(this.mainWindow, this, chartFrame);
        this.axisDisplaySettingsPanel = new AxisDisplaySettingsPanel(this.mainWindow, this, chartFrame);
        this.chartDisplaySettingsPanel.setActionListener(new ParallelChartDisplaySettingsActionListener(mainWindow, this.chartDisplaySettingsPanel, chart));
        this.axisDisplaySettingsPanel.setActionListener(new AxisDisplaySettingsActionListener(this, this.axisDisplaySettingsPanel, chart));
        this.buildDialog();
        this.chartDisplaySettingsPanel.setOkCancelButtonTargetChart(chart);
        this.axisDisplaySettingsPanel.setOkCancelButtonTargetChart(chart);
        ParallelCoordinatesDisplaySettingsDialog.log("preferred size : " + this.getPreferredSize().width + ", " + this.getPreferredSize().getHeight());
        this.setVisible(true);
    }

    private void buildDialog() {
        ParallelCoordinatesDisplaySettingsDialog.log("constructor called");
        this.addWindowListener(new WindowClosingAdapter(false));
        this.setResizable(false);
        JTabbedPane tabbedPane = new JTabbedPane();
        this.setLayout(new BorderLayout());
        this.add((Component)tabbedPane, "Center");
        tabbedPane.add("General", this.chartDisplaySettingsPanel);
        tabbedPane.add("Axis-specific", this.axisDisplaySettingsPanel);
        this.pack();
        int left = (int)(0.5 * (double)this.mainWindow.getSize().width) - (int)((double)this.getSize().width * 0.5) + this.mainWindow.getLocation().x;
        int top = (int)(0.5 * (double)this.mainWindow.getSize().height) - (int)((double)this.getSize().height * 0.5) + this.mainWindow.getLocation().y;
        this.setLocation(left, top);
    }

    public AxisDisplaySettingsPanel getAxisDisplaySettingsPanel() {
        return this.axisDisplaySettingsPanel;
    }

    public ParallelCoordinatesChartDisplaySettingsPanel getChartDisplaySettingsPanel() {
        return this.chartDisplaySettingsPanel;
    }

    private static final void log(String message) {
    }
}

