/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.DataSheet;
import data.NumberParser;
import exceptions.CorruptDataException;
import java.awt.FontMetrics;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;

public class Parameter
implements Serializable {
    static final long serialVersionUID = 3L;
    static final boolean printLog = false;
    private DataSheet dataSheet;
    private String name;
    private boolean numeric = true;
    private boolean atLeastOneNumeric = false;
    private boolean atLeastOneNonNumeric = false;
    private TreeSet<String> discreteLevels = new TreeSet<String>(new ReverseStringComparator());

    public Parameter(String name, DataSheet dataSheet) {
        this.name = name;
        this.dataSheet = dataSheet;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isMixed() {
        return this.atLeastOneNonNumeric && this.atLeastOneNumeric;
    }

    public double getMaxValue() {
        double max = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < this.dataSheet.getDesignCount()) {
            double value = this.dataSheet.getDesign(i).getDoubleValue(this);
            if (value > max) {
                max = value;
            }
            ++i;
        }
        return max;
    }

    public double getMinValue() {
        double min = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < this.dataSheet.getDesignCount()) {
            double value = this.dataSheet.getDesign(i).getDoubleValue(this);
            if (value < min) {
                min = value;
            }
            ++i;
        }
        return min;
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public boolean checkIfNumeric() {
        this.numeric = true;
        int i = 0;
        while (i < this.dataSheet.getDesignCount()) {
            try {
                String string = this.dataSheet.getDesign(i).getStringValue(this);
                NumberParser.parseNumber(string.toString());
                this.atLeastOneNumeric = true;
            }
            catch (ParseException e) {
                this.setNumeric(false);
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setNumeric(boolean numeric) {
        if (this.numeric && !numeric) {
            this.atLeastOneNonNumeric = true;
            int i = 0;
            while (i < this.dataSheet.getDesignCount()) {
                String string = this.dataSheet.getDesign(i).getStringValue(this);
                int index = 0;
                Iterator<String> it = this.discreteLevels.iterator();
                boolean stringFound = false;
                while (it.hasNext()) {
                    if (string.equalsIgnoreCase(it.next())) {
                        stringFound = true;
                        break;
                    }
                    ++index;
                }
                if (!stringFound) {
                    this.log("getDoubleValueOf: string " + string + " not found, adding it to tree set ");
                    this.discreteLevels.add(string);
                }
                ++i;
            }
        }
        this.numeric = numeric;
    }

    public void setAtLeastOneNumeric(boolean atLeastOneNumeric) {
        this.atLeastOneNumeric = atLeastOneNumeric;
    }

    public double getDoubleValueOf(String string) {
        if (this.numeric) {
            try {
                double value = NumberParser.parseNumber(string);
                this.atLeastOneNumeric = true;
                return value;
            }
            catch (ParseException e1) {
                this.setNumeric(false);
                this.atLeastOneNonNumeric = true;
            }
        }
        int index = 0;
        Iterator<String> it = this.discreteLevels.iterator();
        this.log("getDoubleValueOf: checking index of string " + string);
        while (it.hasNext()) {
            if (string.equalsIgnoreCase(it.next())) {
                return index;
            }
            ++index;
        }
        this.log("getDoubleValueOf: string " + string + " not found, adding it to tree set ");
        this.discreteLevels.add(string);
        index = 0;
        it = this.discreteLevels.iterator();
        this.log("getDoubleValueOf: re-checking index of string " + string);
        while (it.hasNext()) {
            String next = it.next();
            this.log("getDoubleValueOf: comparing string " + string + " to string " + next);
            if (string.equalsIgnoreCase(next)) {
                this.log("getDoubleValueOf: match found, returning index " + index);
                return index;
            }
            ++index;
        }
        throw new CorruptDataException(this);
    }

    public String getStringValueOf(double value) {
        if (this.numeric) {
            this.log("getStringValueOf: Parameter " + this.name + " is numeric. Returning " + Double.toString(value));
            return Double.toString(value);
        }
        this.log("getStringValueOf: Parameter " + this.name + " is not numeric. ");
        this.log("value = " + value);
        int index = (int)value;
        this.log("getStringValueOf: index is " + index);
        int currentIndex = 0;
        Iterator<String> it = this.discreteLevels.iterator();
        while (it.hasNext()) {
            this.log("getStringValueOf: checking currentIndex " + currentIndex + " against index " + index);
            String next = it.next();
            if (currentIndex == index) {
                this.log("getStringValueOf: check positive. Returning string " + next);
                return next;
            }
            ++currentIndex;
        }
        throw new CorruptDataException(this);
    }

    public int getDiscreteLevelCount() {
        if (this.isNumeric()) {
            throw new RuntimeException("Parameter " + this.name + " is numeric!");
        }
        return this.discreteLevels.size();
    }

    public void checkOccurrenceInDiscreteLevel(String stringValueToCheck) {
        if (this.isNumeric()) {
            throw new RuntimeException("Parameter " + this.name + " is numeric!");
        }
        int occurrenceCount = 0;
        int i = 0;
        while (i < this.dataSheet.getDesignCount()) {
            if (this.dataSheet.getDesign(i).getStringValue(this).equalsIgnoreCase(stringValueToCheck)) {
                ++occurrenceCount;
            }
            ++i;
        }
        if (occurrenceCount < 1) {
            this.discreteLevels.remove(stringValueToCheck);
        }
    }

    public void resetDiscreteLevelsAndState() {
        this.log("resetDiscreteLevels called");
        this.discreteLevels = new TreeSet<String>(new ReverseStringComparator());
        this.numeric = true;
        this.atLeastOneNonNumeric = false;
        this.atLeastOneNumeric = false;
    }

    private void log(String message) {
    }

    public int getLongestTicLabelStringLength(FontMetrics fm, String numberFormat) {
        if (this.isNumeric()) {
            double minValue = Double.POSITIVE_INFINITY;
            double maxValue = Double.NEGATIVE_INFINITY;
            int i = 0;
            while (i < this.dataSheet.getDesignCount()) {
                if (this.dataSheet.getDesign(i).getDoubleValue(this) > maxValue) {
                    maxValue = this.dataSheet.getDesign(i).getDoubleValue(this);
                }
                if (this.dataSheet.getDesign(i).getDoubleValue(this) < minValue) {
                    minValue = this.dataSheet.getDesign(i).getDoubleValue(this);
                }
                ++i;
            }
            int minLength = fm.stringWidth(String.format(numberFormat, minValue));
            int maxLength = fm.stringWidth(String.format(numberFormat, maxValue));
            this.log("paintComponent: minLength " + minLength);
            this.log("paintComponent: maxLength " + maxLength);
            return Math.max(minLength, maxLength);
        }
        int length = 0;
        int i = 0;
        while (i < this.getDiscreteLevelCount()) {
            int tempLength = fm.stringWidth(this.getStringValueOf(i));
            if (tempLength > length) {
                length = tempLength;
            }
            ++i;
        }
        return length;
    }

    class ReverseStringComparator
    implements Comparator<String>,
    Serializable {
        static final long serialVersionUID = 0L;

        ReverseStringComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            return s2.compareToIgnoreCase(s1);
        }
    }
}

