/*
 * Decompiled with CFR 0.152.
 */
package chart;

import chart.ParallelCoordinatesChart;
import chart.Plot;
import data.DataSheet;
import data.Design;
import data.Parameter;
import java.awt.Color;
import xdat.Main;
import xdat.UserPreferences;

public class ScatterPlot2D
extends Plot {
    static final long serialVersionUID = 3L;
    static final boolean printLog = false;
    public static final int SHOW_ALL_DESIGNS = 0;
    public static final int SHOW_SELECTED_DESIGNS = 1;
    public static final int SHOW_DESIGNS_ACTIVE_IN_PARALLEL_CHART = 2;
    public static final int AXIS_LABEL_PADDING = 10;
    public static final int TIC_LABEL_PADDING = 5;
    public static final String TIC_LABEL_FORMAT = "%4.3f";
    private int displayedDesignSelectionMode = 0;
    private ParallelCoordinatesChart parallelCoordinatesChartForFiltering;
    private int dotRadius = 4;
    private Color activeDesignColor = new Color(0, 150, 0);
    private Color selectedDesignColor = Color.BLUE;
    private Parameter parameterForXAxis;
    private Parameter parameterForYAxis;
    private boolean showDecorations;
    private Color decorationsColor = Color.BLACK;
    private boolean autofitX = true;
    private boolean autofitY = true;
    private double minX = 0.0;
    private double maxX = 1.0;
    private double minY = 0.0;
    private double maxY = 1.0;
    private int ticCountX = 2;
    private int ticCountY = 2;
    private int ticSize = 5;
    private int axisLabelFontSizeX = 20;
    private int axisLabelFontSizeY = 20;
    private int ticLabelFontSizeX = 12;
    private int ticLabelFontSizeY = 12;

    public ScatterPlot2D(DataSheet dataSheet, boolean showDecorations) {
        super(dataSheet);
        this.showDecorations = showDecorations;
        this.log("constructor called. Read Base settings.");
        if (dataSheet.getParameterCount() > 1) {
            this.parameterForXAxis = dataSheet.getParameter(0);
            this.parameterForYAxis = dataSheet.getParameter(1);
        } else if (dataSheet.getParameterCount() > 0) {
            this.parameterForXAxis = dataSheet.getParameter(0);
            this.parameterForYAxis = dataSheet.getParameter(0);
        }
        UserPreferences userPreferences = Main.getUserPreferences();
    }

    public Color getDesignColor(Design design) {
        if (design.getCluster() != null) {
            return design.getCluster().getActiveDesignColor();
        }
        return this.activeDesignColor;
    }

    public Color getActiveDesignColor() {
        return this.activeDesignColor;
    }

    public void setActiveDesignColor(Color activeDesignColor) {
        this.activeDesignColor = activeDesignColor;
    }

    public int getDisplayedDesignSelectionMode() {
        return this.displayedDesignSelectionMode;
    }

    public void setDisplayedDesignSelectionMode(int displayedDesignSelectionMode) {
        this.displayedDesignSelectionMode = displayedDesignSelectionMode;
    }

    public ParallelCoordinatesChart getParallelCoordinatesChartForFiltering() {
        return this.parallelCoordinatesChartForFiltering;
    }

    public void setParallelCoordinatesChartForFiltering(ParallelCoordinatesChart parallelCoordinatesChartForFiltering) {
        this.parallelCoordinatesChartForFiltering = parallelCoordinatesChartForFiltering;
    }

    public int getDotRadius() {
        return this.dotRadius;
    }

    public void setDotRadius(int dotRadius) {
        this.dotRadius = dotRadius;
    }

    public Color getSelectedDesignColor() {
        return this.selectedDesignColor;
    }

    public void setSelectedDesignColor(Color selectedDesignColor) {
        this.selectedDesignColor = selectedDesignColor;
    }

    public Parameter getParameterForXAxis() {
        return this.parameterForXAxis;
    }

    public void setParameterForXAxis(Parameter parameterForXAxis) {
        this.parameterForXAxis = parameterForXAxis;
    }

    public Parameter getParameterForYAxis() {
        return this.parameterForYAxis;
    }

    public void setParameterForYAxis(Parameter parameterForYAxis) {
        this.parameterForYAxis = parameterForYAxis;
    }

    public Color getDecorationsColor() {
        return this.decorationsColor;
    }

    public void setDecorationsColor(Color decorationsColor) {
        this.decorationsColor = decorationsColor;
    }

    public boolean isAutofitX() {
        return this.autofitX;
    }

    public void setAutofitX(boolean autofitX) {
        this.autofitX = autofitX;
    }

    public boolean isAutofitY() {
        return this.autofitY;
    }

    public void setAutofitY(boolean autofitY) {
        this.autofitY = autofitY;
    }

    public void autofitX(DataSheet dataSheet) {
        this.minX = Double.POSITIVE_INFINITY;
        this.maxX = Double.NEGATIVE_INFINITY;
        Parameter param = this.getParameterForXAxis();
        int i = 0;
        while (i < dataSheet.getDesignCount()) {
            double x = dataSheet.getDesign(i).getDoubleValue(param);
            if (x > this.maxX) {
                this.maxX = x;
            }
            if (x < this.minX) {
                this.minX = x;
            }
            ++i;
        }
    }

    public void autofitY(DataSheet dataSheet) {
        this.minY = Double.POSITIVE_INFINITY;
        this.maxY = Double.NEGATIVE_INFINITY;
        Parameter param = this.getParameterForYAxis();
        int i = 0;
        while (i < dataSheet.getDesignCount()) {
            double y = dataSheet.getDesign(i).getDoubleValue(param);
            if (y > this.maxY) {
                this.maxY = y;
            }
            if (y < this.minY) {
                this.minY = y;
            }
            ++i;
        }
    }

    public double getMinX() {
        return this.minX;
    }

    public void setMinX(double minX) {
        this.minX = minX;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public void setMaxX(double maxX) {
        this.maxX = maxX;
    }

    public double getMinY() {
        return this.minY;
    }

    public void setMinY(double minY) {
        this.minY = minY;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public void setMaxY(double maxY) {
        this.maxY = maxY;
    }

    public int getTicCountX() {
        return this.ticCountX;
    }

    public void setTicCountX(int ticCountX) {
        this.ticCountX = ticCountX;
    }

    public int getTicCountY() {
        return this.ticCountY;
    }

    public int getTicSize() {
        return this.ticSize;
    }

    public void setTicCountY(int ticCountY) {
        this.ticCountY = ticCountY;
    }

    public int getAxisLabelFontSizeX() {
        return this.axisLabelFontSizeX;
    }

    public void setAxisLabelFontSizeX(int axisLabelFontSizeX) {
        this.axisLabelFontSizeX = axisLabelFontSizeX;
    }

    public int getAxisLabelFontSizeY() {
        return this.axisLabelFontSizeY;
    }

    public void setAxisLabelFontSizeY(int axisLabelFontSizeY) {
        this.axisLabelFontSizeY = axisLabelFontSizeY;
    }

    public int getTicLabelFontSizeX() {
        return this.ticLabelFontSizeX;
    }

    public void setTicLabelFontSizeX(int ticLabelFontSizeX) {
        this.ticLabelFontSizeX = ticLabelFontSizeX;
    }

    public int getTicLabelFontSizeY() {
        return this.ticLabelFontSizeY;
    }

    public void setTicLabelFontSizeY(int ticLabelFontSizeY) {
        this.ticLabelFontSizeY = ticLabelFontSizeY;
    }

    public int getPlotAreaDistanceToLeft(int ticLabelOffset) {
        int distance = this.getMargin();
        if (this.showDecorations) {
            distance = distance + this.axisLabelFontSizeY + 20 + 10 + ticLabelOffset;
        }
        return distance;
    }

    public int getPlotAreaDistanceToRight() {
        int distance = this.getMargin();
        if (this.showDecorations) {
            distance += 20;
        }
        return distance;
    }

    public int getPlotAreaDistanceToTop() {
        int distance = this.getMargin();
        if (this.showDecorations) {
            distance += 20;
        }
        return distance;
    }

    public int getPlotAreaDistanceToBottom() {
        int distance = this.getMargin();
        if (this.showDecorations) {
            distance = distance + this.axisLabelFontSizeX + 20 + this.ticLabelFontSizeX + 10;
        }
        return distance;
    }

    public boolean isShowDecorations() {
        return this.showDecorations;
    }

    @Override
    public void resetDisplaySettingsToDefault() {
        UserPreferences userPreferences = Main.getUserPreferences();
    }

    private void log(String message) {
    }
}

