/*
 * Decompiled with CFR 0.152.
 */
package chart;

import chart.Chart;
import chart.ScatterPlot2D;
import data.DataSheet;
import java.awt.Color;
import java.awt.Dimension;
import xdat.Main;
import xdat.UserPreferences;

public class ScatterChart2D
extends Chart {
    static final long serialVersionUID = 1L;
    static final boolean printLog = false;
    private ScatterPlot2D scatterPlot2D;

    public ScatterChart2D(DataSheet dataSheet, boolean showDecorations, Dimension frameSize, int id) {
        super(dataSheet, id);
        this.scatterPlot2D = new ScatterPlot2D(dataSheet, showDecorations);
        this.setFrameSize(frameSize);
        this.log("constructor called. Read Base settings.");
        this.resetDisplaySettingsToDefault();
    }

    public void setCurrentSettingsAsDefault() {
        UserPreferences userPreferences = Main.getUserPreferences();
        userPreferences.setScatterChart2DDisplayMode(this.scatterPlot2D.getDisplayedDesignSelectionMode());
        userPreferences.setScatterChart2DAutofitX(this.scatterPlot2D.isAutofitX());
        userPreferences.setScatterChart2DAutofitY(this.scatterPlot2D.isAutofitY());
        userPreferences.setScatterChart2DAxisTitleFontsizeX(this.scatterPlot2D.getAxisLabelFontSizeX());
        userPreferences.setScatterChart2DAxisTitleFontsizeY(this.scatterPlot2D.getAxisLabelFontSizeY());
        userPreferences.setScatterChart2DTicCountX(this.scatterPlot2D.getTicCountX());
        userPreferences.setScatterChart2DTicCountY(this.scatterPlot2D.getTicCountY());
        userPreferences.setScatterChart2DTicLabelFontsizeX(this.scatterPlot2D.getTicLabelFontSizeX());
        userPreferences.setScatterChart2DTicLabelFontsizeY(this.scatterPlot2D.getTicLabelFontSizeY());
        userPreferences.setScatterChart2DDataPointSize(this.scatterPlot2D.getDotRadius());
        userPreferences.setScatterChart2DForegroundColor(this.scatterPlot2D.getDecorationsColor());
        userPreferences.setScatterChart2DBackgroundColor(this.scatterPlot2D.getBackGroundColor());
        userPreferences.setScatterChart2DActiveDesignColor(this.scatterPlot2D.getActiveDesignColor());
        userPreferences.setScatterChart2DSelectedDesignColor(this.scatterPlot2D.getSelectedDesignColor());
    }

    @Override
    public int getWidth() {
        return this.getFrameSize().width;
    }

    @Override
    public int getHeight() {
        return this.getFrameSize().height;
    }

    @Override
    public String getTitle() {
        return "2D Scatter Chart " + this.getID();
    }

    private void log(String message) {
    }

    public ScatterPlot2D getScatterPlot2D() {
        return this.scatterPlot2D;
    }

    @Override
    public Color getBackGroundColor() {
        return this.scatterPlot2D.getBackGroundColor();
    }

    @Override
    public void setBackGroundColor(Color backGroundColor) {
        this.scatterPlot2D.setBackGroundColor(backGroundColor);
    }

    @Override
    public void resetDisplaySettingsToDefault() {
        UserPreferences userPreferences = Main.getUserPreferences();
        this.scatterPlot2D.setDisplayedDesignSelectionMode(userPreferences.getScatterChart2DDisplayMode());
        this.scatterPlot2D.setAutofitX(userPreferences.isScatterChart2DAutofitX());
        this.scatterPlot2D.setAutofitY(userPreferences.isScatterChart2DAutofitY());
        this.scatterPlot2D.setAxisLabelFontSizeX(userPreferences.getScatterChart2DAxisTitleFontsizeX());
        this.scatterPlot2D.setAxisLabelFontSizeY(userPreferences.getScatterChart2DAxisTitleFontsizeY());
        this.scatterPlot2D.setTicCountX(userPreferences.getScatterChart2DTicCountX());
        this.scatterPlot2D.setTicCountY(userPreferences.getScatterChart2DTicCountY());
        this.scatterPlot2D.setTicLabelFontSizeX(userPreferences.getScatterChart2DTicLabelFontsizeX());
        this.scatterPlot2D.setTicLabelFontSizeY(userPreferences.getScatterChart2DTicLabelFontsizeY());
        this.scatterPlot2D.setDotRadius(userPreferences.getScatterChart2DDataPointSize());
        this.scatterPlot2D.setDecorationsColor(userPreferences.getScatterChart2DForegroundColor());
        this.scatterPlot2D.setBackGroundColor(userPreferences.getScatterChart2DBackgroundColor());
        this.scatterPlot2D.setActiveDesignColor(userPreferences.getScatterChart2DActiveDesignColor());
        this.scatterPlot2D.setSelectedDesignColor(userPreferences.getScatterChart2DSelectedDesignColor());
    }
}

