/*
 * Decompiled with CFR 0.152.
 */
package chart;

import data.DataSheet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.io.Serializable;

public abstract class Chart
implements Serializable {
    static final long serialVersionUID = 1L;
    static final boolean printLog = false;
    private Point location;
    private int id;
    private Dimension frameSize;
    private DataSheet dataSheet;

    public Chart(DataSheet dataSheet, int id) {
        this.dataSheet = dataSheet;
        this.id = id;
        this.location = new Point(100, 100);
        this.frameSize = new Dimension(800, 600);
        this.log("constructor called. Read Base settings.");
    }

    public abstract String getTitle();

    public int getID() {
        return this.id;
    }

    public abstract int getWidth();

    public abstract int getHeight();

    public DataSheet getDataSheet() {
        return this.dataSheet;
    }

    public void setDataSheet(DataSheet dataSheet) {
        this.dataSheet = dataSheet;
    }

    private void log(String message) {
    }

    public abstract Color getBackGroundColor();

    public abstract void setBackGroundColor(Color var1);

    public Dimension getFrameSize() {
        return this.frameSize;
    }

    public void setFrameSize(Dimension size) {
        this.log("setFrameSize: New height = " + size.height);
        this.log("setFrameSize: New width = " + size.width);
        this.frameSize = size;
    }

    public Point getLocation() {
        return this.location;
    }

    public void setLocation(Point location) {
        this.location = location;
    }

    public abstract void resetDisplaySettingsToDefault();
}

