/*
 * Decompiled with CFR 0.152.
 */
package chart;

import chart.Filter;
import chart.ParallelCoordinatesChart;
import data.DataSheet;
import data.Parameter;
import java.awt.Color;
import java.io.Serializable;
import xdat.Main;
import xdat.UserPreferences;

public class Axis
implements Serializable {
    static final long serialVersionUID = 5L;
    static final boolean printLog = false;
    private ParallelCoordinatesChart chart;
    private boolean autoFit;
    private double max;
    private double min;
    private DataSheet dataSheet;
    private Parameter parameter;
    private int width;
    private int ticCount;
    private Color axisColor;
    private Color axisLabelFontColor;
    private Color ticLabelFontColor;
    private int axisLabelFontSize;
    private int ticLabelFontSize;
    private String ticLabelFormat;
    private int ticLength;
    private boolean active = true;
    private Filter upperFilter;
    private Filter lowerFilter;
    private boolean filterInverted;
    private boolean axisInverted;

    public Axis(DataSheet dataSheet, ParallelCoordinatesChart chart, Parameter parameter) {
        this.log("constructor invoked. Parameter name: " + parameter.getName());
        this.log("constructor invoked. Read Base settings.");
        this.dataSheet = dataSheet;
        this.chart = chart;
        this.parameter = parameter;
        this.log("constructor: Base settings read. Initialise settings...");
        this.initialiseSettings();
        this.log("constructor: settings initialised. Autofit...");
        if (this.autoFit) {
            this.autofit();
        }
        this.log("constructor: Autofit done");
    }

    public void initialiseSettings() {
        UserPreferences userPreferences = Main.getUserPreferences();
        this.width = userPreferences.getParallelCoordinatesAxisWidth();
        this.ticCount = userPreferences.getParallelCoordinatesAxisTicCount();
        this.axisColor = userPreferences.getParallelCoordinatesAxisColor();
        this.axisLabelFontColor = userPreferences.getParallelCoordinatesAxisLabelFontColor();
        this.ticLabelFontColor = userPreferences.getParallelCoordinatesAxisTicLabelFontColor();
        this.axisLabelFontSize = userPreferences.getParallelCoordinatesAxisLabelFontSize();
        this.ticLabelFontSize = userPreferences.getParallelCoordinatesAxisTicLabelFontSize();
        this.ticLabelFormat = userPreferences.getParallelCoordinatesAxisTicLabelFormat();
        this.ticLength = userPreferences.getParallelCoordinatesAxisTicLength();
        this.filterInverted = userPreferences.isFilterInverted();
        this.axisInverted = userPreferences.isParallelCoordinatesAxisInverted();
        this.autoFit = userPreferences.isParallelCoordinatesAutoFitAxis();
        this.min = userPreferences.getParallelCoordinatesAxisDefaultMin();
        this.max = userPreferences.getParallelCoordinatesAxisDefaultMax();
    }

    public void resetSettingsToDefault() {
        this.initialiseSettings();
        this.autofit();
    }

    public void addFilters() {
        this.upperFilter = new Filter(this.dataSheet, this, 0);
        this.lowerFilter = new Filter(this.dataSheet, this, 1);
    }

    public void autofit() {
        this.max = this.dataSheet.getMaxValueOf(this.parameter);
        this.min = this.dataSheet.getMinValueOf(this.parameter);
        this.dataSheet.evaluateBoundsForAllDesigns(this.chart);
        this.log("autofit: max = " + this.max + ", min = " + this.min);
    }

    public Color getAxisLabelFontColor() {
        return this.axisLabelFontColor;
    }

    public void setAxisLabelFontColor(Color axisLabelFontColor) {
        this.axisLabelFontColor = axisLabelFontColor;
    }

    public int getAxisLabelFontSize() {
        return this.axisLabelFontSize;
    }

    public void setAxisLabelFontSize(int axisLabelFontSize) {
        Axis axis;
        double[] upperFilterValues = new double[this.chart.getAxisCount()];
        double[] lowerFilterValues = new double[this.chart.getAxisCount()];
        int i = 0;
        while (i < this.chart.getAxisCount()) {
            axis = this.chart.getAxis(i);
            lowerFilterValues[i] = axis.getLowerFilter().getValue();
            upperFilterValues[i] = axis.getUpperFilter().getValue();
            ++i;
        }
        this.axisLabelFontSize = axisLabelFontSize;
        i = 0;
        while (i < this.chart.getAxisCount()) {
            axis = this.chart.getAxis(i);
            axis.getLowerFilter().setValue(lowerFilterValues[i]);
            axis.getUpperFilter().setValue(upperFilterValues[i]);
            ++i;
        }
    }

    public double getMax() {
        if (!this.parameter.isNumeric()) {
            return this.dataSheet.getMaxValueOf(this.parameter);
        }
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
        this.dataSheet.evaluateBoundsForAllDesigns(this.chart);
    }

    public double getMin() {
        if (!this.parameter.isNumeric()) {
            return this.dataSheet.getMinValueOf(this.parameter);
        }
        return this.min;
    }

    public void setMin(double min) {
        this.min = min;
        this.dataSheet.evaluateBoundsForAllDesigns(this.chart);
    }

    public double getRange() {
        if (this.parameter.isNumeric()) {
            return this.max - this.min;
        }
        return this.parameter.getDiscreteLevelCount() - 1;
    }

    public int getTicCount() {
        if (this.parameter.isNumeric() && this.getRange() > 0.0) {
            return this.ticCount;
        }
        if (this.parameter.isNumeric()) {
            return 1;
        }
        return this.parameter.getDiscreteLevelCount();
    }

    public void setTicCount(int ticCount) {
        this.ticCount = ticCount;
        if (ticCount < 2) {
            this.applyFilters();
        }
    }

    public int getTicLabelFontSize() {
        return this.ticLabelFontSize;
    }

    public void setTicLabelFontSize(int ticLabelFontSize) {
        this.ticLabelFontSize = ticLabelFontSize;
    }

    public String getTicLabelFormat() {
        return this.ticLabelFormat;
    }

    public void setTicLabelFormat(String ticLabelFormat) {
        this.ticLabelFormat = ticLabelFormat;
    }

    public int getTicLength() {
        return this.ticLength;
    }

    public void setTicLength(int ticLength) {
        this.ticLength = ticLength;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public DataSheet getDataSheet() {
        return this.dataSheet;
    }

    public void setDataSheet(DataSheet dataSheet) {
        this.dataSheet = dataSheet;
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public void setParameter(Parameter parameter) {
        this.parameter = parameter;
    }

    public Color getAxisColor() {
        return this.axisColor;
    }

    public void setAxisColor(Color axisColor) {
        this.axisColor = axisColor;
    }

    public Color getAxisTicLabelFontColor() {
        return this.ticLabelFontColor;
    }

    public void setTicLabelFontColor(Color ticLabelFontColor) {
        this.ticLabelFontColor = ticLabelFontColor;
    }

    public String getName() {
        return this.parameter.getName();
    }

    public Filter getLowerFilter() {
        return this.lowerFilter;
    }

    public Filter getUpperFilter() {
        return this.upperFilter;
    }

    public Filter getMinimumFilter() {
        if (this.isAxisInverted()) {
            return this.upperFilter;
        }
        return this.lowerFilter;
    }

    public Filter getMaximumFilter() {
        if (this.isAxisInverted()) {
            return this.lowerFilter;
        }
        return this.upperFilter;
    }

    public ParallelCoordinatesChart getChart() {
        return this.chart;
    }

    private void log(String message) {
    }

    public boolean isFilterInverted() {
        return this.filterInverted;
    }

    public void setFilterInverted(boolean filterInverted) {
        this.filterInverted = filterInverted;
    }

    public boolean isAxisInverted() {
        return this.axisInverted;
    }

    public void setAxisInverted(boolean axisInverted) {
        double maxFilterValue = this.getMaximumFilter().getValue();
        double minFilterValue = this.getMinimumFilter().getValue();
        this.axisInverted = axisInverted;
        this.getMaximumFilter().setValue(maxFilterValue);
        this.getMinimumFilter().setValue(minFilterValue);
    }

    public boolean isAutoFit() {
        if (this.parameter.isNumeric()) {
            return this.autoFit;
        }
        return true;
    }

    public void setAutoFit(boolean autoFit) {
        this.autoFit = autoFit;
    }

    public void setFilterAsNewRange() {
        this.setAutoFit(false);
        double minFilterValue = this.getMinimumFilter().getValue();
        double maxFilterValue = this.getMaximumFilter().getValue();
        this.setMin(minFilterValue);
        this.setMax(maxFilterValue);
        this.resetFilters();
    }

    public void applyFilters() {
        this.upperFilter.apply();
        this.lowerFilter.apply();
    }

    public void resetFilters() {
        this.upperFilter.reset();
        this.lowerFilter.reset();
    }
}

