/*
 * Decompiled with CFR 0.152.
 */
package gui.tables;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class ColorEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    static final long serialVersionUID = 0L;
    static final boolean printLog = false;
    private Color currentColor;
    private JButton button = new JButton();
    protected static final String EDIT = "edit";

    public ColorEditor() {
        this.button.setActionCommand(EDIT);
        this.button.addActionListener(this);
        this.button.setBorderPainted(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (EDIT.equals(e.getActionCommand())) {
            Color newColor = JColorChooser.showDialog(this.button, "Pick a Color", this.currentColor);
            if (newColor != null) {
                this.currentColor = newColor;
            }
            this.button.setBackground(this.currentColor);
            this.fireEditingStopped();
        } else {
            this.log("actionPerformed: currentColor = " + this.currentColor.toString());
        }
    }

    @Override
    public Object getCellEditorValue() {
        this.log("getCellEditorValue: currentColor = " + this.currentColor.toString());
        return this.currentColor;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.currentColor = (Color)value;
        this.log("getTableCellEditorComponent: currentColor = " + this.currentColor.toString());
        return this.button;
    }

    private void log(String message) {
    }
}

