/*
 * Decompiled with CFR 0.152.
 */
package gui.panels;

import chart.Axis;
import chart.Chart;
import chart.Filter;
import data.DataSheet;
import data.Design;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;

public class ChartPanel
extends JPanel
implements MouseMotionListener,
MouseListener {
    static final long serialVersionUID = 3L;
    static final boolean printLog = false;
    private Chart chart;
    private DataSheet dataSheet;
    private int marginTop = 20;
    private int marginBottom = 80;
    private int marginLeft = 80;
    private int marginRight = 20;
    private Filter draggedFilter;
    private int dragStartX;
    private int dragStartY;
    private int dragOffsetY;

    public ChartPanel(DataSheet dataSheet, Chart chart) {
        this.log("constructor called");
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.dataSheet = dataSheet;
        this.chart = chart;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.log("paintComponent: nr of designs is " + this.chart.getDataSheet().getDesignCount());
        this.setBackground(this.chart.getBackGroundColor());
        this.drawPlotFieldBackground(g);
        this.drawDesigns(g);
        this.drawAxes(g);
    }

    public void drawPlotFieldBackground(Graphics g) {
        g.setColor(this.chart.getBackGroundColor());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public void drawDesigns(Graphics g) {
        int axisTopPos = this.chart.getAxisTopPos();
        int designLabelFontSize = this.chart.getDesignLabelFontSize();
        int axisCount = this.chart.getAxisCount();
        double[] axisRanges = new double[axisCount];
        int[] axisHeights = new int[axisCount];
        int[] axisWidths = new int[axisCount];
        double[] axisMaxValues = new double[axisCount];
        double[] axisMinValues = new double[axisCount];
        int[] axisTicLabelFontsizes = new int[axisCount];
        boolean[] axisActiveFlags = new boolean[axisCount];
        boolean[] axisInversionFlags = new boolean[axisCount];
        int i = 0;
        while (i < axisCount) {
            axisRanges[i] = this.chart.getAxis(i).getMax() - this.chart.getAxis(i).getMin();
            axisHeights[i] = this.chart.getAxis(i).getHeight();
            axisWidths[i] = this.chart.getAxis(i).getWidth();
            axisMaxValues[i] = this.chart.getAxis(i).getMax();
            axisMinValues[i] = this.chart.getAxis(i).getMin();
            axisTicLabelFontsizes[i] = this.chart.getAxis(i).getTicLabelFontSize();
            axisActiveFlags[i] = this.chart.getAxis(i).isActive();
            axisInversionFlags[i] = this.chart.getAxis(i).isAxisInverted();
            ++i;
        }
        int designID = 0;
        while (designID < this.dataSheet.getDesignCount()) {
            Design currentDesign = this.dataSheet.getDesign(designID);
            if (currentDesign.isInsideBounds(this.chart)) {
                boolean firstAxisDrawn = false;
                boolean currentDesignClusterActive = true;
                if (currentDesign.getCluster() != null) {
                    currentDesignClusterActive = currentDesign.getCluster().isActive();
                }
                boolean currentDesignActive = true;
                currentDesignActive = currentDesign.isActive(this.chart);
                this.log("drawDesigns: currentDesign.isActive(this.chart) = " + currentDesign.isActive(this.chart));
                if ((currentDesignActive || this.chart.isShowFilteredDesigns()) && currentDesignClusterActive) {
                    int lineThickness = this.chart.getDesignLineThickness(currentDesign);
                    g.setColor(this.chart.getDesignColor(currentDesign, currentDesignActive));
                    int xPositionCurrent = this.marginLeft;
                    int yPositionCurrent = axisTopPos;
                    int xPositionLast = xPositionCurrent;
                    int i2 = 0;
                    while (i2 < axisCount) {
                        int yPosition = axisTopPos;
                        if (axisActiveFlags[i2]) {
                            int yPositionRelToBottom;
                            double value = currentDesign.getDoubleValue(this.dataSheet.getParameter(i2));
                            if (axisRanges[i2] == 0.0) {
                                yPositionRelToBottom = (int)((double)axisHeights[i2] * 0.5);
                            } else {
                                double ratio = axisInversionFlags[i2] ? (axisMaxValues[i2] - value) / axisRanges[i2] : (value - axisMinValues[i2]) / axisRanges[i2];
                                yPositionRelToBottom = (int)((double)axisHeights[i2] * ratio);
                            }
                            int yPositionLast = yPositionCurrent;
                            yPositionCurrent = yPosition + axisHeights[i2] - yPositionRelToBottom;
                            if (firstAxisDrawn) {
                                xPositionCurrent += (int)((double)axisWidths[i2] * 0.5);
                                if (lineThickness == 0) {
                                    g.drawLine(xPositionLast - 3, yPositionLast, xPositionLast + 3, yPositionLast);
                                    g.drawLine(xPositionCurrent - 3, yPositionCurrent, xPositionCurrent + 3, yPositionCurrent);
                                } else {
                                    int t = 1;
                                    while (t <= lineThickness) {
                                        int deltaY = -(t / 2) * (2 * (t % 2) - 1);
                                        g.drawLine(xPositionLast, yPositionLast + deltaY, xPositionCurrent, yPositionCurrent + deltaY);
                                        ++t;
                                    }
                                }
                            } else {
                                firstAxisDrawn = true;
                                if (this.chart.isShowDesignIDs()) {
                                    FontMetrics fm = g.getFontMetrics();
                                    g.setFont(new Font("SansSerif", 0, designLabelFontSize));
                                    g.drawString(Integer.toString(currentDesign.getId()), xPositionCurrent - 5 - fm.stringWidth(Integer.toString(currentDesign.getId())), yPositionCurrent + (int)(0.5 * (double)this.chart.getAxis(i2).getTicLabelFontSize()));
                                }
                            }
                            xPositionLast = xPositionCurrent;
                            xPositionCurrent += (int)((double)axisWidths[i2] * 0.5);
                        }
                        ++i2;
                    }
                }
            }
            ++designID;
        }
    }

    public void drawAxes(Graphics g) {
        int xPosition = this.marginLeft;
        int yPosition = this.chart.getAxisTopPos();
        FontMetrics fm = g.getFontMetrics();
        Axis lastAxis = null;
        int drawnAxisCount = 0;
        int i = 0;
        while (i < this.chart.getAxisCount()) {
            if (this.chart.getAxis(i).isActive()) {
                Axis currentAxis = this.chart.getAxis(i);
                if (lastAxis != null) {
                    xPosition = xPosition + (int)((double)lastAxis.getWidth() * 0.5) + (int)((double)currentAxis.getWidth() * 0.5);
                }
                String axisLabel = currentAxis.getName();
                int slenX = fm.stringWidth(axisLabel);
                g.setFont(new Font("SansSerif", 0, currentAxis.getAxisLabelFontSize()));
                int yLabelOffset = 0;
                if (this.chart.isVerticallyOffsetAxisLabels()) {
                    yLabelOffset = drawnAxisCount++ % 2 * (this.chart.getMaxAxisLabelFontSize() + this.chart.getAxisLabelVerticalDistance());
                }
                g.setColor(currentAxis.getAxisLabelFontColor());
                g.drawString(axisLabel, xPosition - (int)(0.5 * (double)slenX), this.chart.getMaxAxisLabelFontSize() + this.chart.getTopMargin() + yLabelOffset);
                g.setColor(currentAxis.getAxisColor());
                g.drawLine(xPosition, yPosition, xPosition, yPosition + currentAxis.getHeight());
                Filter uf = currentAxis.getUpperFilter();
                Filter lf = currentAxis.getLowerFilter();
                uf.setXPos(xPosition);
                lf.setXPos(xPosition);
                g.setColor(this.chart.getFilterColor());
                g.drawLine(uf.getXPos(), uf.getYPos(), uf.getXPos() - this.chart.getFilterWidth(), uf.getYPos() - this.chart.getFilterHeight());
                g.drawLine(uf.getXPos(), uf.getYPos(), uf.getXPos() + this.chart.getFilterWidth(), uf.getYPos() - this.chart.getFilterHeight());
                g.drawLine(uf.getXPos() - this.chart.getFilterWidth(), uf.getYPos() - this.chart.getFilterHeight(), uf.getXPos() + this.chart.getFilterWidth(), uf.getYPos() - this.chart.getFilterHeight());
                g.drawLine(lf.getXPos(), lf.getYPos(), lf.getXPos() - this.chart.getFilterWidth(), lf.getYPos() + this.chart.getFilterHeight());
                g.drawLine(lf.getXPos(), lf.getYPos(), lf.getXPos() + this.chart.getFilterWidth(), lf.getYPos() + this.chart.getFilterHeight());
                g.drawLine(lf.getXPos() - this.chart.getFilterWidth(), lf.getYPos() + this.chart.getFilterHeight(), lf.getXPos() + this.chart.getFilterWidth(), lf.getYPos() + this.chart.getFilterHeight());
                g.setFont(new Font("SansSerif", 0, currentAxis.getTicLabelFontSize()));
                if ((uf == this.draggedFilter || lf == this.draggedFilter) && currentAxis.getParameter().isNumeric()) {
                    g.drawString(String.format(currentAxis.getTicLabelFormat(), this.draggedFilter.getValue()), this.draggedFilter.getXPos() + this.chart.getFilterWidth() + 4, this.draggedFilter.getYPos() - this.chart.getFilterHeight());
                }
                if (lastAxis != null) {
                    g.drawLine(lastAxis.getUpperFilter().getXPos(), lastAxis.getUpperFilter().getYPos(), uf.getXPos(), uf.getYPos());
                    g.drawLine(lastAxis.getLowerFilter().getXPos(), lastAxis.getLowerFilter().getYPos(), lf.getXPos(), lf.getYPos());
                }
                int ticSize = currentAxis.getTicLength();
                int ticCount = currentAxis.getTicCount();
                double ticSpacing = ticCount > 1 ? (double)currentAxis.getHeight() / (double)(ticCount - 1) : 0.0;
                double axisRange = currentAxis.getRange();
                double ticValueDifference = axisRange / (double)(ticCount - 1);
                int ticID = 0;
                while (ticID < ticCount) {
                    String ticLabel;
                    int currentTicYPos = currentAxis.isAxisInverted() ? yPosition + currentAxis.getHeight() - (int)((double)ticID * ticSpacing) : yPosition + (int)((double)ticID * ticSpacing);
                    g.setColor(currentAxis.getAxisColor());
                    if (ticCount > 1) {
                        g.drawLine(xPosition, currentTicYPos, xPosition + ticSize, currentTicYPos);
                    } else {
                        g.drawLine(xPosition, yPosition + currentAxis.getHeight() / 2, xPosition + ticSize, yPosition + currentAxis.getHeight() / 2);
                    }
                    g.setColor(currentAxis.getAxisTicLabelFontColor());
                    g.setFont(new Font("SansSerif", 0, currentAxis.getTicLabelFontSize()));
                    if (currentAxis.getParameter().isNumeric()) {
                        Double ticValue;
                        if (ticCount > 1) {
                            ticValue = currentAxis.getMax() - ticValueDifference * (double)ticID;
                            ticLabel = String.format(currentAxis.getTicLabelFormat(), ticValue);
                            g.drawString(ticLabel, xPosition + ticSize + 7, currentTicYPos + (int)(0.5 * (double)currentAxis.getTicLabelFontSize()));
                        } else {
                            ticValue = currentAxis.getMax();
                            ticLabel = String.format(currentAxis.getTicLabelFormat(), ticValue);
                            g.drawString(ticLabel, xPosition + 2 * ticSize, yPosition + currentAxis.getHeight() / 2 + (int)(0.5 * (double)currentAxis.getTicLabelFontSize()));
                        }
                    } else if (ticCount > 1) {
                        ticLabel = currentAxis.getParameter().getStringValueOf(currentAxis.getMax() - ticValueDifference * (double)ticID);
                        g.drawString(ticLabel, xPosition + 2 * ticSize, currentTicYPos + (int)(0.5 * (double)currentAxis.getTicLabelFontSize()));
                    } else {
                        ticLabel = currentAxis.getParameter().getStringValueOf(currentAxis.getMax());
                        g.drawString(ticLabel, xPosition + 2 * ticSize, yPosition + currentAxis.getHeight() / 2 + (int)(0.5 * (double)currentAxis.getTicLabelFontSize()));
                    }
                    ++ticID;
                }
                lastAxis = currentAxis;
            }
            ++i;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.dragStartX = e.getX();
        this.dragStartY = e.getY();
        int i = 0;
        while (i < this.chart.getAxisCount()) {
            Filter uf = this.chart.getAxis(i).getUpperFilter();
            Filter lf = this.chart.getAxis(i).getLowerFilter();
            if (this.chart.getAxis(i).isActive() && this.dragStartY >= uf.getYPos() - this.chart.getFilterHeight() && this.dragStartY <= uf.getYPos() && this.dragStartX >= uf.getXPos() - this.chart.getFilterWidth() && this.dragStartX <= uf.getXPos() + this.chart.getFilterWidth()) {
                this.draggedFilter = uf;
                this.dragOffsetY = uf.getYPos() - this.dragStartY;
            } else if (this.chart.getAxis(i).isActive() && this.dragStartY >= lf.getYPos() && this.dragStartY <= lf.getYPos() + this.chart.getFilterHeight() && this.dragStartX >= lf.getXPos() - this.chart.getFilterWidth() && this.dragStartX <= lf.getXPos() + this.chart.getFilterWidth()) {
                this.draggedFilter = lf;
                this.dragOffsetY = lf.getYPos() - this.dragStartY;
            }
            ++i;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.draggedFilter = null;
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.draggedFilter != null) {
            this.draggedFilter.setYPos(Math.max(Math.min(e.getY() + this.dragOffsetY, this.draggedFilter.getLowestPos()), this.draggedFilter.getHighestPos()));
            this.log("ChartPanel: Dragging filter on axis " + this.draggedFilter.getAxis().getName());
            this.log("ChartPanel: Related parameter name is " + this.draggedFilter.getAxis().getParameter().getName());
            this.repaint();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int width = this.marginLeft + this.marginRight + this.chart.getWidth();
        int height = this.marginTop + this.marginBottom + this.chart.getHeight();
        Dimension preferredSize = new Dimension(width, height);
        return preferredSize;
    }

    private void log(String message) {
    }
}

