/*
 * Decompiled with CFR 0.152.
 */
package gui.panels;

import actionListeners.ChartDisplaySettingsActionListener;
import actionListeners.ChartSpecificDisplaySettingsDialogActionListener;
import actionListeners.DefaultDisplaySettingsDialogActionListener;
import chart.Chart;
import gui.buttons.ColorChoiceButton;
import gui.buttons.MinMaxSpinnerModel;
import gui.dialogs.DisplaySettingsDialog;
import gui.frames.ChartFrame;
import gui.panels.TitledSubPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import xdat.Main;

public class ChartDisplaySettingsPanel
extends JPanel {
    static final long serialVersionUID = 0L;
    static final boolean printLog = false;
    private Main mainWindow;
    private DisplaySettingsDialog dialog;
    private ChartFrame chartFrame;
    private ChartDisplaySettingsActionListener cmd;
    private JSpinner axisHeightSpinner = new JSpinner(new MinMaxSpinnerModel(0, 3000));
    private JCheckBox axisLabelVerticalOffsetCheckbox = new JCheckBox();
    private ColorChoiceButton backGroundColorButton;
    private ColorChoiceButton activeDesignColorButton;
    private ColorChoiceButton filteredDesignColorButton;
    private ColorChoiceButton filterColorButton;
    private JRadioButton showfilteredDesignsTrueButton = new JRadioButton("Yes");
    private JRadioButton showfilteredDesignsFalseButton = new JRadioButton("No");
    private JRadioButton showDesignIDsTrueButton = new JRadioButton("Yes");
    private JRadioButton showDesignIDsFalseButton = new JRadioButton("No");
    private ButtonGroup showfilteredDesignsButtonGroup = new ButtonGroup();
    private ButtonGroup showDesignIDsButtonGroup = new ButtonGroup();
    private JSpinner designLineThicknessSpinner = new JSpinner(new MinMaxSpinnerModel(0, 10));
    private JSpinner designLabelFontSizeSpinner = new JSpinner(new MinMaxSpinnerModel(0, 100));
    private JSpinner filterWidthSpinner = new JSpinner(new MinMaxSpinnerModel(1, 30));
    private JSpinner filterHeightSpinner = new JSpinner(new MinMaxSpinnerModel(1, 60));
    private JButton cancelButton = new JButton("Cancel");
    private JButton okButton = new JButton("Ok");

    public ChartDisplaySettingsPanel(Main mainWindow, DisplaySettingsDialog dialog) {
        this.mainWindow = mainWindow;
        this.dialog = dialog;
        this.buildPanel();
        this.axisHeightSpinner.setValue(Main.getUserPreferences().getAxisHeight());
        this.axisLabelVerticalOffsetCheckbox.setSelected(Main.getUserPreferences().isVerticallyOffsetAxisLabels());
        this.setShowFilteredDesignsSelection(Main.getUserPreferences().isShowFilteredDesigns());
        this.setShowDesignIDsSelection(Main.getUserPreferences().isShowDesignIDs());
        this.designLabelFontSizeSpinner.setValue(Main.getUserPreferences().getDesignLabelFontSize());
        this.designLineThicknessSpinner.setValue(Main.getUserPreferences().getLineThickness());
        this.backGroundColorButton.setCurrentColor(Main.getUserPreferences().getDefaultBackgroundColor());
        this.activeDesignColorButton.setCurrentColor(Main.getUserPreferences().getActiveDesignDefaultColor());
        this.filteredDesignColorButton.setCurrentColor(Main.getUserPreferences().getFilteredDesignDefaultColor());
        this.filterColorButton.setCurrentColor(Main.getUserPreferences().getFilterDefaultColor());
        this.filterWidthSpinner.setValue(Main.getUserPreferences().getFilterWidth());
        this.filterHeightSpinner.setValue(Main.getUserPreferences().getFilterHeight());
    }

    public ChartDisplaySettingsPanel(Main mainWindow, DisplaySettingsDialog dialog, ChartFrame chartFrame) {
        this.mainWindow = mainWindow;
        this.dialog = dialog;
        this.chartFrame = chartFrame;
        this.buildPanel();
        this.axisHeightSpinner.setValue(chartFrame.getChart().getAxisMaxHeight());
        this.axisLabelVerticalOffsetCheckbox.setSelected(chartFrame.getChart().isVerticallyOffsetAxisLabels());
        this.setShowFilteredDesignsSelection(chartFrame.getChart().isShowFilteredDesigns());
        this.setShowDesignIDsSelection(chartFrame.getChart().isShowDesignIDs());
        this.designLabelFontSizeSpinner.setValue(chartFrame.getChart().getDesignLabelFontSize());
        this.designLineThicknessSpinner.setValue(chartFrame.getChart().getLineThickness());
        this.backGroundColorButton.setCurrentColor(chartFrame.getChart().getBackGroundColor());
        this.activeDesignColorButton.setCurrentColor(chartFrame.getChart().getDefaultDesignColor(true));
        this.filteredDesignColorButton.setCurrentColor(chartFrame.getChart().getDefaultDesignColor(false));
        this.filterColorButton.setCurrentColor(chartFrame.getChart().getFilterColor());
        this.filterWidthSpinner.setValue(chartFrame.getChart().getFilterWidth());
        this.filterHeightSpinner.setValue(chartFrame.getChart().getFilterHeight());
    }

    private void buildPanel() {
        this.backGroundColorButton = new ColorChoiceButton(Main.getUserPreferences().getDefaultBackgroundColor(), "Background Color");
        this.activeDesignColorButton = new ColorChoiceButton(Main.getUserPreferences().getActiveDesignDefaultColor(), "Active Design Color");
        this.filteredDesignColorButton = new ColorChoiceButton(Main.getUserPreferences().getFilteredDesignDefaultColor(), "Filtered Design Color");
        this.filterColorButton = new ColorChoiceButton(Main.getUserPreferences().getFilterDefaultColor(), "Filter Color");
        TitledSubPanel contentPanel = new TitledSubPanel("");
        JPanel contentInnerPanel = new JPanel(new BorderLayout());
        JPanel labelPanel = new JPanel(new GridLayout(12, 1));
        JPanel controlsPanel = new JPanel(new GridLayout(12, 1));
        TitledSubPanel buttonsPanel = new TitledSubPanel("");
        JPanel showfilteredDesignsRadioButtonsPanel = new JPanel(new GridLayout(1, 2));
        JPanel showDesignIDsRadioButtonsPanel = new JPanel(new GridLayout(1, 2));
        JLabel axisHeightLabel = new JLabel("Axis Height");
        JLabel axisLabelVerticalOffsetLabel = new JLabel("Offset Axis Labels");
        JLabel backGroundColorLabel = new JLabel("Background Color");
        JLabel activeDesignColorLabel = new JLabel("Active Design Color");
        JLabel filteredDesignColorLabel = new JLabel("Filtered Design Color");
        JLabel filterColorLabel = new JLabel("Filter Color");
        JLabel showfilteredDesignsLabel = new JLabel("Show filtered Designs");
        JLabel showDesignIDsLabel = new JLabel("Show Design IDs");
        this.showfilteredDesignsButtonGroup.add(this.showfilteredDesignsTrueButton);
        this.showfilteredDesignsButtonGroup.add(this.showfilteredDesignsFalseButton);
        this.showDesignIDsButtonGroup.add(this.showDesignIDsTrueButton);
        this.showDesignIDsButtonGroup.add(this.showDesignIDsFalseButton);
        JLabel designLabelFontSizeLabel = new JLabel("Design Label Font Size ");
        JLabel designLineThicknessLabel = new JLabel("Design Line Thickness ");
        JLabel filterWidthLabel = new JLabel("Filter Symbol Width");
        JLabel filterHeightLabel = new JLabel("Filter Symbol Height");
        JPanel cancelButtonPanel = new JPanel();
        JPanel okButtonPanel = new JPanel();
        this.setLayout(new BorderLayout());
        contentPanel.setLayout(new BorderLayout());
        cancelButtonPanel.setLayout(new FlowLayout(2));
        okButtonPanel.setLayout(new FlowLayout(0));
        buttonsPanel.setLayout(new GridLayout(1, 2));
        this.add((Component)contentPanel, "Center");
        contentPanel.add((Component)contentInnerPanel, "North");
        contentInnerPanel.add((Component)labelPanel, "Center");
        contentInnerPanel.add((Component)controlsPanel, "East");
        this.add((Component)buttonsPanel, "South");
        labelPanel.add(axisHeightLabel);
        controlsPanel.add(this.axisHeightSpinner);
        labelPanel.add(axisLabelVerticalOffsetLabel);
        JPanel axisLabelVerticalOffsetCheckboxPanel = new JPanel(new FlowLayout(0));
        axisLabelVerticalOffsetCheckboxPanel.add(this.axisLabelVerticalOffsetCheckbox);
        controlsPanel.add(axisLabelVerticalOffsetCheckboxPanel);
        labelPanel.add(backGroundColorLabel);
        JPanel backGroundColorButtonPanel = new JPanel(new FlowLayout(0));
        backGroundColorButtonPanel.add(this.backGroundColorButton);
        controlsPanel.add(backGroundColorButtonPanel);
        labelPanel.add(activeDesignColorLabel);
        JPanel activeDesignColorButtonPanel = new JPanel(new FlowLayout(0));
        controlsPanel.add(activeDesignColorButtonPanel);
        activeDesignColorButtonPanel.add(this.activeDesignColorButton);
        labelPanel.add(filteredDesignColorLabel);
        JPanel filteredDesignColorButtonPanel = new JPanel(new FlowLayout(0));
        filteredDesignColorButtonPanel.add(this.filteredDesignColorButton);
        controlsPanel.add(filteredDesignColorButtonPanel);
        labelPanel.add(filterColorLabel);
        JPanel filterColorButtonPanel = new JPanel(new FlowLayout(0));
        filterColorButtonPanel.add(this.filterColorButton);
        controlsPanel.add(filterColorButtonPanel);
        labelPanel.add(showfilteredDesignsLabel);
        controlsPanel.add(showfilteredDesignsRadioButtonsPanel);
        showfilteredDesignsRadioButtonsPanel.add(this.showfilteredDesignsTrueButton);
        showfilteredDesignsRadioButtonsPanel.add(this.showfilteredDesignsFalseButton);
        labelPanel.add(showDesignIDsLabel);
        controlsPanel.add(showDesignIDsRadioButtonsPanel);
        labelPanel.add(designLabelFontSizeLabel);
        controlsPanel.add(this.designLabelFontSizeSpinner);
        labelPanel.add(designLineThicknessLabel);
        controlsPanel.add(this.designLineThicknessSpinner);
        showDesignIDsRadioButtonsPanel.add(this.showDesignIDsTrueButton);
        showDesignIDsRadioButtonsPanel.add(this.showDesignIDsFalseButton);
        this.showfilteredDesignsTrueButton.setActionCommand("showfilteredDesignsTrue");
        this.showfilteredDesignsFalseButton.setActionCommand("showfilteredDesignsFalse");
        this.showDesignIDsTrueButton.setActionCommand("showDesignIDsTrue");
        this.showDesignIDsFalseButton.setActionCommand("showDesignIDsFalse");
        labelPanel.add(filterWidthLabel);
        controlsPanel.add(this.filterWidthSpinner);
        labelPanel.add(filterHeightLabel);
        controlsPanel.add(this.filterHeightSpinner);
        buttonsPanel.add(cancelButtonPanel);
        buttonsPanel.add(okButtonPanel);
        cancelButtonPanel.add(this.cancelButton);
        okButtonPanel.add(this.okButton);
    }

    public void setActionListener(ChartDisplaySettingsActionListener cmd) {
        this.cmd = cmd;
        this.backGroundColorButton.addActionListener(cmd);
        this.activeDesignColorButton.addActionListener(cmd);
        this.filteredDesignColorButton.addActionListener(cmd);
        this.filterColorButton.addActionListener(cmd);
        this.showfilteredDesignsTrueButton.addActionListener(cmd);
        this.showfilteredDesignsFalseButton.addActionListener(cmd);
        this.showDesignIDsTrueButton.addActionListener(cmd);
        this.showDesignIDsFalseButton.addActionListener(cmd);
    }

    public void setOkCancelButtonTargetDefaultSettings() {
        DefaultDisplaySettingsDialogActionListener cmd = new DefaultDisplaySettingsDialogActionListener(this.dialog);
        this.log("setOkCancelButtonTargetDefaultSettings called");
        this.cancelButton.addActionListener(cmd);
        this.okButton.addActionListener(cmd);
    }

    public void setOkCancelButtonTargetChart(Chart chart) {
        this.log("setOkCancelButtonTargetChart called");
        this.cancelButton.addActionListener(new ChartSpecificDisplaySettingsDialogActionListener(this.mainWindow, this.dialog, chart, this.chartFrame));
        this.okButton.addActionListener(new ChartSpecificDisplaySettingsDialogActionListener(this.mainWindow, this.dialog, chart, this.chartFrame));
    }

    public ChartDisplaySettingsActionListener getChartDisplaySettingsActionListener() {
        return this.cmd;
    }

    public boolean getShowFilteredDesignsSelection() {
        return this.showfilteredDesignsTrueButton.getModel().equals(this.showfilteredDesignsButtonGroup.getSelection());
    }

    public void setShowFilteredDesignsSelection(boolean showFilteredDesignsSelection) {
        if (showFilteredDesignsSelection) {
            this.showfilteredDesignsButtonGroup.setSelected(this.showfilteredDesignsTrueButton.getModel(), true);
        } else {
            this.showfilteredDesignsButtonGroup.setSelected(this.showfilteredDesignsFalseButton.getModel(), true);
        }
    }

    public boolean getShowDesignIDsSelection() {
        return this.showfilteredDesignsTrueButton.getModel().equals(this.showfilteredDesignsButtonGroup.getSelection());
    }

    public void setShowDesignIDsSelection(boolean showFilteredDesignsSelection) {
        this.log("setShowDesignIDsSelection: argument is " + showFilteredDesignsSelection);
        if (showFilteredDesignsSelection) {
            this.showDesignIDsButtonGroup.setSelected(this.showDesignIDsTrueButton.getModel(), true);
        } else {
            this.showDesignIDsButtonGroup.setSelected(this.showDesignIDsFalseButton.getModel(), true);
        }
    }

    public JSpinner getDesignLabelFontSizeSpinner() {
        return this.designLabelFontSizeSpinner;
    }

    public JSpinner getDesignLineThicknessSpinner() {
        return this.designLineThicknessSpinner;
    }

    public JCheckBox getAxisLabelVerticalOffsetCheckbox() {
        return this.axisLabelVerticalOffsetCheckbox;
    }

    public JSpinner getAxisHeightSpinner() {
        return this.axisHeightSpinner;
    }

    public ColorChoiceButton getActiveDesignColorButton() {
        return this.activeDesignColorButton;
    }

    public ColorChoiceButton getBackGroundColorButton() {
        return this.backGroundColorButton;
    }

    public ColorChoiceButton getFilterColorButton() {
        return this.filterColorButton;
    }

    public ColorChoiceButton getFilteredDesignColorButton() {
        return this.filteredDesignColorButton;
    }

    public JSpinner getFilterHeightSpinner() {
        return this.filterHeightSpinner;
    }

    public JSpinner getFilterWidthSpinner() {
        return this.filterWidthSpinner;
    }

    private void log(String message) {
    }
}

