/*
 * Decompiled with CFR 0.152.
 */
package data;

import java.awt.Color;
import java.io.Serializable;
import xdat.Main;

public class Cluster
implements Serializable {
    static final long serialVersionUID = 1L;
    static final boolean printLog = false;
    private String name;
    private Color activeDesignColor;
    private boolean active = true;
    private int lineThickness = 1;
    private int uniqueIdentificationNumber;

    public Cluster(String name, int uniqueIdentificationNumber) {
        this.log("constructor called.");
        this.name = name;
        this.uniqueIdentificationNumber = uniqueIdentificationNumber;
        this.activeDesignColor = Main.getUserPreferences().getActiveDesignDefaultColor();
    }

    private void log(String message) {
    }

    public Color getActiveDesignColor() {
        return this.activeDesignColor;
    }

    public void setActiveDesignColor(Color activeDesignColor) {
        this.activeDesignColor = activeDesignColor;
    }

    public int getLineThickness() {
        return this.lineThickness;
    }

    public void setLineThickness(int lineThickness) {
        this.lineThickness = lineThickness;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public Cluster duplicate() {
        Cluster duplication = new Cluster(this.name, this.uniqueIdentificationNumber);
        duplication.setActive(this.active);
        duplication.setActiveDesignColor(this.activeDesignColor);
        duplication.setLineThickness(this.lineThickness);
        return duplication;
    }

    public void copySettingsTo(Cluster cluster) {
        cluster.setName(this.name);
        cluster.setActive(this.active);
        cluster.setActiveDesignColor(this.activeDesignColor);
        cluster.setLineThickness(this.lineThickness);
    }

    public int getUniqueIdentificationNumber() {
        return this.uniqueIdentificationNumber;
    }
}

