/*
 * Decompiled with CFR 0.152.
 */
package chart;

import chart.Axis;
import data.DataSheet;
import data.Design;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.ProgressMonitor;
import xdat.Main;
import xdat.UserPreferences;

public class Chart
implements Serializable {
    static final long serialVersionUID = 3L;
    static final boolean printLog = false;
    private Point location;
    private Dimension size;
    private DataSheet dataSheet;
    private int topMargin = 10;
    private boolean verticallyOffsetAxisLabels = true;
    private int axisLabelVerticalDistance = 10;
    private Vector<Axis> axes = new Vector(0, 1);
    private Color backGroundColor;
    private int designLabelFontSize;
    private int lineThickness = 1;
    private Color activeDesignColor;
    private Color filteredDesignColor;
    private Color filterColor;
    private boolean showDesignIDs;
    private boolean showFilteredDesigns;
    private int filterHeight;
    private int filterWidth;

    public Chart(DataSheet dataSheet, ProgressMonitor progressMonitor) {
        this.location = new Point(100, 100);
        this.size = new Dimension(800, 600);
        this.log("constructor called. Read Base settings.");
        this.dataSheet = dataSheet;
        UserPreferences userPreferences = Main.getUserPreferences();
        this.backGroundColor = userPreferences.getDefaultBackgroundColor();
        this.showDesignIDs = userPreferences.isShowDesignIDs();
        this.showFilteredDesigns = userPreferences.isShowFilteredDesigns();
        this.verticallyOffsetAxisLabels = userPreferences.isVerticallyOffsetAxisLabels();
        this.activeDesignColor = userPreferences.getActiveDesignDefaultColor();
        this.filteredDesignColor = userPreferences.getFilteredDesignDefaultColor();
        this.designLabelFontSize = userPreferences.getDesignLabelFontSize();
        this.lineThickness = userPreferences.getLineThickness();
        this.filterColor = userPreferences.getFilterDefaultColor();
        this.filterHeight = userPreferences.getFilterHeight();
        this.filterWidth = userPreferences.getFilterWidth();
        this.log("constructor: Base settings read. Creating axes...");
        progressMonitor.setMaximum(dataSheet.getParameterCount() - 1);
        progressMonitor.setNote("Building Chart...");
        int i = 0;
        while (i < dataSheet.getParameterCount() && !progressMonitor.isCanceled()) {
            Axis newAxis = new Axis(dataSheet, this, dataSheet.getParameter(i));
            this.addAxis(newAxis);
            progressMonitor.setProgress(i);
            ++i;
        }
        if (!progressMonitor.isCanceled()) {
            progressMonitor.setNote("Building Filters...");
            progressMonitor.setProgress(0);
            i = 0;
            while (i < dataSheet.getParameterCount() && !progressMonitor.isCanceled()) {
                this.axes.get(i).addFilters();
                progressMonitor.setProgress(i);
                ++i;
            }
        }
        this.applyAllFilters();
    }

    public int getWidth() {
        int width = 0;
        if (this.getAxis(0).isActive()) {
            width += (int)(0.5 * (double)this.getAxis(0).getWidth());
        }
        int i = 1;
        while (i < this.getAxisCount()) {
            if (this.getAxis(i).isActive()) {
                width += this.getAxis(i).getWidth();
            }
            ++i;
        }
        return width;
    }

    public int getHeight() {
        int height = this.getAxisTopPos() + this.getAxisMaxHeight();
        return height;
    }

    public int getAxisMaxHeight() {
        int height = 0;
        int i = 0;
        while (i < this.getAxisCount()) {
            if (this.getAxis(i).isActive() && height < this.getAxis(i).getHeight()) {
                height = this.getAxis(i).getHeight();
            }
            ++i;
        }
        return height;
    }

    public void setAxisHeight(int height) {
        int i = 0;
        while (i < this.axes.size()) {
            this.axes.get(i).setHeight(height);
            ++i;
        }
    }

    public int getAxisMaxWidth() {
        int width = 0;
        int i = 0;
        while (i < this.getAxisCount()) {
            if (this.getAxis(i).isActive() && width < this.getAxis(i).getWidth()) {
                width = this.getAxis(i).getWidth();
            }
            ++i;
        }
        return width;
    }

    public void setAxisWidth(int width) {
        int i = 0;
        while (i < this.axes.size()) {
            this.axes.get(i).setWidth(width);
            ++i;
        }
    }

    public void setAxisColor(Color color) {
        int i = 0;
        while (i < this.axes.size()) {
            this.axes.get(i).setAxisColor(color);
            ++i;
        }
    }

    public int getAxisTopPos() {
        int topPos = this.verticallyOffsetAxisLabels ? 2 * this.getMaxAxisLabelFontSize() + this.axisLabelVerticalDistance + this.getTopMargin() * 2 + this.getFilterHeight() : this.getMaxAxisLabelFontSize() + this.getTopMargin() * 2 + this.getFilterHeight();
        this.log("getAxisTopPos: returning " + topPos);
        return topPos;
    }

    public Axis getAxis(int index) {
        return this.axes.get(index);
    }

    public Axis getAxis(String parameterName) {
        int i = 0;
        while (i < this.axes.size()) {
            if (parameterName.equals(this.axes.get(i).getParameter().getName())) {
                return this.axes.get(i);
            }
            ++i;
        }
        throw new IllegalArgumentException("Axis " + parameterName + " not found");
    }

    public int getMaxAxisLabelFontSize() {
        int maxAxisLabelFontSize = 0;
        int i = 0;
        while (i < this.axes.size()) {
            if (maxAxisLabelFontSize < this.axes.get(i).getAxisLabelFontSize()) {
                maxAxisLabelFontSize = this.axes.get(i).getAxisLabelFontSize();
            }
            ++i;
        }
        return maxAxisLabelFontSize;
    }

    public int getActiveAxisCount() {
        int axesCount = 0;
        int i = 0;
        while (i < this.axes.size()) {
            if (this.axes.get(i).isActive()) {
                ++axesCount;
            }
            ++i;
        }
        return axesCount;
    }

    public int getAxisCount() {
        return this.axes.size();
    }

    public int getAxisLabelVerticalDistance() {
        return this.axisLabelVerticalDistance;
    }

    public void setAxisLabelVerticalDistance(int axisLabelVerticalDistance) {
        this.axisLabelVerticalDistance = axisLabelVerticalDistance;
    }

    public boolean isVerticallyOffsetAxisLabels() {
        return this.verticallyOffsetAxisLabels;
    }

    public void setVerticallyOffsetAxisLabels(boolean verticallyOffsetAxisLabels) {
        this.verticallyOffsetAxisLabels = verticallyOffsetAxisLabels;
    }

    public void addAxis(Axis axis) {
        this.axes.add(axis);
    }

    public void addAxis(int index, Axis axis) {
        this.axes.add(index, axis);
    }

    public void removeAxis(int index) {
        this.axes.remove(index);
    }

    public void removeAxis(String parameterName) {
        int i = 0;
        while (i < this.axes.size()) {
            if (parameterName.equals(this.axes.get(i).getParameter().getName())) {
                this.axes.remove(i);
                return;
            }
            ++i;
        }
        throw new IllegalArgumentException("Axis " + parameterName + " not found");
    }

    public void moveAxis(int oldIndex, int newIndex) {
        this.log("moveAxis called with arguments " + oldIndex + " and " + newIndex);
        Axis axis = this.axes.remove(oldIndex);
        this.axes.insertElementAt(axis, newIndex);
    }

    public DataSheet getDataSheet() {
        return this.dataSheet;
    }

    public void setDataSheet(DataSheet dataSheet) {
        this.dataSheet = dataSheet;
    }

    private void log(String message) {
    }

    public int getDesignLabelFontSize() {
        return this.designLabelFontSize;
    }

    public void setDesignLabelFontSize(int designLabelFontSize) {
        this.designLabelFontSize = designLabelFontSize;
    }

    public int getLineThickness() {
        return this.lineThickness;
    }

    public void setLineThickness(int lineThickness) {
        this.lineThickness = lineThickness;
    }

    public Color getDesignColor(Design design, boolean designActive) {
        if (designActive && design.getCluster() != null) {
            return design.getCluster().getActiveDesignColor();
        }
        if (designActive) {
            return this.activeDesignColor;
        }
        return this.filteredDesignColor;
    }

    public int getDesignLineThickness(Design design) {
        if (design.getCluster() != null) {
            return design.getCluster().getLineThickness();
        }
        return this.lineThickness;
    }

    public Color getDefaultDesignColor(boolean designActive) {
        if (designActive) {
            return this.activeDesignColor;
        }
        return this.filteredDesignColor;
    }

    public void setActiveDesignColor(Color activeDesignColor) {
        this.activeDesignColor = activeDesignColor;
    }

    public void setFilteredDesignColor(Color filteredDesignColor) {
        this.filteredDesignColor = filteredDesignColor;
    }

    public Color getBackGroundColor() {
        return this.backGroundColor;
    }

    public void setBackGroundColor(Color backGroundColor) {
        this.backGroundColor = backGroundColor;
    }

    public boolean isShowDesignIDs() {
        return this.showDesignIDs;
    }

    public void setShowDesignIDs(boolean showDesignIDs) {
        this.showDesignIDs = showDesignIDs;
    }

    public boolean isShowFilteredDesigns() {
        return this.showFilteredDesigns;
    }

    public void setShowFilteredDesigns(boolean showFilteredDesigns) {
        this.showFilteredDesigns = showFilteredDesigns;
    }

    public Color getFilterColor() {
        return this.filterColor;
    }

    public void setFilterColor(Color filterColor) {
        this.filterColor = filterColor;
    }

    public int getTopMargin() {
        return this.topMargin;
    }

    public void resetDisplaySettingsToDefault() {
        UserPreferences userPreferences = Main.getUserPreferences();
        this.backGroundColor = userPreferences.getDefaultBackgroundColor();
        this.showDesignIDs = userPreferences.isShowDesignIDs();
        this.showFilteredDesigns = userPreferences.isShowFilteredDesigns();
        this.activeDesignColor = userPreferences.getActiveDesignDefaultColor();
        this.filteredDesignColor = userPreferences.getFilteredDesignDefaultColor();
        this.designLabelFontSize = userPreferences.getDesignLabelFontSize();
        this.lineThickness = userPreferences.getLineThickness();
        this.verticallyOffsetAxisLabels = userPreferences.isVerticallyOffsetAxisLabels();
        this.filterColor = userPreferences.getFilterDefaultColor();
        this.filterHeight = userPreferences.getFilterHeight();
        this.filterWidth = userPreferences.getFilterWidth();
        int i = 0;
        while (i < this.axes.size()) {
            this.axes.get(i).resetSettingsToDefault();
            ++i;
        }
    }

    public int getFilterHeight() {
        return this.filterHeight;
    }

    public void setFilterHeight(int filterHeight) {
        this.filterHeight = filterHeight;
    }

    public int getFilterWidth() {
        return this.filterWidth;
    }

    public void setFilterWidth(int filterWidth) {
        this.filterWidth = filterWidth;
    }

    public void applyAllFilters() {
        int i = 0;
        while (i < this.dataSheet.getParameterCount()) {
            this.axes.get(i).applyFilters();
            ++i;
        }
    }

    public void autofitAllAxes() {
        int i = 0;
        while (i < this.axes.size()) {
            this.axes.get(i).autofit();
            ++i;
        }
    }

    public void evaluateBoundsForAllDesigns() {
        this.dataSheet.evaluateBoundsForAllDesigns(this);
    }

    public Dimension getSize() {
        return this.size;
    }

    public void setSize(Dimension size) {
        this.size = size;
    }

    public Point getLocation() {
        return this.location;
    }

    public void setLocation(Point location) {
        this.location = location;
    }
}

