/*
 * Decompiled with CFR 0.152.
 */
package actionListeners;

import gui.dialogs.ClusterDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import xdat.Main;

public class ClusterDialogActionListener
implements ActionListener {
    static final boolean printLog = false;
    private Main mainWindow;
    private ClusterDialog dialog;

    public ClusterDialogActionListener(Main mainWindow, ClusterDialog dialog) {
        this.mainWindow = mainWindow;
        this.dialog = dialog;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        this.log("Action Command = " + actionCommand);
        if (actionCommand.equals("Add")) {
            this.log(" adding cluster to buffer.");
            this.dialog.getDataSheet().getClusterSet().addClusterToBuffer();
        } else if (actionCommand.equals("Remove")) {
            int[] selectedRows = this.dialog.getClusterTable().getSelectedRows();
            int i = selectedRows.length - 1;
            while (i >= 0) {
                this.dialog.getDataSheet().getClusterSet().removeClusterFromBuffer(selectedRows[i]);
                --i;
            }
        } else if (actionCommand.equals("Cancel")) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
        } else if (actionCommand.equals("Ok")) {
            if (this.dialog.getClusterTable().isEditing() && this.dialog.getClusterTable().getCellEditor() != null) {
                this.dialog.getClusterTable().getCellEditor().stopCellEditing();
            }
            this.dialog.getDataSheet().getClusterSet().applyChanges();
            int i = 0;
            while (i < this.mainWindow.getChartFrameCount()) {
                this.mainWindow.getChartFrame(i).getClusterMenu().updateClusterList();
                this.mainWindow.getChartFrame(i).validate();
                this.mainWindow.getChartFrame(i).repaint();
                ++i;
            }
            this.dialog.setVisible(false);
            this.dialog.dispose();
        }
    }

    private void log(String message) {
    }
}

