/*
 * Decompiled with CFR 0.152.
 */
package xdat;

import chart.Chart;
import data.DataSheet;
import gui.WindowClosingAdapter;
import gui.dialogs.LicenseDisplayDialog;
import gui.frames.ChartFrame;
import gui.menus.MainMenuBar;
import gui.panels.DataSheetTablePanel;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InvalidClassException;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import xdat.Session;
import xdat.UserPreferences;

public class Main
extends JFrame {
    public static final long serialVersionUID = 5L;
    public static final String versionString = "1.7";
    public static final boolean loggingEnabled = false;
    public static final boolean printLog = false;
    private MainMenuBar mainMenuBar;
    private transient DataSheetTablePanel dataSheetTablePanel;
    private Session currentSession;
    private Vector<ChartFrame> chartFrames = new Vector(0, 1);

    public Main() {
        super("xdat   -   Untitled");
        new UserPreferences(versionString);
        if (!this.checkLicense()) {
            this.dispose();
            return;
        }
        this.currentSession = new Session();
        this.addWindowListener(new WindowClosingAdapter(true));
        this.mainMenuBar = new MainMenuBar(this);
        this.setJMenuBar(this.mainMenuBar);
        Dimension screenSize = this.getToolkit().getScreenSize();
        this.setLocation((int)(0.25 * (double)screenSize.width), (int)(0.25 * (double)screenSize.height));
        this.setSize((int)(0.5 * (double)screenSize.width), (int)(0.5 * (double)screenSize.height));
        this.setVisible(true);
    }

    public void updateDataPanel() {
        this.log("updateDataPanel called");
        if (this.currentSession.getCurrentDataSheet() != null) {
            this.log("updateDataPanel: DataSheet non-null");
            this.dataSheetTablePanel = new DataSheetTablePanel(this, this.currentSession.getCurrentDataSheet());
            this.setContentPane(this.dataSheetTablePanel);
            this.dataSheetTablePanel.revalidate();
        } else {
            this.setContentPane(new JPanel());
            this.repaint();
        }
    }

    public static void main(String[] args) {
        new Main();
    }

    public DataSheet getDataSheet() {
        return this.currentSession.getCurrentDataSheet();
    }

    public void setDataSheet(DataSheet dataSheet) {
        this.currentSession.setCurrentDataSheet(dataSheet);
        if (dataSheet == null) {
            this.remove(this.dataSheetTablePanel);
        }
        this.updateDataPanel();
        this.repaint();
    }

    public static UserPreferences getUserPreferences() {
        return new UserPreferences(versionString);
    }

    public static String getVersionString() {
        return versionString;
    }

    public Session getCurrentSession() {
        return this.currentSession;
    }

    public void setCurrentSession(Session currentSession) {
        this.currentSession = currentSession;
    }

    public void addChartFrame(ChartFrame chartFrame) {
        this.chartFrames.add(chartFrame);
    }

    public void removeChartFrame(ChartFrame chartFrame) {
        this.chartFrames.remove(chartFrame);
        this.currentSession.removeChart(chartFrame.getChart());
    }

    public ChartFrame getChartFrame(int index) {
        return this.chartFrames.get(index);
    }

    public int getChartFrameCount() {
        return this.chartFrames.size();
    }

    public void disposeAllChartFrames() {
        int i = this.chartFrames.size() - 1;
        while (i >= 0) {
            this.chartFrames.get(i).dispose();
            --i;
        }
        this.chartFrames.removeAllElements();
        this.currentSession.clearAllCharts();
    }

    public void updateAllChartFrames() {
        this.log("updateAllChartFrames:------------------------------------- ");
        Chart[] charts = new Chart[this.currentSession.getChartCount()];
        this.log("updateAllChartFrames: currently " + charts.length + " charts active. ");
        int i = 0;
        while (i < charts.length) {
            this.log("updateAllChartFrames: reading chart " + i);
            charts[i] = this.currentSession.getChart(i);
            ++i;
        }
        this.disposeAllChartFrames();
        this.log("updateAllChartFrames: still " + charts.length + " charts active. ");
        i = 0;
        while (i < charts.length) {
            this.log("updateAllChartFrames: creating chart " + i);
            this.chartFrames.add(new ChartFrame(this, charts[i]));
            this.currentSession.addChart(charts[i]);
            charts[i].autofitAllAxes();
            charts[i].evaluateBoundsForAllDesigns();
            charts[i].applyAllFilters();
            ++i;
        }
        this.log("updateAllChartFrames: done. Session has now " + this.currentSession.getChartCount() + " active charts.");
    }

    public void repaintAllChartFrames() {
        int i = 0;
        while (i < this.chartFrames.size()) {
            this.chartFrames.get(i).repaint();
            ++i;
        }
    }

    public void refilterAllChartFrames(int columnIndex) {
        int i = 0;
        while (i < this.chartFrames.size()) {
            this.chartFrames.get(i).getChart().getAxis(columnIndex).applyFilters();
            ++i;
        }
    }

    public void autofitAxisAllChartFrames(int axisIndex) {
        int i = 0;
        while (i < this.chartFrames.size()) {
            this.chartFrames.get(i).getChart().getAxis(axisIndex).autofit();
            ++i;
        }
    }

    public void resetFiltersOnAxisAllChartFrames(int axisIndex) {
        int i = 0;
        while (i < this.chartFrames.size()) {
            this.chartFrames.get(i).getChart().getAxis(axisIndex).resetFilters();
            ++i;
        }
    }

    public void loadSession(String pathToFile) {
        try {
            this.disposeAllChartFrames();
            this.currentSession = Session.readFromFile(this, pathToFile);
            this.setTitle("xdat   -   " + pathToFile);
            this.log("loadSession called. " + this.getChartFrameCount() + " chart frames to load.");
            ChartFrame[] chartFrames = new ChartFrame[this.currentSession.getChartCount()];
            int i = 0;
            while (i < chartFrames.length) {
                new ChartFrame(this, this.currentSession.getChart(i));
                ++i;
            }
            if (this.currentSession.getCurrentDataSheet() != null) {
                this.getMainMenuBar().setItemsRequiringDataSheetEnabled(true);
            } else {
                this.updateDataPanel();
                this.getMainMenuBar().setItemsRequiringDataSheetEnabled(false);
            }
        }
        catch (InvalidClassException e) {
            JOptionPane.showMessageDialog(this, "The file " + pathToFile + " is not a proper xdat version " + versionString + " Session file", "Load Session", 0);
        }
        catch (ClassNotFoundException e) {
            JOptionPane.showMessageDialog(this, "The file " + pathToFile + " is not a proper xdat version " + versionString + " Session file", "Load Session", 0);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Error on loading session: " + e.getMessage(), "Load Session", 0);
        }
    }

    public void saveSessionAs(String pathToFile) {
        int i = 0;
        while (i < this.currentSession.getChartCount()) {
            this.log("saving session with chart " + i);
            ++i;
        }
        try {
            this.currentSession.saveToFile(pathToFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean checkLicense() {
        if (!Main.getUserPreferences().isLicenseAccepted()) {
            new LicenseDisplayDialog(Main.getUserPreferences());
        }
        return Main.getUserPreferences().isLicenseAccepted();
    }

    public static boolean isLoggingEnabled() {
        return false;
    }

    public MainMenuBar getMainMenuBar() {
        return this.mainMenuBar;
    }

    private void log(String message) {
    }

    public DataSheetTablePanel getDataSheetTablePanel() {
        return this.dataSheetTablePanel;
    }
}

