/*
 * Decompiled with CFR 0.152.
 */
package actionListeners;

import chart.Axis;
import chart.Chart;
import gui.dialogs.DisplaySettingsDialog;
import gui.frames.ChartFrame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import xdat.Main;

public class ChartSpecificDisplaySettingsDialogActionListener
implements ActionListener {
    static final boolean printLog = false;
    private DisplaySettingsDialog dialog;
    private Chart chart;
    private ChartFrame chartFrame;

    public ChartSpecificDisplaySettingsDialogActionListener(Main mainWindow, DisplaySettingsDialog dialog, Chart chart, ChartFrame chartFrame) {
        this.chart = chart;
        this.dialog = dialog;
        this.chartFrame = chartFrame;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand == "Ok") {
            Axis axis = this.chart.getAxis(this.dialog.getAxisDisplaySettingsPanel().getAxisChoiceCombo().getSelectedItem().toString());
            double[] upperFilterValues = new double[this.chart.getAxisCount()];
            double[] lowerFilterValues = new double[this.chart.getAxisCount()];
            int i = 0;
            while (i < this.chart.getAxisCount()) {
                upperFilterValues[i] = this.chart.getAxis(i).getLowerFilter().getValue();
                lowerFilterValues[i] = this.chart.getAxis(i).getUpperFilter().getValue();
                ++i;
            }
            this.log(" Ok pressed");
            this.chart.setAxisHeight((Integer)this.dialog.getChartDisplaySettingsPanel().getAxisHeightSpinner().getValue());
            this.chart.setVerticallyOffsetAxisLabels(this.dialog.getChartDisplaySettingsPanel().getAxisLabelVerticalOffsetCheckbox().isSelected());
            this.chart.setBackGroundColor(this.dialog.getChartDisplaySettingsPanel().getChartDisplaySettingsActionListener().getBackGroundColor());
            this.chart.setActiveDesignColor(this.dialog.getChartDisplaySettingsPanel().getChartDisplaySettingsActionListener().getActiveDesignColor());
            this.chart.setFilteredDesignColor(this.dialog.getChartDisplaySettingsPanel().getChartDisplaySettingsActionListener().getFilteredDesignColor());
            this.chart.setFilterColor(this.dialog.getChartDisplaySettingsPanel().getChartDisplaySettingsActionListener().getFilterColor());
            this.chart.setShowDesignIDs(this.dialog.getChartDisplaySettingsPanel().getChartDisplaySettingsActionListener().isShowDesignIDs());
            this.chart.setShowFilteredDesigns(this.dialog.getChartDisplaySettingsPanel().getChartDisplaySettingsActionListener().isShowFilteredDesigns());
            this.chart.setDesignLabelFontSize((Integer)this.dialog.getChartDisplaySettingsPanel().getDesignLabelFontSizeSpinner().getValue());
            this.chart.setFilterWidth((Integer)this.dialog.getChartDisplaySettingsPanel().getFilterWidthSpinner().getValue());
            this.chart.setFilterHeight((Integer)this.dialog.getChartDisplaySettingsPanel().getFilterHeightSpinner().getValue());
            axis.setAxisColor(this.dialog.getAxisDisplaySettingsPanel().getAxisDisplaySettingsActionListener().getAxisColor());
            axis.setWidth((Integer)this.dialog.getAxisDisplaySettingsPanel().getAxisWidthSpinner().getValue());
            axis.setAxisLabelFontColor(this.dialog.getAxisDisplaySettingsPanel().getAxisDisplaySettingsActionListener().getAxisLabelColor());
            axis.setAxisLabelFontSize((Integer)this.dialog.getAxisDisplaySettingsPanel().getAxisLabelFontSizeSpinner().getValue());
            axis.setTicLength((Integer)this.dialog.getAxisDisplaySettingsPanel().getTicSizeSpinner().getValue());
            axis.setTicCount((Integer)this.dialog.getAxisDisplaySettingsPanel().getTicCountSpinner().getValue());
            axis.setTicLabelFontColor(this.dialog.getAxisDisplaySettingsPanel().getAxisDisplaySettingsActionListener().getTicLabelColor());
            axis.setTicLabelFontSize((Integer)this.dialog.getAxisDisplaySettingsPanel().getTicLabelFontSizeSpinner().getValue());
            axis.setFilterInverted(this.dialog.getAxisDisplaySettingsPanel().getAxisDisplaySettingsActionListener().isInvertFilter());
            axis.setAxisInverted(this.dialog.getAxisDisplaySettingsPanel().getAxisDisplaySettingsActionListener().isInvertAxis());
            axis.setAutoFit(this.dialog.getAxisDisplaySettingsPanel().getAxisDisplaySettingsActionListener().isAutoFitAxis());
            if (axis.isAutoFit()) {
                axis.autofit();
            } else {
                if (this.dialog.getAxisDisplaySettingsPanel().getAxisMin() < this.dialog.getAxisDisplaySettingsPanel().getAxisMax()) {
                    axis.setMin(this.dialog.getAxisDisplaySettingsPanel().getAxisMin());
                }
                if (this.dialog.getAxisDisplaySettingsPanel().getAxisMax() > axis.getMin()) {
                    axis.setMax(this.dialog.getAxisDisplaySettingsPanel().getAxisMax());
                }
            }
            i = 0;
            while (i < this.chart.getAxisCount()) {
                if (this.chart.getAxis(i).isAxisInverted()) {
                    this.chart.getAxis(i).getUpperFilter().setValue(Math.min(upperFilterValues[i], lowerFilterValues[i]));
                    this.chart.getAxis(i).getLowerFilter().setValue(Math.max(upperFilterValues[i], lowerFilterValues[i]));
                } else {
                    this.chart.getAxis(i).getUpperFilter().setValue(Math.max(upperFilterValues[i], lowerFilterValues[i]));
                    this.chart.getAxis(i).getLowerFilter().setValue(Math.min(upperFilterValues[i], lowerFilterValues[i]));
                }
                ++i;
            }
            this.chartFrame.getChartPanel().setSize(this.chartFrame.getChartPanel().getPreferredSize());
            this.chartFrame.repaint();
            this.dialog.dispose();
        } else if (actionCommand == "Cancel") {
            this.dialog.dispose();
        } else if (actionCommand != "Yes" && actionCommand != "No") {
            System.out.println("ChartSpecificDisplaySettingsDialogActionListener: " + e.getActionCommand());
        }
    }

    private void log(String message) {
    }
}

