/*
 * Decompiled with CFR 0.152.
 */
package actionListeners;

import gui.dialogs.ParameterSetSelectionDialog;
import gui.frames.ChartFrame;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import xdat.Main;

public class ChartFrameSelectParametersMenuActionListener
implements ActionListener {
    static final boolean printLog = false;
    private Main mainWindow;
    private ChartFrame chartFrame;

    public ChartFrameSelectParametersMenuActionListener(Main mainWindow, ChartFrame chartFrame) {
        this.mainWindow = mainWindow;
        this.chartFrame = chartFrame;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        this.log("Action Command = " + actionCommand);
        if (actionCommand.equals("Select All")) {
            Component[] menuComps = this.chartFrame.getJMenuBar().getMenu(0).getMenuComponents();
            int i = 0;
            while (i < menuComps.length) {
                if (menuComps[i].getClass().equals(JCheckBoxMenuItem.class)) {
                    ((JCheckBoxMenuItem)menuComps[i]).setState(true);
                    this.chartFrame.getChart().getAxis(((JCheckBoxMenuItem)menuComps[i]).getText()).setActive(true);
                }
                ++i;
            }
        } else if (actionCommand.equals("Unselect All")) {
            Component[] menuComps = this.chartFrame.getJMenuBar().getMenu(0).getMenuComponents();
            int i = 0;
            while (i < menuComps.length) {
                if (menuComps[i].getClass().equals(JCheckBoxMenuItem.class)) {
                    ((JCheckBoxMenuItem)menuComps[i]).setState(false);
                    this.chartFrame.getChart().getAxis(((JCheckBoxMenuItem)menuComps[i]).getText()).setActive(false);
                }
                ++i;
            }
        } else if (actionCommand.equals("Reverse Selection")) {
            Component[] menuComps = this.chartFrame.getJMenuBar().getMenu(0).getMenuComponents();
            int i = 0;
            while (i < menuComps.length) {
                if (menuComps[i].getClass().equals(JCheckBoxMenuItem.class)) {
                    ((JCheckBoxMenuItem)menuComps[i]).setState(!((JCheckBoxMenuItem)menuComps[i]).getState());
                    this.chartFrame.getChart().getAxis(((JCheckBoxMenuItem)menuComps[i]).getText()).setActive(!this.chartFrame.getChart().getAxis(((JCheckBoxMenuItem)menuComps[i]).getText()).isActive());
                }
                ++i;
            }
        } else if (actionCommand.equals("Custom Selection")) {
            this.log("creating ParameterSetSelectionDialog");
            new ParameterSetSelectionDialog(this.mainWindow, this.chartFrame);
        } else {
            this.log("Axis " + actionCommand + " active is " + this.chartFrame.getChart().getAxis(actionCommand).isActive());
            this.chartFrame.getChart().getAxis(actionCommand).setActive(!this.chartFrame.getChart().getAxis(actionCommand).isActive());
            this.log("After state change axis " + actionCommand + " active is " + this.chartFrame.getChart().getAxis(actionCommand).isActive());
        }
        this.chartFrame.getChartPanel().setSize(this.chartFrame.getChartPanel().getPreferredSize());
        this.chartFrame.validate();
        this.chartFrame.repaint();
    }

    private void log(String message) {
    }
}

