/*
 *  Copyright 2011, Enguerrand de Rochefort
 * 
 * This file is part of xdat.
 *
 * xdat is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * xdat is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with xdat.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package gui.tables;

import javax.swing.table.*;
import chart.Chart;
import xdat.Main;
import data.DataSheet;

/**
 * A column model for the JTable that displays the {@link data.DataSheet}.
 */
public class DataSheetTableColumnModel
extends DefaultTableColumnModel 
{
	
	/** The version tracking unique identifier for Serialization. */
	static final long serialVersionUID = 0002;

	/** A reference to the mainWindow. */
	private Main mainWindow;
	
	/** The data sheet. */
	private DataSheet dataSheet;
	
	/**
	 * Instantiates a new generic table column model.
	 */
	public DataSheetTableColumnModel(Main mainWindow, DataSheet dataSheet)
	{
		super();
		this.mainWindow = mainWindow;
		this.dataSheet = dataSheet;
		this.setColumnMargin(1);
	}

	/* (non-Javadoc)
	 * @see javax.swing.table.DefaultTableColumnModel#getColumnSelectionAllowed()
	 */
	public boolean getColumnSelectionAllowed() 
	{
		return false;
	}

	/* (non-Javadoc)
	 * @see javax.swing.table.DefaultTableColumnModel#moveColumn(int, int)
	 */
	public void moveColumn(int src, int tar) 
	{
		if(src !=0 && tar !=0)
		{
			super.moveColumn(src, tar);
			if(src!=tar)
			{
				this.dataSheet.moveParameter(src-1, tar-1);
				for(int i=0; i<this.getColumnCount();i++)
				{
					this.getColumn(i).setModelIndex(i);
				}
				Chart[] charts = new Chart[this.mainWindow.getCurrentSession().getChartCount()];
				for(int i=0; i<charts.length; i++)
				{
					charts[i] = (this.mainWindow.getCurrentSession().getChart(i));
					charts[i].moveAxis(src-1, tar-1);
				}	
				this.mainWindow.repaintAllChartFrames();
			}
		}
	}

	/* (non-Javadoc)
	 * @see javax.swing.table.DefaultTableColumnModel#removeColumn(javax.swing.table.TableColumn)
	 */
	public void removeColumn(TableColumn arg0) 
	{
		
	}
}