/*
 *  Copyright 2011, Enguerrand de Rochefort
 * 
 * This file is part of xdat.
 *
 * xdat is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * xdat is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with xdat.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
package actionListeners;

import gui.frames.ChartFrame;
import gui.menus.ChartFrameAddDesignToClusterMenu;

import java.awt.event.*;

import xdat.*;

import data.*;


/**
 * ActionListener for the {@link ChartFrameAddDesignToClusterMenu} to add a {@link Design} to a {@link Cluster}.
 */
public class ChartFrameAddDesignToClusterMenuActionListener 
implements ActionListener
{
	
	/** Flag to enable debug message printing for this class. */
	static final boolean printLog=false;
	
	/** The main window. */
	private Main mainWindow;
	
	/** The chart frame. */
	private ChartFrame chartFrame;
	
	/**
	 * Instantiates this class.
	 *
	 * @param mainWindow the main window
	 * @param chartFrame the chart frame
	 */
	public ChartFrameAddDesignToClusterMenuActionListener(Main mainWindow, ChartFrame chartFrame)
	{
		this.mainWindow = mainWindow;
		this.chartFrame = chartFrame;
		
	}
	
	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e)
	{
		String actionCommand = e.getActionCommand();
		log("Action Command = "+actionCommand);
		DataSheet dataSheet = chartFrame.getChart().getDataSheet();
		Cluster cluster = dataSheet.getClusterSet().getCluster(actionCommand);
				
		for(int i=0; i<dataSheet.getDesignCount(); i++)
		{
			if(dataSheet.getDesign(i).isActive(chartFrame.getChart()))
			{
				dataSheet.getDesign(i).setCluster(cluster);
			}
		}
		this.chartFrame.getChartPanel().setPreferredSize(this.chartFrame.getChartPanel().getPreferredSize());

		for(int i=0; i<this.mainWindow.getChartFrameCount(); i++)
		{
			this.mainWindow.getChartFrame(i).getClusterMenu().updateClusterList();
			this.mainWindow.getChartFrame(i).validate();
			this.mainWindow.getChartFrame(i).repaint();
		}
	}

	/**
	 * Prints debug information to stdout when printLog is set to true.
	 *
	 * @param message the message
	 */
	private void log(String message)
	{
		if(ChartFrameAddDesignToClusterMenuActionListener.printLog && Main.isLoggingEnabled())
		{
			System.out.println(this.getClass().getName()+"."+message);
		}
	}	
}
