/*
 * Decompiled with CFR 0.152.
 */
package gui.tables;

import customEvents.DataTableModelEvent;
import data.DataSheet;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumnModel;
import xdat.Main;

public class DataTable
extends JTable {
    static final long serialVersionUID = 1L;
    static final boolean printLog = false;
    private Main mainWindow;

    public DataTable(DataSheet dataSheet, TableColumnModel cm, Main mainWindow) {
        super(dataSheet, cm);
        this.mainWindow = mainWindow;
        this.log("mainWindow: " + mainWindow);
        this.log("this.mainWindow: " + this.mainWindow);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
        if (e.getType() == 999) {
            DataTableModelEvent ec = (DataTableModelEvent)e;
            boolean[] autofitRequired = ec.getAxisAutofitRequired();
            boolean[] resetFiltersRequired = ec.getAxisResetFilterRequired();
            boolean[] applyFiltersRequired = ec.getAxisApplyFiltersRequired();
            int i = 0;
            while (i < this.mainWindow.getDataSheet().getParameterCount()) {
                if (autofitRequired[i]) {
                    this.mainWindow.autofitAxisAllChartFrames(i);
                }
                if (resetFiltersRequired[i]) {
                    this.mainWindow.resetFiltersOnAxisAllChartFrames(i);
                }
                if (applyFiltersRequired[i]) {
                    this.mainWindow.refilterAllChartFrames(i);
                }
                ++i;
            }
            if (ec.isChartRebuildRequired()) {
                this.mainWindow.updateAllChartFrames();
            }
            if (ec.isChartRepaintRequired()) {
                this.mainWindow.repaintAllChartFrames();
            }
            if (ec.isDataPanelUpdateRequired()) {
                this.mainWindow.updateDataPanel();
            }
        }
    }

    private void log(String message) {
    }
}

