/*
 * Decompiled with CFR 0.152.
 */
package data;

import chart.Axis;
import chart.Chart;
import chart.Filter;
import data.Cluster;
import data.NumberParser;
import data.Parameter;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Hashtable;

public class Design
implements Serializable {
    static final long serialVersionUID = 4L;
    static final boolean printLog = false;
    private Hashtable<Parameter, String> parameterValues = new Hashtable(0, 1.0f);
    private int id;
    private Cluster cluster;
    private Hashtable<Filter, Boolean> activationMap = new Hashtable(0, 1.0f);
    private boolean insideBounds;

    public Design(int id) {
        this.id = id;
    }

    public void setValue(Parameter param, String parameterValue) {
        this.parameterValues.put(param, parameterValue);
        if (param.isNumeric()) {
            try {
                NumberParser.parseNumber(parameterValue.toString());
                param.setAtLeastOneNumeric(true);
            }
            catch (ParseException e1) {
                this.log("setValue: parameterValue " + parameterValue + " was not recogized as numeric. Parameter " + param.getName() + " set to non-numeric.");
                param.setNumeric(false);
            }
        }
    }

    public double getDoubleValue(Parameter param) {
        if (this.parameterValues.containsKey(param)) {
            return param.getDoubleValueOf(this.parameterValues.get(param));
        }
        throw new IllegalArgumentException("Unknown parameter " + param.getName());
    }

    public String getStringValue(Parameter param) {
        if (this.parameterValues.containsKey(param)) {
            return this.parameterValues.get(param);
        }
        throw new IllegalArgumentException("Unknown parameter " + param.getName());
    }

    public void removeParameter(Parameter param) {
        if (!this.parameterValues.containsKey(param)) {
            throw new IllegalArgumentException("Unknown parameter " + param.getName());
        }
        this.parameterValues.remove(param);
    }

    public boolean isActive(Chart chart) {
        int i = 0;
        while (i < chart.getAxisCount()) {
            Filter uf = chart.getAxis(i).getUpperFilter();
            Filter lf = chart.getAxis(i).getLowerFilter();
            if (!this.activationMap.containsKey(uf)) {
                this.activationMap.put(uf, true);
            }
            if (!this.activationMap.containsKey(lf)) {
                this.activationMap.put(lf, true);
            }
            if (chart.getAxis(i).isFilterInverted()) {
                if (!this.activationMap.get(uf).booleanValue() && !this.activationMap.get(lf).booleanValue()) {
                    return false;
                }
            } else {
                if (!this.activationMap.get(uf).booleanValue()) {
                    return false;
                }
                if (!this.activationMap.get(lf).booleanValue()) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public void setActive(Filter filter, boolean active) {
        this.activationMap.put(filter, active);
    }

    public void evaluateBounds(Chart chart) {
        this.insideBounds = true;
        int i = 0;
        while (i < chart.getAxisCount()) {
            if (!this.isInsideBounds(chart.getAxis(i))) {
                this.insideBounds = false;
                return;
            }
            ++i;
        }
    }

    private boolean isInsideBounds(Axis axis) {
        double value = this.getDoubleValue(axis.getParameter());
        double max = axis.getMax();
        double min = axis.getMin();
        return min <= value && value <= max;
    }

    public boolean isInsideBounds(Chart chart) {
        return this.insideBounds;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    private void log(String message) {
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }
}

